/*
 * Decompiled with CFR 0.152.
 */
package com.cursee.monolib.impl.common.command.data;

import com.cursee.monolib.impl.common.command.data.FormatArgument;
import com.cursee.monolib.impl.common.command.data.SlotArgument;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Arrays;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class DataSubCommand {
    private static final int FAILURE = 0;

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"monolib").then(Commands.literal((String)"data").then(Commands.argument((String)"slot", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            Arrays.stream(SlotArgument.values()).forEach(slot -> builder.suggest(slot.getCommandName()));
            return builder.buildFuture();
        }).then(Commands.argument((String)"format", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            Arrays.stream(FormatArgument.values()).forEach(format -> builder.suggest(format.getCommandName()));
            return builder.buildFuture();
        }).executes(DataSubCommand::execute)))));
    }

    private static int execute(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Entity entity = source.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return 0;
        }
        LivingEntity living = (LivingEntity)entity;
        try {
            String slotName = StringArgumentType.getString(context, (String)"slot");
            String formatName = StringArgumentType.getString(context, (String)"format");
            SlotArgument slotArgument = SlotArgument.valueOf(slotName.toUpperCase());
            FormatArgument formatArgument = FormatArgument.valueOf(formatName.toUpperCase());
            ItemStack itemStack = slotArgument.getItemFromEntity(living);
            source.sendSuccess(() -> formatArgument.getFormat().formatItem(itemStack, source.getLevel()), false);
        }
        catch (IllegalArgumentException e) {
            Entity entity2 = source.getEntity();
            if (entity2 instanceof Player) {
                Player player = (Player)entity2;
                player.displayClientMessage((Component)Component.literal((String)("Illegal arguments for 'monolib data' command: " + context.getInput())), false);
            }
            return 0;
        }
        return 1;
    }
}

