/*
 * Decompiled with CFR 0.152.
 */
package com.cursee.monolib.impl.common.serialization.codecs.map;

import com.cursee.monolib.Constants;
import com.cursee.monolib.impl.common.serialization.codecs.map.MapCodecHelper;
import com.cursee.monolib.impl.common.serialization.codecs.map.RegistryMapCodecHelper;
import com.cursee.monolib.impl.common.serialization.conditions.ILoadCondition;
import com.cursee.monolib.impl.common.serialization.conditions.LoadConditions;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import net.minecraft.Optionull;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.numbers.NumberFormatType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.StatType;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.valueproviders.FloatProviderType;
import net.minecraft.util.valueproviders.IntProviderType;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.item.enchantment.effects.EnchantmentLocationBasedEffect;
import net.minecraft.world.item.enchantment.effects.EnchantmentValueEffect;
import net.minecraft.world.item.enchantment.providers.EnchantmentProvider;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.DecoratedPotPattern;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.PositionSourceType;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicateType;
import net.minecraft.world.level.levelgen.carver.WorldCarver;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSizeType;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.minecraft.world.level.levelgen.feature.rootplacers.RootPlacerType;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProviderType;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import net.minecraft.world.level.levelgen.heightproviders.HeightProviderType;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElementType;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasBinding;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTestType;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTestType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.RuleBlockEntityModifierType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.providers.nbt.LootNbtProviderType;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.score.LootScoreProviderType;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.joml.Vector3f;

public class MapCodecs {
    public static final MapCodecHelper<Boolean> BOOLEAN = new MapCodecHelper<Boolean>((Codec<Boolean>)Codec.BOOL, (T[])new Boolean[0]);
    public static final MapCodecHelper<Byte> BYTE = new MapCodecHelper<Byte>((Codec<Byte>)Codec.BYTE, (T[])new Byte[0]);
    public static final MapCodecHelper<Short> SHORT = new MapCodecHelper<Short>((Codec<Short>)Codec.SHORT, (T[])new Short[0]);
    public static final MapCodecHelper<Integer> INT = new MapCodecHelper<Integer>((Codec<Integer>)Codec.INT, (T[])new Integer[0]);
    public static final MapCodecHelper<Float> FLOAT = new MapCodecHelper<Float>((Codec<Float>)Codec.FLOAT, (T[])new Float[0]);
    public static final MapCodecHelper<Long> LONG = new MapCodecHelper<Long>((Codec<Long>)Codec.LONG, (T[])new Long[0]);
    public static final MapCodecHelper<Double> DOUBLE = new MapCodecHelper<Double>((Codec<Double>)Codec.DOUBLE, (T[])new Double[0]);
    public static final MapCodecHelper<String> STRING = new MapCodecHelper<String>((Codec<String>)Codec.STRING, (T[])new String[0]);
    public static final MapCodecHelper<UUID> UUID = new MapCodecHelper<UUID>(UUIDUtil.CODEC, new UUID[0]);
    public static final MapCodecHelper<Holder<GameEvent>> GAME_EVENT = RegistryMapCodecHelper.create(BuiltInRegistries.GAME_EVENT);
    public static final MapCodecHelper<Holder<SoundEvent>> SOUND_EVENT = RegistryMapCodecHelper.create(BuiltInRegistries.SOUND_EVENT);
    public static final MapCodecHelper<Holder<Fluid>> FLUID = RegistryMapCodecHelper.create(BuiltInRegistries.FLUID);
    public static final MapCodecHelper<Holder<MobEffect>> MOB_EFFECT = RegistryMapCodecHelper.create(BuiltInRegistries.MOB_EFFECT);
    public static final MapCodecHelper<Holder<Block>> BLOCK = RegistryMapCodecHelper.create(BuiltInRegistries.BLOCK);
    public static final MapCodecHelper<Holder<EntityType<?>>> ENTITY_TYPE = RegistryMapCodecHelper.create(BuiltInRegistries.ENTITY_TYPE);
    public static final MapCodecHelper<Holder<Item>> ITEM = RegistryMapCodecHelper.create(BuiltInRegistries.ITEM);
    public static final MapCodecHelper<Holder<Potion>> POTION = RegistryMapCodecHelper.create(BuiltInRegistries.POTION);
    public static final MapCodecHelper<Holder<ParticleType<?>>> PARTICLE_TYPE = RegistryMapCodecHelper.create(BuiltInRegistries.PARTICLE_TYPE);
    public static final MapCodecHelper<Holder<BlockEntityType<?>>> BLOCK_ENTITY_TYPE = RegistryMapCodecHelper.create(BuiltInRegistries.BLOCK_ENTITY_TYPE);
    public static final MapCodecHelper<Holder<ResourceLocation>> CUSTOM_STAT = RegistryMapCodecHelper.create(BuiltInRegistries.CUSTOM_STAT);
    public static final MapCodecHelper<Holder<ChunkStatus>> CHUNK_STATUS = RegistryMapCodecHelper.create(BuiltInRegistries.CHUNK_STATUS);
    public static final MapCodecHelper<Holder<RuleTestType<?>>> RULE_TEST = RegistryMapCodecHelper.create(BuiltInRegistries.RULE_TEST);
    public static final MapCodecHelper<Holder<RuleBlockEntityModifierType<?>>> RULE_BLOCK_ENTITY_MODIFIER = RegistryMapCodecHelper.create(BuiltInRegistries.RULE_BLOCK_ENTITY_MODIFIER);
    public static final MapCodecHelper<Holder<PosRuleTestType<?>>> POS_RULE_TEST = RegistryMapCodecHelper.create(BuiltInRegistries.POS_RULE_TEST);
    public static final MapCodecHelper<Holder<MenuType<?>>> MENU = RegistryMapCodecHelper.create(BuiltInRegistries.MENU);
    public static final MapCodecHelper<Holder<RecipeType<?>>> RECIPE_TYPE = RegistryMapCodecHelper.create(BuiltInRegistries.RECIPE_TYPE);
    public static final MapCodecHelper<Holder<RecipeSerializer<?>>> RECIPE_SERIALIZER = RegistryMapCodecHelper.create(BuiltInRegistries.RECIPE_SERIALIZER);
    public static final MapCodecHelper<Holder<Attribute>> ATTRIBUTE = RegistryMapCodecHelper.create(BuiltInRegistries.ATTRIBUTE);
    public static final MapCodecHelper<Holder<PositionSourceType<?>>> POSITION_SOURCE_TYPE = RegistryMapCodecHelper.create(BuiltInRegistries.POSITION_SOURCE_TYPE);
    public static final MapCodecHelper<Holder<ArgumentTypeInfo<?, ?>>> COMMAND_ARGUMENT_TYPE = RegistryMapCodecHelper.create(BuiltInRegistries.COMMAND_ARGUMENT_TYPE);
    public static final MapCodecHelper<Holder<StatType<?>>> STAT_TYPE = RegistryMapCodecHelper.create(BuiltInRegistries.STAT_TYPE);
    public static final MapCodecHelper<Holder<VillagerType>> VILLAGER_TYPE = RegistryMapCodecHelper.create(BuiltInRegistries.VILLAGER_TYPE);
    public static final MapCodecHelper<Holder<VillagerProfession>> VILLAGER_PROFESSION = RegistryMapCodecHelper.create(BuiltInRegistries.VILLAGER_PROFESSION);
    public static final MapCodecHelper<Holder<PoiType>> POINT_OF_INTEREST_TYPE = RegistryMapCodecHelper.create(BuiltInRegistries.POINT_OF_INTEREST_TYPE);
    public static final MapCodecHelper<Holder<MemoryModuleType<?>>> MEMORY_MODULE_TYPE = RegistryMapCodecHelper.create(BuiltInRegistries.MEMORY_MODULE_TYPE);
    public static final MapCodecHelper<Holder<SensorType<?>>> SENSOR_TYPE = RegistryMapCodecHelper.create(BuiltInRegistries.SENSOR_TYPE);
    public static final MapCodecHelper<Holder<Schedule>> SCHEDULE = RegistryMapCodecHelper.create(BuiltInRegistries.SCHEDULE);
    public static final MapCodecHelper<Holder<Activity>> ACTIVITY = RegistryMapCodecHelper.create(BuiltInRegistries.ACTIVITY);
    public static final MapCodecHelper<Holder<LootPoolEntryType>> LOOT_POOL_ENTRY_TYPE = RegistryMapCodecHelper.create(BuiltInRegistries.LOOT_POOL_ENTRY_TYPE);
    public static final MapCodecHelper<Holder<LootItemFunctionType<?>>> LOOT_FUNCTION_TYPE = RegistryMapCodecHelper.create(BuiltInRegistries.LOOT_FUNCTION_TYPE);
    public static final MapCodecHelper<Holder<LootItemConditionType>> LOOT_CONDITION_TYPE = RegistryMapCodecHelper.create(BuiltInRegistries.LOOT_CONDITION_TYPE);
    public static final MapCodecHelper<Holder<LootNumberProviderType>> LOOT_NUMBER_PROVIDER_TYPE = RegistryMapCodecHelper.create(BuiltInRegistries.LOOT_NUMBER_PROVIDER_TYPE);
    public static final MapCodecHelper<Holder<LootNbtProviderType>> LOOT_NBT_PROVIDER_TYPE = RegistryMapCodecHelper.create(BuiltInRegistries.LOOT_NBT_PROVIDER_TYPE);
    public static final MapCodecHelper<Holder<LootScoreProviderType>> LOOT_SCORE_PROVIDER_TYPE = RegistryMapCodecHelper.create(BuiltInRegistries.LOOT_SCORE_PROVIDER_TYPE);
    public static final MapCodecHelper<Holder<FloatProviderType<?>>> FLOAT_PROVIDER_TYPE = RegistryMapCodecHelper.create(BuiltInRegistries.FLOAT_PROVIDER_TYPE);
    public static final MapCodecHelper<Holder<IntProviderType<?>>> INT_PROVIDER_TYPE = RegistryMapCodecHelper.create(BuiltInRegistries.INT_PROVIDER_TYPE);
    public static final MapCodecHelper<Holder<HeightProviderType<?>>> HEIGHT_PROVIDER_TYPE = RegistryMapCodecHelper.create(BuiltInRegistries.HEIGHT_PROVIDER_TYPE);
    public static final MapCodecHelper<Holder<BlockPredicateType<?>>> BLOCK_PREDICATE_TYPE = RegistryMapCodecHelper.create(BuiltInRegistries.BLOCK_PREDICATE_TYPE);
    public static final MapCodecHelper<Holder<WorldCarver<?>>> CARVER = RegistryMapCodecHelper.create(BuiltInRegistries.CARVER);
    public static final MapCodecHelper<Holder<Feature<?>>> FEATURE = RegistryMapCodecHelper.create(BuiltInRegistries.FEATURE);
    public static final MapCodecHelper<Holder<StructurePlacementType<?>>> STRUCTURE_PLACEMENT = RegistryMapCodecHelper.create(BuiltInRegistries.STRUCTURE_PLACEMENT);
    public static final MapCodecHelper<Holder<StructurePieceType>> STRUCTURE_PIECE = RegistryMapCodecHelper.create(BuiltInRegistries.STRUCTURE_PIECE);
    public static final MapCodecHelper<Holder<StructureType<?>>> STRUCTURE_TYPE = RegistryMapCodecHelper.create(BuiltInRegistries.STRUCTURE_TYPE);
    public static final MapCodecHelper<Holder<PlacementModifierType<?>>> PLACEMENT_MODIFIER_TYPE = RegistryMapCodecHelper.create(BuiltInRegistries.PLACEMENT_MODIFIER_TYPE);
    public static final MapCodecHelper<Holder<BlockStateProviderType<?>>> BLOCKSTATE_PROVIDER_TYPE = RegistryMapCodecHelper.create(BuiltInRegistries.BLOCKSTATE_PROVIDER_TYPE);
    public static final MapCodecHelper<Holder<FoliagePlacerType<?>>> FOLIAGE_PLACER_TYPE = RegistryMapCodecHelper.create(BuiltInRegistries.FOLIAGE_PLACER_TYPE);
    public static final MapCodecHelper<Holder<TrunkPlacerType<?>>> TRUNK_PLACER_TYPE = RegistryMapCodecHelper.create(BuiltInRegistries.TRUNK_PLACER_TYPE);
    public static final MapCodecHelper<Holder<RootPlacerType<?>>> ROOT_PLACER_TYPE = RegistryMapCodecHelper.create(BuiltInRegistries.ROOT_PLACER_TYPE);
    public static final MapCodecHelper<Holder<TreeDecoratorType<?>>> TREE_DECORATOR_TYPE = RegistryMapCodecHelper.create(BuiltInRegistries.TREE_DECORATOR_TYPE);
    public static final MapCodecHelper<Holder<FeatureSizeType<?>>> FEATURE_SIZE_TYPE = RegistryMapCodecHelper.create(BuiltInRegistries.FEATURE_SIZE_TYPE);
    public static final MapCodecHelper<Holder<MapCodec<? extends BiomeSource>>> BIOME_SOURCE = RegistryMapCodecHelper.create(BuiltInRegistries.BIOME_SOURCE);
    public static final MapCodecHelper<Holder<MapCodec<? extends ChunkGenerator>>> CHUNK_GENERATOR = RegistryMapCodecHelper.create(BuiltInRegistries.CHUNK_GENERATOR);
    public static final MapCodecHelper<Holder<MapCodec<? extends SurfaceRules.ConditionSource>>> MATERIAL_CONDITION = RegistryMapCodecHelper.create(BuiltInRegistries.MATERIAL_CONDITION);
    public static final MapCodecHelper<Holder<MapCodec<? extends SurfaceRules.RuleSource>>> MATERIAL_RULE = RegistryMapCodecHelper.create(BuiltInRegistries.MATERIAL_RULE);
    public static final MapCodecHelper<Holder<MapCodec<? extends DensityFunction>>> DENSITY_FUNCTION_TYPE = RegistryMapCodecHelper.create(BuiltInRegistries.DENSITY_FUNCTION_TYPE);
    public static final MapCodecHelper<Holder<MapCodec<? extends Block>>> BLOCK_TYPE = RegistryMapCodecHelper.create(BuiltInRegistries.BLOCK_TYPE);
    public static final MapCodecHelper<Holder<StructureProcessorType<?>>> STRUCTURE_PROCESSOR = RegistryMapCodecHelper.create(BuiltInRegistries.STRUCTURE_PROCESSOR);
    public static final MapCodecHelper<Holder<StructurePoolElementType<?>>> STRUCTURE_POOL_ELEMENT = RegistryMapCodecHelper.create(BuiltInRegistries.STRUCTURE_POOL_ELEMENT);
    public static final MapCodecHelper<Holder<MapCodec<? extends PoolAliasBinding>>> POOL_ALIAS_BINDING_TYPE = RegistryMapCodecHelper.create(BuiltInRegistries.POOL_ALIAS_BINDING_TYPE);
    public static final MapCodecHelper<Holder<DecoratedPotPattern>> DECORATED_POT_PATTERN = RegistryMapCodecHelper.create(BuiltInRegistries.DECORATED_POT_PATTERN);
    public static final MapCodecHelper<Holder<CreativeModeTab>> CREATIVE_MODE_TAB = RegistryMapCodecHelper.create(BuiltInRegistries.CREATIVE_MODE_TAB);
    public static final MapCodecHelper<Holder<CriterionTrigger<?>>> TRIGGER_TYPES = RegistryMapCodecHelper.create(BuiltInRegistries.TRIGGER_TYPES);
    public static final MapCodecHelper<Holder<NumberFormatType<?>>> NUMBER_FORMAT_TYPE = RegistryMapCodecHelper.create(BuiltInRegistries.NUMBER_FORMAT_TYPE);
    public static final MapCodecHelper<Holder<DataComponentType<?>>> DATA_COMPONENT_TYPE = RegistryMapCodecHelper.create(BuiltInRegistries.DATA_COMPONENT_TYPE);
    public static final MapCodecHelper<Holder<MapCodec<? extends EntitySubPredicate>>> ENTITY_SUB_PREDICATE_TYPE = RegistryMapCodecHelper.create(BuiltInRegistries.ENTITY_SUB_PREDICATE_TYPE);
    public static final MapCodecHelper<Holder<MapDecorationType>> MAP_DECORATION_TYPE = RegistryMapCodecHelper.create(BuiltInRegistries.MAP_DECORATION_TYPE);
    public static final MapCodecHelper<Holder<DataComponentType<?>>> ENCHANTMENT_EFFECT_COMPONENT_TYPE = RegistryMapCodecHelper.create(BuiltInRegistries.ENCHANTMENT_EFFECT_COMPONENT_TYPE);
    public static final MapCodecHelper<Holder<MapCodec<? extends LevelBasedValue>>> ENCHANTMENT_LEVEL_BASED_VALUE_TYPE = RegistryMapCodecHelper.create(BuiltInRegistries.ENCHANTMENT_LEVEL_BASED_VALUE_TYPE);
    public static final MapCodecHelper<Holder<MapCodec<? extends EnchantmentEntityEffect>>> ENCHANTMENT_ENTITY_EFFECT_TYPE = RegistryMapCodecHelper.create(BuiltInRegistries.ENCHANTMENT_ENTITY_EFFECT_TYPE);
    public static final MapCodecHelper<Holder<MapCodec<? extends EnchantmentLocationBasedEffect>>> ENCHANTMENT_LOCATION_BASED_EFFECT_TYPE = RegistryMapCodecHelper.create(BuiltInRegistries.ENCHANTMENT_LOCATION_BASED_EFFECT_TYPE);
    public static final MapCodecHelper<Holder<MapCodec<? extends EnchantmentValueEffect>>> ENCHANTMENT_VALUE_EFFECT_TYPE = RegistryMapCodecHelper.create(BuiltInRegistries.ENCHANTMENT_VALUE_EFFECT_TYPE);
    public static final MapCodecHelper<Holder<MapCodec<? extends EnchantmentProvider>>> ENCHANTMENT_PROVIDER_TYPE = RegistryMapCodecHelper.create(BuiltInRegistries.ENCHANTMENT_PROVIDER_TYPE);
    public static final MapCodecHelper<Rarity> ITEM_RARITY = new MapCodecHelper<Rarity>(MapCodecs.enumerable(Rarity.class), new Rarity[0]);
    public static final MapCodecHelper<AttributeModifier.Operation> ATTRIBUTE_OPERATION = new MapCodecHelper<AttributeModifier.Operation>(AttributeModifier.Operation.CODEC, new AttributeModifier.Operation[0]);
    public static final MapCodecHelper<Direction> DIRECTION = new MapCodecHelper<Direction>(MapCodecs.enumerable(Direction.class), new Direction[0]);
    public static final MapCodecHelper<Direction.Axis> AXIS = new MapCodecHelper<Direction.Axis>(MapCodecs.enumerable(Direction.Axis.class), new Direction.Axis[0]);
    public static final MapCodecHelper<Direction.Plane> PLANE = new MapCodecHelper<Direction.Plane>(MapCodecs.enumerable(Direction.Plane.class), new Direction.Plane[0]);
    public static final MapCodecHelper<MobCategory> MOB_CATEGORY = new MapCodecHelper<MobCategory>(MapCodecs.enumerable(MobCategory.class), new MobCategory[0]);
    public static final MapCodecHelper<DyeColor> DYE_COLOR = new MapCodecHelper<DyeColor>(MapCodecs.enumerable(DyeColor.class), new DyeColor[0]);
    public static final MapCodecHelper<SoundSource> SOUND_SOURCE = new MapCodecHelper<SoundSource>(MapCodecs.enumerable(SoundSource.class), new SoundSource[0]);
    public static final MapCodecHelper<Difficulty> DIFFICULTY = new MapCodecHelper<Difficulty>(MapCodecs.enumerable(Difficulty.class), new Difficulty[0]);
    public static final MapCodecHelper<EquipmentSlot> EQUIPMENT_SLOT = new MapCodecHelper<EquipmentSlot>(MapCodecs.enumerable(EquipmentSlot.class), new EquipmentSlot[0]);
    public static final MapCodecHelper<Mirror> MIRROR = new MapCodecHelper<Mirror>(MapCodecs.enumerable(Mirror.class), new Mirror[0]);
    public static final MapCodecHelper<Rotation> ROTATION = new MapCodecHelper<Rotation>(MapCodecs.enumerable(Rotation.class), new Rotation[0]);
    public static final MapCodecHelper<ResourceLocation> RESOURCE_LOCATION = new MapCodecHelper<ResourceLocation>(ResourceLocation.CODEC, new ResourceLocation[0]);
    public static final MapCodecHelper<CompoundTag> COMPOUND_TAG = new MapCodecHelper<CompoundTag>(CompoundTag.CODEC, new CompoundTag[0]);
    public static final MapCodecHelper<ItemStack> ITEM_STACK = new MapCodecHelper<ItemStack>(ItemStack.CODEC, new ItemStack[0]);
    public static final MapCodecHelper<ItemStack> ITEM_STACK_STRICT = new MapCodecHelper<ItemStack>(ItemStack.STRICT_CODEC, new ItemStack[0]);
    public static final MapCodecHelper<Component> TEXT = new MapCodecHelper<Component>(ComponentSerialization.CODEC, new Component[0]);
    public static final MapCodecHelper<BlockPos> BLOCK_POS = new MapCodecHelper<BlockPos>(BlockPos.CODEC, new BlockPos[0]);
    public static final MapCodecHelper<Ingredient> INGREDIENT = new MapCodecHelper<Ingredient>(Ingredient.CODEC, new Ingredient[0]);
    public static final MapCodec<BlockState> BLOCK_STATE_MAP_CODEC = Codec.mapPair((MapCodec)BLOCK.get().fieldOf("block"), (MapCodec)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING).optionalFieldOf("properties")).flatXmap(MapCodecs::decodeBlockState, MapCodecs::encodeBlockState);
    public static final MapCodecHelper<BlockState> BLOCK_STATE = new MapCodecHelper<BlockState>(BLOCK_STATE_MAP_CODEC.codec(), new BlockState[0]);
    public static final MapCodecHelper<AttributeModifier> ATTRIBUTE_MODIFIER = new MapCodecHelper<AttributeModifier>(AttributeModifier.CODEC, new AttributeModifier[0]);
    public static final MapCodecHelper<MobEffectInstance> EFFECT_INSTANCE = new MapCodecHelper<MobEffectInstance>(MobEffectInstance.CODEC, new MobEffectInstance[0]);
    public static final MapCodecHelper<Vector3f> VECTOR_3F = new MapCodecHelper<Vector3f>(ExtraCodecs.VECTOR3F, new Vector3f[0]);
    public static final MapCodecHelper<ILoadCondition> LOAD_CONDITION = LoadConditions.CODEC_HELPER;

    public static <T> Codec<List<T>> flexibleList(Codec<T> codec) {
        return Codec.either((Codec)codec.listOf(), codec).xmap(either -> (List)either.map(Function.identity(), List::of), list -> list.size() == 1 ? Either.right(list.getFirst()) : Either.left((Object)list));
    }

    public static <T> Codec<Set<T>> flexibleSet(Codec<T> codec) {
        return MapCodecs.flexibleList(codec).xmap(LinkedHashSet::new, ArrayList::new);
    }

    public static <T> Codec<T[]> flexibleArray(Codec<T> codec, IntFunction<T[]> arrayBuilder) {
        return MapCodecs.flexibleList(codec).xmap(list -> list.toArray((Object[])arrayBuilder.apply(list.size())), List::of);
    }

    public static <T> MapCodec<T> fallback(Codec<T> codec, String name, Supplier<T> fallbackSupplier) {
        return MapCodecs.fallback(codec, name, fallbackSupplier, true);
    }

    public static <T> MapCodec<Optional<T>> optional(Codec<T> codec, String name, Optional<T> fallback, boolean writesDefault) {
        return Codec.optionalField((String)name, codec, (boolean)false).xmap(o -> o.isPresent() ? o : fallback, a -> a.isEmpty() || Objects.equals(a.get(), fallback.orElse(null)) && !writesDefault ? Optional.empty() : a);
    }

    public static <T> MapCodec<T> nullable(Codec<T> codec, String fieldName) {
        return Codec.optionalField((String)fieldName, codec, (boolean)false).xmap(optional -> optional.orElse(null), Optional::ofNullable);
    }

    public static <T> MapCodec<T> fallback(Codec<T> codec, String name, Supplier<T> fallbackSupplier, boolean writesDefault) {
        return Codec.optionalField((String)name, codec, (boolean)false).xmap(value -> value.orElse(fallbackSupplier.get()), value -> {
            Object fallback = fallbackSupplier.get();
            return Objects.equals(value, fallback) && !writesDefault ? Optional.empty() : Optional.of(value);
        });
    }

    public static Set<String> getPossibleMatches(String input, Iterable<String> candidates, int threshold) {
        HashSet<String> bestMatches = new HashSet<String>();
        int distance = threshold;
        for (String candidate : candidates) {
            int currentDistance = StringUtils.getLevenshteinDistance((CharSequence)input, (CharSequence)candidate);
            if (currentDistance < distance) {
                distance = currentDistance;
                bestMatches.clear();
                bestMatches.add(candidate);
                continue;
            }
            if (currentDistance != distance) continue;
            bestMatches.add(candidate);
        }
        return bestMatches;
    }

    public static <T> String formatCollection(Collection<T> collection) {
        return MapCodecs.formatCollection(collection, entry -> "\"" + entry.toString() + "\"", ", ");
    }

    public static <T> String formatCollection(Collection<T> collection, Function<T, String> formatter, String delimiter) {
        return collection.size() == 1 ? formatter.apply(collection.stream().findFirst().get()) : collection.stream().map(formatter).collect(Collectors.joining(delimiter));
    }

    public static <T extends Enum<T>> Codec<T> enumerable(Class<T> enumClass) {
        Map enumValues = EnumUtils.getEnumMap(enumClass);
        Function<String, Enum> fromString = name -> {
            Enum value = (Enum)enumValues.get(name);
            if (value == null) {
                value = (Enum)enumValues.get(name.toUpperCase(Locale.ROOT));
            }
            return value;
        };
        UnaryOperator errorMessage = name -> {
            StringJoiner message = new StringJoiner(" ");
            message.add("Unable to find " + enumClass.getSimpleName() + " entry \"" + name + "\".");
            Set<String> similarMatches = MapCodecs.getPossibleMatches(name, enumValues.keySet(), 2);
            if (!similarMatches.isEmpty()) {
                message.add("Did you mean \"" + (String)similarMatches.stream().findFirst().get() + "\"?");
            }
            message.add("Available Options are " + MapCodecs.formatCollection(enumValues.keySet()));
            return message.toString();
        };
        return Codec.STRING.flatXmap(string -> (DataResult)Optionull.mapOrElse((Object)((Enum)fromString.apply((String)string)), DataResult::success, () -> DataResult.error(() -> (String)errorMessage.apply(string))), object -> DataResult.success((Object)object.name()));
    }

    private static DataResult<BlockState> decodeBlockState(Pair<Holder<Block>, Optional<Map<String, String>>> props) {
        Block block = (Block)((Holder)props.getFirst()).value();
        Map properties = ((Optional)props.getSecond()).orElse(new HashMap());
        BlockState state = block.defaultBlockState();
        if (!properties.isEmpty()) {
            StateDefinition definition = block.getStateDefinition();
            for (Map.Entry entry : properties.entrySet()) {
                Property property = definition.getProperty((String)entry.getKey());
                if (property != null) {
                    Optional value = property.getValue((String)entry.getValue());
                    if (value.isPresent()) {
                        try {
                            state = (BlockState)state.setValue(property, (Comparable)value.get());
                            continue;
                        }
                        catch (Exception e) {
                            Constants.LOG.error("Failed to update state for block {} with valid value {}={}. The mod that adds this block may have a serious issue.", new Object[]{BuiltInRegistries.BLOCK.getKey((Object)block), entry.getKey(), entry.getValue()});
                            return DataResult.error(e::getMessage);
                        }
                    }
                    return DataResult.error(() -> "\"" + (String)entry.getValue() + "\" is not a valid value for property \"" + property.getName() + "\" on block \"" + String.valueOf(BuiltInRegistries.BLOCK.getKey((Object)block)) + "\". Available values: " + property.getAllValues().map(propVal -> property.getName(propVal.value())).collect(Collectors.joining()));
                }
                return DataResult.error(() -> "The property \"" + (String)entry.getKey() + "\" is not valid for block \"" + String.valueOf(BuiltInRegistries.BLOCK.getKey((Object)block)) + "\". Available properties: " + definition.getProperties().stream().map(Property::getName).collect(Collectors.joining()));
            }
        }
        return DataResult.success((Object)state);
    }

    private static DataResult<Pair<Holder<Block>, Optional<Map<String, String>>>> encodeBlockState(BlockState state) {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        for (Map.Entry entry : state.getValues().entrySet()) {
            propertyMap.put(((Property)entry.getKey()).getName(), ((Property)entry.getKey()).getName((Comparable)entry.getValue()));
        }
        return DataResult.success((Object)new Pair((Object)state.getBlock().builtInRegistryHolder(), Optional.ofNullable(propertyMap.isEmpty() ? null : propertyMap)));
    }
}

