/*
 * Decompiled with CFR 0.152.
 */
package com.cursee.monolib.impl.common.serialization.conditions;

import com.cursee.monolib.Constants;
import com.cursee.monolib.MonoLib;
import com.cursee.monolib.impl.common.serialization.codecs.map.MapCodecHelper;
import com.cursee.monolib.impl.common.serialization.codecs.map.MapCodecs;
import com.cursee.monolib.impl.common.serialization.conditions.ConditionType;
import com.cursee.monolib.impl.common.serialization.conditions.ILoadCondition;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class LoadConditions {
    public static final String LOAD_CONDITION_TAG = MonoLib.identifier("load_conditions").toString();
    private static final Map<ResourceLocation, ConditionType> CONDITION_TYPES = new HashMap<ResourceLocation, ConditionType>();
    private static final Codec<ConditionType> CONDITION_TYPE_CODEC = ResourceLocation.CODEC.xmap(CONDITION_TYPES::get, ConditionType::id);
    public static final Codec<ILoadCondition> CONDITION_CODEC = CONDITION_TYPE_CODEC.dispatch(ILoadCondition::getType, ConditionType::codec);
    public static final MapCodecHelper<ILoadCondition> CODEC_HELPER = new MapCodecHelper<ILoadCondition>(CONDITION_CODEC, new ILoadCondition[0]);

    @Nullable
    public static ConditionType getType(ResourceLocation id) {
        return CONDITION_TYPES.get(id);
    }

    public static <T extends ILoadCondition> ConditionType register(ResourceLocation id, MapCodec<T> codec) {
        if (CONDITION_TYPES.containsKey(id)) {
            Constants.LOG.warn("JSON Load Serializer ID {} has already been assigned to {}. Replacing with {}.", new Object[]{id, CONDITION_TYPES.get(id).codec(), codec});
        }
        ConditionType type = new ConditionType(id, codec);
        CONDITION_TYPES.put(id, type);
        return type;
    }

    public static ILoadCondition[] getConditions(JsonElement conditionData) {
        return (ILoadCondition[])((Pair)MapCodecs.LOAD_CONDITION.getArray().decode((DynamicOps)JsonOps.INSTANCE, (Object)conditionData).getOrThrow()).getFirst();
    }

    public static boolean canLoad(JsonObject rawJson) {
        if (rawJson.has(LOAD_CONDITION_TAG)) {
            JsonElement conditionData = rawJson.get(LOAD_CONDITION_TAG);
            for (ILoadCondition condition : LoadConditions.getConditions(conditionData)) {
                if (condition.allowLoading()) continue;
                return false;
            }
        }
        return true;
    }
}

