/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.client.platform.runtime.internal;

import java.util.function.Consumer;
import net.blay09.mods.balm.client.BalmClientRegistrars;
import net.blay09.mods.balm.client.BalmKeyMappingRegistrar;
import net.blay09.mods.balm.client.color.block.BalmBlockColorRegistrar;
import net.blay09.mods.balm.client.gui.screens.inventory.BalmMenuScreenRegistrar;
import net.blay09.mods.balm.client.model.geom.BalmModelLayerRegistrar;
import net.blay09.mods.balm.client.particle.BalmParticleProviderRegistrar;
import net.blay09.mods.balm.client.platform.module.BalmClientModule;
import net.blay09.mods.balm.client.renderer.block.model.BalmBlockStateModelRegistrar;
import net.blay09.mods.balm.client.renderer.blockentity.BalmBlockEntityRendererRegistrar;
import net.blay09.mods.balm.client.renderer.chunk.BalmBlockRenderTypeRegistrar;
import net.blay09.mods.balm.client.renderer.entity.BalmEntityRendererRegistrar;
import net.blay09.mods.balm.platform.runtime.BalmRuntimeLoadContext;
import net.blay09.mods.balm.server.packs.resources.BalmClientResourceReloadListenerRegistrar;

public interface BalmClientRuntime<TLoadContext extends BalmRuntimeLoadContext> {
    public void initializeMod(String var1, TLoadContext var2, Consumer<BalmClientRegistrars> var3);

    default public void initializeModule(BalmClientModule module) {
        String modId = module.getId().getNamespace();
        this.resourceReloadListeners(modId, module::registerClientReloadListeners);
        this.blockColors(modId, module::registerBlockColors);
        this.blockRenderTypes(modId, module::registerBlockRenderTypes);
        this.blockEntityRenderers(modId, module::registerBlockEntityRenderers);
        this.entityRenderers(modId, module::registerEntityRenderers);
        this.particleProviders(modId, module::registerParticleProviders);
        this.modelLayers(modId, module::registerModelLayers);
        this.menuScreens(modId, module::registerMenuScreens);
        this.blockStateModels(modId, module::registerBlockStateModels);
        this.keyMappings(modId, module::registerKeyMappings);
        module.initialize();
    }

    public boolean isReady();

    public void onRuntimeAvailable(Runnable var1);

    public void registerModule(BalmClientRegistrars var1, BalmClientModule var2);

    public void blockEntityRenderers(String var1, Consumer<BalmBlockEntityRendererRegistrar> var2);

    public void blockStateModels(String var1, Consumer<BalmBlockStateModelRegistrar> var2);

    public void entityRenderers(String var1, Consumer<BalmEntityRendererRegistrar> var2);

    public void menuScreens(String var1, Consumer<BalmMenuScreenRegistrar> var2);

    public void keyMappings(String var1, Consumer<BalmKeyMappingRegistrar> var2);

    public void modelLayers(String var1, Consumer<BalmModelLayerRegistrar> var2);

    public void blockColors(String var1, Consumer<BalmBlockColorRegistrar> var2);

    public void particleProviders(String var1, Consumer<BalmParticleProviderRegistrar> var2);

    public void blockRenderTypes(String var1, Consumer<BalmBlockRenderTypeRegistrar> var2);

    public void resourceReloadListeners(String var1, Consumer<BalmClientResourceReloadListenerRegistrar> var2);
}

