/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.client.platform.runtime.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.blay09.mods.balm.client.BalmClientRegistrars;
import net.blay09.mods.balm.client.platform.config.internal.ConfigSyncClient;
import net.blay09.mods.balm.client.platform.module.BalmClientModule;
import net.blay09.mods.balm.client.platform.runtime.internal.BalmClientRuntime;
import net.blay09.mods.balm.platform.runtime.BalmRuntimeLoadContext;

public abstract class CommonBalmClientRuntime<TLoadContext extends BalmRuntimeLoadContext>
implements BalmClientRuntime<TLoadContext> {
    private static final List<Runnable> initCallbacks = Collections.synchronizedList(new ArrayList());
    private static final List<BalmClientModule> modules = Collections.synchronizedList(new ArrayList());
    private boolean ready;

    @Override
    public boolean isReady() {
        return this.ready;
    }

    @Override
    public void onRuntimeAvailable(Runnable callback) {
        initCallbacks.add(callback);
        if (this.isReady()) {
            callback.run();
        }
    }

    @Override
    public void registerModule(BalmClientRegistrars registrars, BalmClientModule module) {
        modules.add(module);
        this.initializeModule(module);
    }

    public void initializeRuntime() {
        this.ready = true;
        for (Runnable callback : initCallbacks) {
            callback.run();
        }
        this.registerModule(new BalmClientRegistrars(this, "balm"), new ConfigSyncClient());
    }
}

