/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.neoforge.platform.event.internal;

import com.mojang.brigadier.ParseResults;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.blay09.mods.balm.platform.event.EventMapper;
import net.blay09.mods.balm.platform.event.EventPhases;
import net.blay09.mods.balm.platform.event.callback.BlockCallback;
import net.blay09.mods.balm.platform.event.callback.CommandCallback;
import net.blay09.mods.balm.platform.event.callback.ConfigCallback;
import net.blay09.mods.balm.platform.event.callback.CreativeModeTabCallback;
import net.blay09.mods.balm.platform.event.callback.CropCallback;
import net.blay09.mods.balm.platform.event.callback.EntityCallback;
import net.blay09.mods.balm.platform.event.callback.InteractionEventResult;
import net.blay09.mods.balm.platform.event.callback.ItemCallback;
import net.blay09.mods.balm.platform.event.callback.LevelCallback;
import net.blay09.mods.balm.platform.event.callback.LivingEntityCallback;
import net.blay09.mods.balm.platform.event.callback.PlayerCallback;
import net.blay09.mods.balm.platform.event.callback.ServerLifecycleCallback;
import net.blay09.mods.balm.platform.event.callback.ServerPlayerCallback;
import net.blay09.mods.balm.platform.event.callback.ServerTickCallback;
import net.blay09.mods.balm.platform.event.internal.BalmSupplementalEvents;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.ICancellableEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.CommandEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.EntityLeaveLevelEvent;
import net.neoforged.neoforge.event.entity.item.ItemTossEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.entity.living.LivingHealEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.entity.player.PlayerContainerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.ChunkEvent;
import net.neoforged.neoforge.event.level.ChunkWatchEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.level.block.CropGrowEvent;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

public class NeoForgeBalmEventMappings {
    private static final Map<Identifier, EventPriority> PRIORITIES = Map.of(EventPhases.LOWEST, EventPriority.LOWEST, EventPhases.LOW, EventPriority.LOW, EventPhases.DEFAULT, EventPriority.NORMAL, EventPhases.HIGH, EventPriority.HIGH, EventPhases.HIGHEST, EventPriority.HIGHEST);

    public static void bind() {
        NeoForgeBalmEventMappings.bindSimple(ServerTickCallback.BEFORE, ServerTickEvent.Pre.class, (event, it) -> it.handle(event.getServer()));
        NeoForgeBalmEventMappings.bindSimple(ServerTickCallback.AFTER, ServerTickEvent.Post.class, (event, it) -> it.handle(event.getServer()));
        NeoForgeBalmEventMappings.bindFiltered(ServerTickCallback.ServerLevelTick.BEFORE, LevelTickEvent.Pre.class, event -> !event.getLevel().isClientSide(), (event, it) -> it.handle((ServerLevel)event.getLevel()));
        NeoForgeBalmEventMappings.bindFiltered(ServerTickCallback.ServerLevelTick.AFTER, LevelTickEvent.Post.class, event -> !event.getLevel().isClientSide(), (event, it) -> it.handle((ServerLevel)event.getLevel()));
        NeoForgeBalmEventMappings.bindFiltered(ServerTickCallback.ServerPlayerTick.BEFORE, PlayerTickEvent.Pre.class, event -> !event.getEntity().level().isClientSide(), (event, it) -> it.handle((ServerPlayer)event.getEntity()));
        NeoForgeBalmEventMappings.bindFiltered(ServerTickCallback.ServerPlayerTick.AFTER, PlayerTickEvent.Post.class, event -> !event.getEntity().level().isClientSide(), (event, it) -> it.handle((ServerPlayer)event.getEntity()));
        NeoForgeBalmEventMappings.bindFiltered(ServerTickCallback.ServerEntityTick.BEFORE, EntityTickEvent.Pre.class, event -> !event.getEntity().level().isClientSide(), (event, it) -> it.handle(event.getEntity()));
        NeoForgeBalmEventMappings.bindFiltered(ServerTickCallback.ServerEntityTick.AFTER, EntityTickEvent.Post.class, event -> !event.getEntity().level().isClientSide(), (event, it) -> it.handle(event.getEntity()));
        NeoForgeBalmEventMappings.bindSimple(ServerLifecycleCallback.Starting.EVENT, ServerAboutToStartEvent.class, (event, it) -> it.handle(event.getServer()));
        NeoForgeBalmEventMappings.bindSimple(ServerLifecycleCallback.Started.EVENT, ServerStartedEvent.class, (event, it) -> it.handle(event.getServer()));
        NeoForgeBalmEventMappings.bindSimple(ServerLifecycleCallback.Stopping.EVENT, ServerStoppingEvent.class, (event, it) -> it.handle(event.getServer()));
        NeoForgeBalmEventMappings.bindSimple(ServerLifecycleCallback.Stopped.EVENT, ServerStoppedEvent.class, (event, it) -> it.handle(event.getServer()));
        ServerLifecycleCallback.Reloading.EVENT.configureMapping(BalmSupplementalEvents.SERVER_RELOADING::register);
        ServerLifecycleCallback.Reloaded.EVENT.configureMapping(BalmSupplementalEvents.SERVER_RELOADED::register);
        NeoForgeBalmEventMappings.bindCancelable(BlockCallback.DigSpeed.EVENT, PlayerEvent.BreakSpeed.class, (event, it) -> event.getPosition().map(pos -> {
            Level level = event.getEntity().level();
            float speed = it.computeDigSpeed((BlockGetter)level, (BlockPos)pos, event.getState(), event.getEntity(), event.getNewSpeed());
            if (speed == -1.0f) {
                return true;
            }
            event.setNewSpeed(speed);
            return false;
        }).orElse(false));
        NeoForgeBalmEventMappings.bindCancelable(BlockCallback.Break.Before.EVENT, BlockEvent.BreakEvent.class, (event, it) -> {
            LevelAccessor level = event.getLevel();
            BlockEntity blockEntity = level.getBlockEntity(event.getPos());
            return !it.allowBreak(level, event.getPos(), event.getState(), blockEntity, event.getPlayer());
        });
        NeoForgeBalmEventMappings.bindCancelable(BlockCallback.Use.EVENT, PlayerInteractEvent.RightClickBlock.class, (event, it) -> {
            InteractionEventResult result = it.handle(event.getEntity(), event.getLevel(), event.getHand(), event.getHitVec());
            result.interactionResult().ifPresent(arg_0 -> ((PlayerInteractEvent.RightClickBlock)event).setCancellationResult(arg_0));
            return result.interactionResult().isPresent();
        });
        NeoForgeBalmEventMappings.bindCancelable(CommandCallback.Before.EVENT, CommandEvent.class, (event, it) -> !it.allowCommand((ParseResults<CommandSourceStack>)event.getParseResults()));
        ConfigCallback.Loaded.EVENT.configureMapping(BalmSupplementalEvents.CONFIG_LOADED::register);
        ConfigCallback.Reloaded.EVENT.configureMapping(BalmSupplementalEvents.CONFIG_RELOADED::register);
        NeoForgeBalmEventMappings.bindSimple(CropCallback.Grow.Before.EVENT, CropGrowEvent.Pre.class, (event, it) -> {
            CropCallback.Grow.Before.Result result = it.beforeGrow(event.getLevel(), event.getPos(), event.getState());
            event.setResult(switch (result) {
                case CropCallback.Grow.Before.Result.DO_NOT_GROW -> CropGrowEvent.Pre.Result.DO_NOT_GROW;
                case CropCallback.Grow.Before.Result.GROW -> CropGrowEvent.Pre.Result.GROW;
                default -> CropGrowEvent.Pre.Result.DEFAULT;
            });
        });
        NeoForgeBalmEventMappings.bindSimple(CropCallback.Grow.After.EVENT, CropGrowEvent.Post.class, (event, it) -> it.afterGrow(event.getLevel(), event.getPos(), event.getState()));
        NeoForgeBalmEventMappings.bindSimple(EntityCallback.AddedToLevel.EVENT, EntityJoinLevelEvent.class, (event, it) -> it.handle(event.getLevel(), event.getEntity()));
        NeoForgeBalmEventMappings.bindSimple(EntityCallback.RemovedFromLevel.EVENT, EntityLeaveLevelEvent.class, (event, it) -> it.handle(event.getLevel(), event.getEntity()));
        NeoForgeBalmEventMappings.bindSimple(CreativeModeTabCallback.BuildContents.EVENT, BuildCreativeModeTabContentsEvent.class, (event, it) -> it.handle(event.getTab(), (CreativeModeTab.Output)event));
        NeoForgeBalmEventMappings.bindCancelable(ItemCallback.Use.EVENT, PlayerInteractEvent.RightClickItem.class, (event, it) -> {
            InteractionEventResult result = it.handle(event.getEntity(), event.getLevel(), event.getHand());
            result.interactionResult().ifPresent(arg_0 -> ((PlayerInteractEvent.RightClickItem)event).setCancellationResult(arg_0));
            return result.interactionResult().isPresent();
        });
        NeoForgeBalmEventMappings.bindSimple(ItemCallback.Tooltip.EVENT, ItemTooltipEvent.class, (event, it) -> it.handle(event.getItemStack(), event.getToolTip(), event.getFlags()));
        NeoForgeBalmEventMappings.bindSimple(ItemCallback.Craft.After.EVENT, PlayerEvent.ItemCraftedEvent.class, (event, it) -> it.afterCraft(event.getEntity(), event.getCrafting(), event.getInventory()));
        NeoForgeBalmEventMappings.bindCancelable(ItemCallback.Toss.Before.EVENT, ItemTossEvent.class, (event, it) -> !it.allowToss(event.getPlayer(), event.getEntity().getItem()));
        NeoForgeBalmEventMappings.bindSimple(LevelCallback.LOAD, LevelEvent.Load.class, (event, it) -> it.handle(event.getLevel()));
        NeoForgeBalmEventMappings.bindSimple(LevelCallback.UNLOAD, LevelEvent.Unload.class, (event, it) -> it.handle(event.getLevel()));
        NeoForgeBalmEventMappings.bindSimple(LevelCallback.Chunk.LOAD, ChunkEvent.Load.class, (event, it) -> it.handle(event.getLevel(), event.getChunk(), ((LevelChunk)event.getChunk()).getPos()));
        NeoForgeBalmEventMappings.bindSimple(LevelCallback.Chunk.UNLOAD, ChunkEvent.Unload.class, (event, it) -> it.handle(event.getLevel(), event.getChunk(), ((LevelChunk)event.getChunk()).getPos()));
        NeoForgeBalmEventMappings.bindSimple(LivingEntityCallback.Heal.Before.EVENT, LivingHealEvent.class, (event, it) -> it.computeHeal(event.getEntity(), event.getAmount()));
        NeoForgeBalmEventMappings.bindSimple(LivingEntityCallback.Fall.Before.EVENT, LivingFallEvent.class, (event, it) -> it.computeFallDamage(event.getEntity(), event.getDamageMultiplier()));
        NeoForgeBalmEventMappings.bindCancelable(LivingEntityCallback.Death.Before.EVENT, LivingDeathEvent.class, (event, it) -> !it.allowDeath(event.getEntity(), event.getSource()));
        NeoForgeBalmEventMappings.bindSimple(LivingEntityCallback.Damage.Before.EVENT, LivingDamageEvent.Pre.class, (event, it) -> it.computeDamage(event.getEntity(), event.getSource(), event.getNewDamage()));
        NeoForgeBalmEventMappings.bindCancelable(PlayerCallback.Attack.Before.EVENT, AttackEntityEvent.class, (event, it) -> !it.allowAttack(event.getEntity(), event.getTarget()));
        NeoForgeBalmEventMappings.bindSimple(ServerPlayerCallback.Join.EVENT, PlayerEvent.PlayerLoggedInEvent.class, (event, it) -> it.handle((ServerPlayer)event.getEntity()));
        NeoForgeBalmEventMappings.bindSimple(ServerPlayerCallback.Leave.EVENT, PlayerEvent.PlayerLoggedOutEvent.class, (event, it) -> it.handle((ServerPlayer)event.getEntity()));
        NeoForgeBalmEventMappings.bindSimple(ServerPlayerCallback.OpenMenu.EVENT, PlayerContainerEvent.Open.class, (event, it) -> it.handle((ServerPlayer)event.getEntity(), event.getContainer()));
        NeoForgeBalmEventMappings.bindSimple(ServerPlayerCallback.DimensionChange.EVENT, PlayerEvent.PlayerChangedDimensionEvent.class, (event, it) -> it.handle((ServerPlayer)event.getEntity(), (ResourceKey<Level>)event.getFrom(), (ResourceKey<Level>)event.getTo()));
        NeoForgeBalmEventMappings.bindSimple(ServerPlayerCallback.Respawn.EVENT, PlayerEvent.PlayerRespawnEvent.class, (event, it) -> it.handle((ServerPlayer)event.getEntity(), (ServerPlayer)event.getEntity()));
        NeoForgeBalmEventMappings.bindSimple(ServerPlayerCallback.ChunkTracking.START, ChunkWatchEvent.Watch.class, (event, it) -> it.handle(event.getLevel(), event.getPlayer(), event.getPos()));
        NeoForgeBalmEventMappings.bindSimple(ServerPlayerCallback.ChunkTracking.STOP, ChunkWatchEvent.UnWatch.class, (event, it) -> it.handle(event.getLevel(), event.getPlayer(), event.getPos()));
    }

    public static <TCallback, TEvent extends Event> void bindSimple(EventMapper<TCallback> mapper, Class<TEvent> eventClass, BiConsumer<TEvent, TCallback> consumer) {
        mapper.configureMapping((phase, listener) -> NeoForge.EVENT_BUS.addListener(NeoForgeBalmEventMappings.mapPriority(phase), eventClass, event -> consumer.accept(event, listener)));
    }

    public static <TCallback, TEvent extends Event> void bindCancelable(EventMapper<TCallback> mapper, Class<TEvent> eventClass, BiFunction<TEvent, TCallback, Boolean> consumer) {
        mapper.configureMapping((phase, listener) -> NeoForge.EVENT_BUS.addListener(NeoForgeBalmEventMappings.mapPriority(phase), eventClass, event -> {
            if (((Boolean)consumer.apply(event, listener)).booleanValue()) {
                ((ICancellableEvent)event).setCanceled(true);
            }
        }));
    }

    public static <TCallback, TEvent extends Event> void bindFiltered(EventMapper<TCallback> mapper, Class<TEvent> eventClass, Predicate<TEvent> filter, BiConsumer<TEvent, TCallback> consumer) {
        mapper.configureMapping((phase, listener) -> NeoForge.EVENT_BUS.addListener(NeoForgeBalmEventMappings.mapPriority(phase), eventClass, event -> {
            if (filter.test(event)) {
                consumer.accept(event, listener);
            }
        }));
    }

    public static EventPriority mapPriority(Identifier phase) {
        return PRIORITIES.getOrDefault(phase, EventPriority.NORMAL);
    }
}

