/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.armorposer.client;

import com.mrbysco.armorposer.client.debug.DebugHandler;
import java.util.UUID;
import net.minecraft.client.Minecraft;

public class GlowHandler {
    private static long glowStartTime = 0L;
    private static UUID glowingStand = null;

    public static boolean shouldArmorStandGlow() {
        boolean notEmpty;
        if (glowStartTime == -1L) {
            return false;
        }
        boolean bl = notEmpty = glowingStand != null;
        if (notEmpty && System.currentTimeMillis() - glowStartTime > 5000L) {
            glowStartTime = -1L;
            glowingStand = null;
        }
        return notEmpty;
    }

    public static boolean isGlowing(UUID uuid) {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.debugEntries.isCurrentlyEnabled(DebugHandler.SHOW_ARMOR_STANDS) && !minecraft.showOnlyReducedInfo()) {
            return true;
        }
        if (!GlowHandler.shouldArmorStandGlow()) {
            return false;
        }
        return glowingStand != null && glowingStand.equals(uuid);
    }

    public static void startGlowing(UUID uuid) {
        glowStartTime = System.currentTimeMillis();
        glowingStand = uuid;
    }
}

