/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.armorposer.client.gui.widgets;

import com.mrbysco.armorposer.Reference;
import com.mrbysco.armorposer.client.gui.ArmorGlowScreen;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.renderer.entity.state.ArmorStandRenderState;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.ARGB;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ArmorStand;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2fStack;

public class ArmorGlowWidget
extends ObjectSelectionList<ListEntry> {
    private final ArmorGlowScreen parent;
    private final int listWidth;
    private final Component title;

    public ArmorGlowWidget(ArmorGlowScreen parent, Component title, boolean visible, int listWidth, int top, int bottom) {
        Minecraft minecraft = parent.getScreenMinecraft();
        Objects.requireNonNull(parent.getScreenFont());
        super(minecraft, listWidth, bottom - top, top, 9 * 2 + 16);
        this.parent = parent;
        this.title = title;
        this.listWidth = listWidth;
        this.refreshList(visible);
    }

    protected int scrollBarX() {
        return this.listWidth;
    }

    public int getRowWidth() {
        return this.listWidth;
    }

    public void refreshList(boolean visible) {
        this.clearEntries();
        if (visible) {
            this.parent.buildVisiblePositions(x$0 -> this.addEntry((AbstractSelectionList.Entry)x$0), location -> new ListEntry((ArmorStand)location, this.parent));
        } else {
            this.parent.buildInvisiblePositions(x$0 -> this.addEntry((AbstractSelectionList.Entry)x$0), location -> new ListEntry((ArmorStand)location, this.parent));
        }
    }

    protected void renderSelection(GuiGraphics guiGraphics, ListEntry listEntry, int p_240142_) {
        int x1 = listEntry.getX();
        int y1 = listEntry.getY();
        int x2 = x1 + listEntry.getWidth();
        int y2 = y1 + listEntry.getHeight();
        guiGraphics.fillGradient(x1, y1, x2, y2, -1945083888, -1676648432);
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        guiGraphics.fillGradient(this.getX(), 0, this.getX() + this.listWidth, this.parent.height, -1945104368, -1676668912);
        super.renderWidget(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.drawCenteredString(this.parent.getScreenFont(), this.title, this.getX() + this.listWidth / 2, 2, ARGB.opaque((int)0xFFFFFF));
    }

    public void setSelected(@Nullable ListEntry selected) {
        this.parent.setSelected((ListEntry)this.getSelected(), selected, this.visible);
        super.setSelected((AbstractSelectionList.Entry)selected);
    }

    public class ListEntry
    extends ObjectSelectionList.Entry<ListEntry> {
        private final ArmorGlowScreen parent;
        private final ArmorStandRenderState armorStandPreview = new ArmorStandRenderState();
        private final ArmorStand armorstand;
        private final float scale;
        private final boolean showPlate;
        private final boolean locked;

        ListEntry(ArmorStand armorStand, ArmorGlowScreen parent) {
            this.parent = parent;
            this.scale = armorStand.getScale();
            this.showPlate = armorStand.showBasePlate();
            this.locked = armorStand.isInvulnerable();
            this.armorstand = armorStand;
            this.armorStandPreview.entityType = EntityType.ARMOR_STAND;
            this.armorStandPreview.xRot = 25.0f;
            this.armorStandPreview.bodyRot = 210.0f;
            this.updateState(armorStand);
        }

        public void updateState(ArmorStand stand) {
            this.armorStandPreview.showBasePlate = stand.showBasePlate();
            this.armorStandPreview.isSmall = stand.isSmall();
            this.armorStandPreview.showArms = stand.showArms();
            this.armorStandPreview.isInvisible = stand.isInvisible();
            this.armorStandPreview.nameTag = stand.getCustomName();
            this.armorStandPreview.headPose = stand.getHeadPose();
            this.armorStandPreview.bodyPose = stand.getBodyPose();
            this.armorStandPreview.leftArmPose = stand.getLeftArmPose();
            this.armorStandPreview.rightArmPose = stand.getRightArmPose();
            this.armorStandPreview.leftLegPose = stand.getLeftLegPose();
            this.armorStandPreview.rightLegPose = stand.getRightLegPose();
        }

        public void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean hovered, float partialTick) {
            int left = this.getContentX();
            int top = this.getContentY();
            Matrix3x2fStack pose = guiGraphics.pose();
            pose.pushMatrix();
            pose.translate((float)left, (float)(top - ArmorGlowWidget.this.height / 2));
            ArmorGlowWidget.this.renderScrollingStringOverContents(guiGraphics.textRenderer(), this.getPositionComponent(), 18);
            if (this.isMouseOver(mouseX, mouseY)) {
                Font font = this.parent.getScreenFont();
                MutableComponent component = Component.translatable((String)"armorposer.gui.armor_list.stats", (Object[])new Object[]{Float.valueOf(this.scale)});
                guiGraphics.setTooltipForNextFrame(font, (Component)component, mouseX, mouseY);
            }
            if (this.isVisible() && ArmorGlowWidget.this.getSelected() == this) {
                this.renderPose(guiGraphics, left + 16, top + 28, partialTick);
            }
            pose.popMatrix();
        }

        public ArmorStand getArmorStand() {
            return this.armorstand;
        }

        public boolean isLocked() {
            return this.locked;
        }

        public boolean isVisible() {
            return !this.armorStandPreview.isInvisible;
        }

        public void renderPose(GuiGraphics guiGraphics, int xPos, int yPos, float partialTick) {
            if (this.armorStandPreview != null) {
                int startX = xPos - 40;
                int startY = yPos - 60;
                int endX = xPos + 40;
                int endY = yPos + 60;
                guiGraphics.submitEntityRenderState((EntityRenderState)this.armorStandPreview, 20.0f, Reference.ARMOR_STAND_TRANSLATION, Reference.ARMOR_STAND_ANGLE, null, startX, startY, endX, endY);
            }
        }

        public Component getPositionComponent() {
            MutableComponent component = Component.literal((String)this.getArmorStand().blockPosition().toShortString());
            if (this.showPlate) {
                component = component.withStyle(ChatFormatting.UNDERLINE);
            }
            if (this.isLocked()) {
                component = component.append(" \ud83d\udd12").withStyle(ChatFormatting.BOLD);
            }
            return component;
        }

        public Component getNarration() {
            return this.getPositionComponent();
        }
    }
}

