/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.armorposer.client.gui.widgets;

import com.mrbysco.armorposer.Reference;
import com.mrbysco.armorposer.client.gui.ArmorPosesScreen;
import com.mrbysco.armorposer.client.gui.widgets.PoseEntry;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.entity.state.ArmorStandRenderState;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.util.ARGB;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2fStack;

public class PoseListWidget
extends ObjectSelectionList<ListEntry> {
    private final ArmorPosesScreen parent;
    private final int listWidth;
    private final Component title;

    public PoseListWidget(ArmorPosesScreen parent, Component title, boolean user, int listWidth, int top, int bottom) {
        Minecraft minecraft = parent.getScreenMinecraft();
        Objects.requireNonNull(parent.getScreenFont());
        super(minecraft, listWidth, bottom - top, top, 9 * 2 + 16);
        this.parent = parent;
        this.title = title;
        this.listWidth = listWidth;
        this.refreshList(user);
    }

    protected int scrollBarX() {
        return this.getX() + this.listWidth - 6;
    }

    public int getRowWidth() {
        return this.listWidth;
    }

    public void refreshList(boolean user) {
        this.clearEntries();
        if (user) {
            this.parent.buildUserPoseList(x$0 -> this.addEntry((AbstractSelectionList.Entry)x$0), location -> new ListEntry((PoseEntry)location, this.parent));
        } else {
            this.parent.buildPoseList(x$0 -> this.addEntry((AbstractSelectionList.Entry)x$0), location -> new ListEntry((PoseEntry)location, this.parent));
        }
    }

    protected void renderSelection(GuiGraphics guiGraphics, ListEntry listEntry, int p_240142_) {
        int x1 = listEntry.getX();
        int y1 = listEntry.getY();
        int x2 = x1 + listEntry.getWidth();
        int y2 = y1 + listEntry.getHeight();
        guiGraphics.fillGradient(x1, y1, x2, y2, -1945083888, -1676648432);
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        guiGraphics.fillGradient(this.getX(), 0, this.getX() + this.listWidth, this.parent.height, -1945104368, -1676668912);
        super.renderWidget(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.drawCenteredString(this.parent.getScreenFont(), this.title, this.getX() + this.listWidth / 2, 2, ARGB.opaque((int)0xFFFFFF));
    }

    public void setSelected(@Nullable ListEntry selected) {
        this.parent.setSelected((ListEntry)this.getSelected(), selected, this.visible);
        super.setSelected((AbstractSelectionList.Entry)selected);
    }

    public class ListEntry
    extends ObjectSelectionList.Entry<ListEntry> {
        private final PoseEntry poseEntry;
        private final ArmorPosesScreen parent;
        private final ArmorStandRenderState armorStandPreview = new ArmorStandRenderState();

        ListEntry(PoseEntry entry, ArmorPosesScreen parent) {
            ClientLevel level;
            this.poseEntry = entry;
            this.parent = parent;
            this.armorStandPreview.entityType = EntityType.ARMOR_STAND;
            this.armorStandPreview.xRot = 25.0f;
            this.armorStandPreview.bodyRot = 210.0f;
            Minecraft mc = parent.getScreenMinecraft();
            if (mc == null) {
                Reference.LOGGER.error("Minecraft is null, cannot create pose entry {}", (Object)entry.pose().name());
                return;
            }
            Object object = level = mc.hasSingleplayerServer() && mc.getSingleplayerServer() != null ? (Level)mc.getSingleplayerServer().getAllLevels().iterator().next() : mc.level;
            if (level != null) {
                try {
                    ArmorStand armorStand;
                    CompoundTag tag = TagParser.parseCompoundFully((String)entry.pose().data());
                    CompoundTag nbt = new CompoundTag();
                    nbt.putString("id", "minecraft:armor_stand");
                    if (!tag.isEmpty()) {
                        nbt.merge(tag);
                    }
                    if ((armorStand = (ArmorStand)EntityType.loadEntityRecursive((CompoundTag)nbt, (Level)level, (EntitySpawnReason)EntitySpawnReason.LOAD, entity -> {
                        if (entity instanceof ArmorStand) {
                            ArmorStand stand = (ArmorStand)entity;
                            stand.setNoBasePlate(true);
                            stand.setShowArms(true);
                            stand.yBodyRot = 210.0f;
                            stand.setXRot(25.0f);
                            stand.yHeadRot = stand.getYRot();
                            stand.yHeadRotO = stand.getYRot();
                        }
                        return entity;
                    })) != null) {
                        this.updateState(armorStand);
                    }
                }
                catch (Exception e) {
                    Reference.LOGGER.error("Unable to parse nbt pose {}", (Object)e.getMessage());
                }
            }
        }

        public void updateState(ArmorStand stand) {
            this.armorStandPreview.showBasePlate = stand.showBasePlate();
            this.armorStandPreview.isSmall = stand.isSmall();
            this.armorStandPreview.showArms = stand.showArms();
            this.armorStandPreview.isInvisible = stand.isInvisible();
            this.armorStandPreview.nameTag = stand.getCustomName();
            this.armorStandPreview.headPose = stand.getHeadPose();
            this.armorStandPreview.bodyPose = stand.getBodyPose();
            this.armorStandPreview.leftArmPose = stand.getLeftArmPose();
            this.armorStandPreview.rightArmPose = stand.getRightArmPose();
            this.armorStandPreview.leftLegPose = stand.getLeftLegPose();
            this.armorStandPreview.rightLegPose = stand.getRightLegPose();
        }

        public void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean hovered, float partialTick) {
            int left = this.getContentX();
            int top = this.getContentY();
            Matrix3x2fStack pose = guiGraphics.pose();
            pose.pushMatrix();
            pose.translate((float)left, (float)(top - PoseListWidget.this.height / 2));
            PoseListWidget.this.renderScrollingStringOverContents(guiGraphics.textRenderer(), (Component)Component.literal((String)this.getName()), 18);
            if (PoseListWidget.this.getSelected() == this) {
                this.renderPose(guiGraphics, left + 16, top + 28, partialTick);
            }
            pose.popMatrix();
        }

        public void renderPose(GuiGraphics guiGraphics, int xPos, int yPos, float partialTick) {
            if (this.armorStandPreview != null) {
                int startX = xPos - 40;
                int startY = yPos - 60;
                int endX = xPos + 40;
                int endY = yPos + 60;
                guiGraphics.submitEntityRenderState((EntityRenderState)this.armorStandPreview, 20.0f, Reference.ARMOR_STAND_TRANSLATION, Reference.ARMOR_STAND_ANGLE, null, startX, startY, endX, endY);
            }
        }

        public CompoundTag getTag() {
            return this.poseEntry.getTag();
        }

        public String getName() {
            return this.poseEntry.getName();
        }

        public boolean userAdded() {
            return this.poseEntry.userAdded();
        }

        public String rawName() {
            return this.poseEntry.pose().name();
        }

        public Component getNarration() {
            return Component.literal((String)this.getName());
        }
    }
}

