/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.immediatelyfast;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.raphimc.immediatelyfast.PlatformCode;
import net.raphimc.immediatelyfast.feature.core.ImmediatelyFastConfig;
import net.raphimc.immediatelyfast.feature.core.ImmediatelyFastRuntimeConfig;
import net.raphimc.immediatelyfast.feature.sign_text_buffering.SignTextCache;
import net.raphimc.immediatelyfast.util.IrisCompat;
import org.lwjgl.system.MathUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Unsafe;

public class ImmediatelyFast {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"ImmediatelyFast");
    public static final Unsafe UNSAFE = ImmediatelyFast.getUnsafe();
    public static String VERSION;
    public static ImmediatelyFastConfig config;
    public static ImmediatelyFastRuntimeConfig runtimeConfig;
    public static SignTextCache signTextCache;

    public static void earlyInit() {
        if (config != null) {
            return;
        }
        ImmediatelyFast.loadConfig();
        if (!ImmediatelyFast.config.debug_only_and_not_recommended_disable_mod_conflict_handling && ImmediatelyFast.config.experimental_sign_text_buffering && PlatformCode.getModVersion("vulkanmod").isPresent()) {
            LOGGER.warn("VulkanMod detected. Force disabling sign text buffering optimization.");
            ImmediatelyFast.config.experimental_sign_text_buffering = false;
        }
        ImmediatelyFast.createRuntimeConfig();
        VERSION = PlatformCode.getModVersion("immediatelyfast").orElseThrow(NullPointerException::new);
        PlatformCode.checkModCompatibility();
    }

    public static void onRenderSystemInit() {
        String gpuVendor = RenderSystem.getDevice().getVendor();
        String gpuModel = RenderSystem.getDevice().getRenderer();
        String backendName = RenderSystem.getDevice().getBackendName();
        String backendVersion = RenderSystem.getDevice().getVersion();
        LOGGER.info("Initializing ImmediatelyFast " + VERSION + " on " + gpuModel + " (" + gpuVendor + ") with " + backendName + " " + backendVersion);
        boolean isNvidia = false;
        boolean isAmd = false;
        boolean isIntel = false;
        boolean isApple = false;
        if (gpuVendor != null) {
            String gpuVendorLower = gpuVendor.toLowerCase();
            isNvidia = gpuVendorLower.startsWith("nvidia");
            isAmd = gpuVendorLower.startsWith("ati") || gpuVendorLower.startsWith("amd");
            isIntel = gpuVendorLower.startsWith("intel");
            isApple = gpuVendorLower.startsWith("apple");
        }
        Objects.requireNonNull(config, "Config not loaded yet");
        Objects.requireNonNull(runtimeConfig, "Runtime config not created yet");
        if (ImmediatelyFast.config.fix_slow_buffer_upload_on_apple_gpu && isApple && !RenderSystem.getDevice().getEnabledExtensions().contains("GL_ARB_direct_state_access") && !RenderSystem.getDevice().getEnabledExtensions().contains("GL_ARB_buffer_storage")) {
            ImmediatelyFast.runtimeConfig.disable_fast_buffer_upload = true;
        }
        if (!ImmediatelyFast.config.debug_only_and_not_recommended_disable_mod_conflict_handling) {
            PlatformCode.getModVersion("iris").or(() -> PlatformCode.getModVersion("oculus")).ifPresent(version -> {
                LOGGER.info("Found Iris/Oculus " + version + ". Enabling compatibility.");
                IrisCompat.init();
            });
        }
    }

    public static void lateInit() {
        if (ImmediatelyFast.config.experimental_sign_text_buffering) {
            signTextCache = new SignTextCache();
            if (PlatformCode.getModVersion("neoforge").isEmpty()) {
                ((ReloadableResourceManager)Minecraft.getInstance().getResourceManager()).registerReloadListener((PreparableReloadListener)signTextCache);
            }
        }
    }

    public static void onLevelChange() {
        if (signTextCache != null) {
            signTextCache.clearCache();
        }
    }

    public static void loadConfig() {
        File configFile = PlatformCode.getConfigDirectory().resolve("immediatelyfast.json").toFile();
        if (configFile.exists()) {
            try {
                config = (ImmediatelyFastConfig)new Gson().fromJson((Reader)new FileReader(configFile), ImmediatelyFastConfig.class);
            }
            catch (Throwable e) {
                LOGGER.error("Failed to load ImmediatelyFast config. Resetting it.", e);
            }
        }
        if (config == null) {
            config = new ImmediatelyFastConfig();
        }
        try {
            Files.writeString(configFile.toPath(), (CharSequence)new GsonBuilder().setPrettyPrinting().create().toJson((Object)config), new OpenOption[0]);
        }
        catch (Throwable e) {
            LOGGER.error("Failed to save ImmediatelyFast config.", e);
        }
        if (!MathUtil.mathIsPoT((int)ImmediatelyFast.config.font_atlas_size)) {
            LOGGER.warn("Font atlas size " + ImmediatelyFast.config.font_atlas_size + " is not a power of two! Rounding up to the next power of two.");
            ImmediatelyFast.config.font_atlas_size = MathUtil.mathRoundPoT((int)ImmediatelyFast.config.font_atlas_size);
        }
        if (!MathUtil.mathIsPoT((int)ImmediatelyFast.config.map_atlas_size)) {
            LOGGER.warn("Map atlas size " + ImmediatelyFast.config.map_atlas_size + " is not a power of two! Rounding up to the next power of two.");
            ImmediatelyFast.config.map_atlas_size = MathUtil.mathRoundPoT((int)ImmediatelyFast.config.map_atlas_size);
        }
    }

    public static void createRuntimeConfig() {
        runtimeConfig = new ImmediatelyFastRuntimeConfig(config);
    }

    private static Unsafe getUnsafe() {
        try {
            for (Field field : Unsafe.class.getDeclaredFields()) {
                if (!field.getType().equals(Unsafe.class)) continue;
                field.setAccessible(true);
                return (Unsafe)field.get(null);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        throw new IllegalStateException("Unable to get Unsafe instance");
    }
}

