/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.immediatelyfast.feature.core;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectSortedMaps;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.Reference2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.SequencedMap;
import java.util.Set;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.rendertype.RenderSetup;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.resources.Identifier;
import net.raphimc.immediatelyfast.ImmediatelyFast;
import net.raphimc.immediatelyfast.feature.core.ByteBufferBuilderPool;
import net.raphimc.immediatelyfast.util.IrisCompat;

public class BatchableBufferSource
extends MultiBufferSource.BufferSource
implements AutoCloseable {
    private static final ByteBufferBuilder FALLBACK_BUFFER = new ByteBufferBuilder(0);
    protected final Map<RenderType, ReferenceSet<BufferBuilder>> dynamicBuffers = IrisCompat.IRIS_LOADED ? new Object2ObjectLinkedOpenHashMap() : new Reference2ObjectLinkedOpenHashMap();
    protected final Set<RenderType> activeRenderTypes = IrisCompat.IRIS_LOADED ? new ObjectLinkedOpenHashSet() : new ReferenceLinkedOpenHashSet();
    protected boolean drawDynamicBuffersFirst = false;

    public BatchableBufferSource() {
        this((SequencedMap<RenderType, ByteBufferBuilder>)Object2ObjectSortedMaps.emptyMap());
    }

    public BatchableBufferSource(SequencedMap<RenderType, ByteBufferBuilder> fixedBuffers) {
        this(FALLBACK_BUFFER, fixedBuffers);
    }

    public BatchableBufferSource(ByteBufferBuilder sharedBuffer, SequencedMap<RenderType, ByteBufferBuilder> fixedBuffers) {
        super(sharedBuffer, fixedBuffers);
    }

    public VertexConsumer getBuffer(RenderType renderType) {
        BufferBuilder bufferBuilder;
        boolean hasBufferForRenderType;
        if (!this.drawDynamicBuffersFirst && this.lastSharedType != null && this.lastSharedType != renderType && !this.fixedBuffers.containsKey(this.lastSharedType)) {
            this.drawDynamicBuffersFirst = true;
        }
        if (IrisCompat.IRIS_LOADED) {
            IrisCompat.skipExtension.set(!IrisCompat.isRenderingLevel.getAsBoolean());
        }
        boolean bl = hasBufferForRenderType = renderType.canConsolidateConsecutiveGeometry() && this.dynamicBuffers.containsKey(renderType);
        if (!renderType.canConsolidateConsecutiveGeometry()) {
            bufferBuilder = new BufferBuilder(this.getNextByteBufferBuilder(), renderType.mode(), renderType.format());
            this.lastSharedType = renderType;
        } else if (hasBufferForRenderType) {
            bufferBuilder = (BufferBuilder)this.dynamicBuffers.get(renderType).iterator().next();
        } else if (this.fixedBuffers.containsKey(renderType)) {
            bufferBuilder = new BufferBuilder((ByteBufferBuilder)this.fixedBuffers.get(renderType), renderType.mode(), renderType.format());
        } else {
            bufferBuilder = new BufferBuilder(this.getNextByteBufferBuilder(), renderType.mode(), renderType.format());
            this.lastSharedType = renderType;
        }
        if (IrisCompat.IRIS_LOADED) {
            IrisCompat.skipExtension.set(false);
        }
        if (!hasBufferForRenderType) {
            this.dynamicBuffers.computeIfAbsent(renderType, k -> new ReferenceLinkedOpenHashSet()).add((Object)bufferBuilder);
        }
        if (hasBufferForRenderType) {
            if ((ImmediatelyFast.config.debug_only_use_last_usage_for_batch_ordering || renderType.name.contains("immediatelyfast:renderlast")) && this.activeRenderTypes.contains(renderType)) {
                this.activeRenderTypes.remove(renderType);
                this.activeRenderTypes.add(renderType);
            }
        } else {
            this.activeRenderTypes.add(renderType);
        }
        return bufferBuilder;
    }

    public void endLastBatch() {
        this.lastSharedType = null;
        this.drawDynamicBuffersFirst = false;
        int sortedRenderTypesLength = 0;
        RenderType[] sortedRenderTypes = new RenderType[this.activeRenderTypes.size()];
        for (RenderType renderType : this.activeRenderTypes) {
            if (this.fixedBuffers.containsKey(renderType)) continue;
            sortedRenderTypes[sortedRenderTypesLength++] = renderType;
        }
        if (sortedRenderTypesLength == 0) {
            return;
        }
        Arrays.sort(sortedRenderTypes, (t1, t2) -> Integer.compare(this.getRenderTypeOrder((RenderType)t1), this.getRenderTypeOrder((RenderType)t2)));
        for (int i = 0; i < sortedRenderTypesLength; ++i) {
            this.endBatch(sortedRenderTypes[i]);
        }
    }

    public void endBatch() {
        if (this.activeRenderTypes.isEmpty()) {
            this.close();
            return;
        }
        this.endLastBatch();
        for (RenderType renderType : this.fixedBuffers.keySet()) {
            this.endBatch(renderType);
        }
    }

    public void endBatch(RenderType renderType) {
        if (this.drawDynamicBuffersFirst) {
            this.endLastBatch();
        }
        this.drawDirect(renderType);
    }

    @Override
    public void close() {
        this.lastSharedType = null;
        this.drawDynamicBuffersFirst = false;
        for (RenderType renderType : this.activeRenderTypes) {
            for (BufferBuilder bufferBuilder : this.getBufferBuilder(renderType)) {
                bufferBuilder.build();
                ByteBufferBuilderPool.returnBufferBuilderSafe(bufferBuilder.buffer);
            }
        }
        this.activeRenderTypes.clear();
        this.dynamicBuffers.clear();
    }

    public void drawDirect(RenderType renderType) {
        if (IrisCompat.IRIS_LOADED && !IrisCompat.isRenderingLevel.getAsBoolean()) {
            IrisCompat.renderWithExtendedVertexFormat.accept(false);
        }
        this.activeRenderTypes.remove(renderType);
        for (BufferBuilder bufferBuilder : this.getBufferBuilder(renderType)) {
            ByteBufferBuilder prevBufferBuilder = this.sharedBuffer;
            this.sharedBuffer = bufferBuilder.buffer;
            this.endBatch(renderType, bufferBuilder);
            this.sharedBuffer = prevBufferBuilder;
            ByteBufferBuilderPool.returnBufferBuilderSafe(bufferBuilder.buffer);
        }
        this.dynamicBuffers.remove(renderType);
        if (this.lastSharedType == renderType) {
            this.lastSharedType = null;
        }
        if (IrisCompat.IRIS_LOADED && !IrisCompat.isRenderingLevel.getAsBoolean()) {
            IrisCompat.renderWithExtendedVertexFormat.accept(true);
        }
    }

    public boolean hasActiveRenderTypes() {
        return !this.activeRenderTypes.isEmpty();
    }

    protected Set<BufferBuilder> getBufferBuilder(RenderType renderType) {
        if (this.dynamicBuffers.containsKey(renderType)) {
            return (Set)this.dynamicBuffers.get(renderType);
        }
        return Collections.emptySet();
    }

    protected int getRenderTypeOrder(RenderType renderType) {
        if (renderType == null) {
            return Integer.MAX_VALUE;
        }
        int order = 0;
        RenderSetup.TextureBinding textureBinding = (RenderSetup.TextureBinding)renderType.state.textures.get("Sampler0");
        if (textureBinding != null) {
            Identifier textureId = textureBinding.location();
            if (renderType.name.startsWith("text") || renderType.name.startsWith("neoforge_text")) {
                order = textureId.getNamespace().equals("minecraft") ? 2 : 1;
            }
        }
        if (!renderType.sortOnUpload()) {
            return order;
        }
        return 100000000 + order;
    }

    private ByteBufferBuilder getNextByteBufferBuilder() {
        if (this.sharedBuffer != FALLBACK_BUFFER && this.lastSharedType == null && this.sharedBuffer.pointer != 0L) {
            return this.sharedBuffer;
        }
        return ByteBufferBuilderPool.borrowBufferBuilder();
    }
}

