/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.blocks;

import de.maxhenkel.easyvillagers.blocks.VillagerBlockBase;
import de.maxhenkel.easyvillagers.blocks.tileentity.TraderTileentityBase;
import de.maxhenkel.easyvillagers.corelib.blockentity.SimpleBlockEntityTicker;
import de.maxhenkel.easyvillagers.corelib.item.ItemUtils;
import de.maxhenkel.easyvillagers.entity.EasyVillagerEntity;
import de.maxhenkel.easyvillagers.items.VillagerItem;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.villager.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;

public abstract class TraderBlockBase
extends VillagerBlockBase {
    public TraderBlockBase(BlockBehaviour.Properties properties) {
        super(properties.mapColor(MapColor.METAL).strength(2.5f).sound(SoundType.METAL).noOcclusion());
    }

    protected InteractionResult useItemOn(ItemStack heldItem, BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockEntity tileEntity = level.getBlockEntity(pos);
        if (!(tileEntity instanceof TraderTileentityBase)) {
            return super.useItemOn(heldItem, state, level, pos, player, handIn, hit);
        }
        TraderTileentityBase trader = (TraderTileentityBase)tileEntity;
        if (!trader.hasVillager() && heldItem.getItem() instanceof VillagerItem) {
            trader.setVillager(heldItem.copy());
            ItemUtils.decrItemStack(heldItem, player);
            if (trader.hasWorkstation()) {
                EasyVillagerEntity villagerEntity = trader.getVillagerEntity();
                if (villagerEntity != null) {
                    this.playWorkstationSound(level, pos, trader);
                }
            } else {
                TraderBlockBase.playVillagerSound(level, pos, SoundEvents.VILLAGER_CELEBRATE);
            }
            return InteractionResult.SUCCESS;
        }
        if (!trader.hasWorkstation() && heldItem.getItem() instanceof BlockItem && trader.isValidBlock(((BlockItem)heldItem.getItem()).getBlock())) {
            Block block = ((BlockItem)heldItem.getItem()).getBlock();
            trader.setWorkstation(block);
            ItemUtils.decrItemStack(heldItem, player);
            EasyVillagerEntity villagerEntity = trader.getVillagerEntity();
            if (villagerEntity != null) {
                this.playWorkstationSound(level, pos, trader);
            }
            SoundType type = block.defaultBlockState().getSoundType((LevelReader)level, pos, (Entity)player);
            level.playSound(null, pos, type.getPlaceSound(), SoundSource.BLOCKS, type.getVolume(), type.getPitch());
            return InteractionResult.SUCCESS;
        }
        if (player.isShiftKeyDown() && trader.hasVillager()) {
            ItemStack stack = trader.removeVillager();
            if (heldItem.isEmpty()) {
                player.setItemInHand(handIn, stack);
            } else if (!player.getInventory().add(stack)) {
                Direction direction = (Direction)state.getValue((Property)FACING);
                Containers.dropItemStack((Level)level, (double)((double)(direction.getStepX() + pos.getX()) + 0.5), (double)((double)pos.getY() + 0.5), (double)((double)(direction.getStepZ() + pos.getZ()) + 0.5), (ItemStack)stack);
            }
            TraderBlockBase.playVillagerSound(level, pos, SoundEvents.VILLAGER_CELEBRATE);
            return InteractionResult.SUCCESS;
        }
        if (player.isShiftKeyDown() && trader.hasWorkstation()) {
            ItemStack blockStack = new ItemStack((ItemLike)trader.removeWorkstation());
            if (heldItem.isEmpty()) {
                player.setItemInHand(handIn, blockStack);
            } else if (!player.getInventory().add(blockStack)) {
                Direction direction = (Direction)state.getValue((Property)FACING);
                Containers.dropItemStack((Level)level, (double)((double)(direction.getStepX() + pos.getX()) + 0.5), (double)((double)pos.getY() + 0.5), (double)((double)(direction.getStepZ() + pos.getZ()) + 0.5), (ItemStack)blockStack);
            }
            if (trader.hasVillager()) {
                TraderBlockBase.playVillagerSound(level, pos, SoundEvents.VILLAGER_NO);
            }
            return InteractionResult.SUCCESS;
        }
        if (this.openGUI(trader, player, level, pos)) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    protected abstract boolean openGUI(TraderTileentityBase var1, Player var2, Level var3, BlockPos var4);

    protected void playWorkstationSound(Level world, BlockPos pos, TraderTileentityBase trader) {
        EasyVillagerEntity villagerEntity = trader.getVillagerEntity();
        if (villagerEntity != null) {
            if (trader.getWorkstationProfession().equals(villagerEntity.getVillagerData().profession().value())) {
                TraderBlockBase.playVillagerSound(world, pos, ((VillagerProfession)trader.getWorkstationProfession().value()).workSound());
            } else {
                TraderBlockBase.playVillagerSound(world, pos, SoundEvents.VILLAGER_NO);
            }
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level1, BlockState state, BlockEntityType<T> type) {
        return new SimpleBlockEntityTicker();
    }

    @Nullable
    public abstract BlockEntity newBlockEntity(BlockPos var1, BlockState var2);

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public float getShadeBrightness(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 1.0f;
    }
}

