/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.blocks;

import de.maxhenkel.easyvillagers.EasyVillagersMod;
import de.maxhenkel.easyvillagers.blocks.HorizontalRotatableBlock;
import de.maxhenkel.easyvillagers.corelib.block.VoxelUtils;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class VillagerBlockBase
extends HorizontalRotatableBlock
implements EntityBlock {
    private static final VoxelShape SHAPE = VoxelUtils.combine(Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), Block.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0), Block.box((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), Block.box((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0));

    public VillagerBlockBase(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public boolean overrideClick(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn) {
        return player.isShiftKeyDown() && player.getMainHandItem().isEmpty();
    }

    public static void playRandomVillagerSound(Level world, BlockPos pos, SoundEvent soundEvent) {
        if (world.getGameTime() % (long)((Integer)EasyVillagersMod.SERVER_CONFIG.villagerSoundAmount.get()).intValue() == 0L && world.random.nextInt(40) == 0) {
            VillagerBlockBase.playVillagerSound(world, pos, soundEvent);
        }
    }

    public static void playRandomVillagerSound(ServerPlayer player, SoundEvent soundEvent) {
        if (player.level().getGameTime() % (long)((Integer)EasyVillagersMod.SERVER_CONFIG.villagerSoundAmount.get()).intValue() == 0L && player.level().random.nextInt(40) == 0) {
            player.connection.send((Packet)new ClientboundSoundPacket(BuiltInRegistries.SOUND_EVENT.wrapAsHolder((Object)soundEvent), SoundSource.BLOCKS, player.getX(), player.getY(), player.getZ(), 1.0f, 1.0f, player.getRandom().nextLong()));
        }
    }

    public static void playVillagerSound(Level world, BlockPos pos, SoundEvent soundEvent) {
        world.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public VoxelShape getShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void onTooltip(ItemStack stack, Item.TooltipContext context, Consumer<Component> component) {
    }
}

