/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.blocks.tileentity;

import de.maxhenkel.easyvillagers.EasyVillagersMod;
import de.maxhenkel.easyvillagers.blocks.BreederBlock;
import de.maxhenkel.easyvillagers.blocks.ModBlocks;
import de.maxhenkel.easyvillagers.blocks.VillagerBlockBase;
import de.maxhenkel.easyvillagers.blocks.tileentity.FakeWorldTileentity;
import de.maxhenkel.easyvillagers.blocks.tileentity.ModTileEntities;
import de.maxhenkel.easyvillagers.blocks.tileentity.VillagerTileentity;
import de.maxhenkel.easyvillagers.corelib.blockentity.IServerTickableBlockEntity;
import de.maxhenkel.easyvillagers.corelib.inventory.ItemListInventory;
import de.maxhenkel.easyvillagers.corelib.item.ItemUtils;
import de.maxhenkel.easyvillagers.datacomponents.VillagerData;
import de.maxhenkel.easyvillagers.entity.EasyVillagerEntity;
import de.maxhenkel.easyvillagers.gui.FoodSlot;
import de.maxhenkel.easyvillagers.inventory.InputOnlyResourceHandler;
import de.maxhenkel.easyvillagers.inventory.ListAccessItemStacksResourceHandler;
import de.maxhenkel.easyvillagers.inventory.OutputOnlyResourceHandler;
import de.maxhenkel.easyvillagers.inventory.ValidateResourceHandler;
import de.maxhenkel.easyvillagers.items.ModItems;
import de.maxhenkel.easyvillagers.net.MessageVillagerParticles;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.villager.Villager;
import net.minecraft.world.entity.npc.villager.VillagerType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.transfer.CombinedResourceHandler;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public class BreederTileentity
extends FakeWorldTileentity
implements IServerTickableBlockEntity {
    protected final ValidateResourceHandler foodInventory = new ValidateResourceHandler(4, FoodSlot::isValid);
    protected final ListAccessItemStacksResourceHandler outputInventory = new ListAccessItemStacksResourceHandler(4);
    protected ItemStack villager1 = ItemStack.EMPTY;
    protected EasyVillagerEntity villagerEntity1;
    protected ItemStack villager2 = ItemStack.EMPTY;
    protected EasyVillagerEntity villagerEntity2;
    private final CombinedResourceHandler<ItemResource> itemHandler = new CombinedResourceHandler(new ResourceHandler[]{new InputOnlyResourceHandler((ResourceHandler<ItemResource>)this.foodInventory), new OutputOnlyResourceHandler((ResourceHandler<ItemResource>)this.outputInventory)});

    public BreederTileentity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.BREEDER.get(), ((BreederBlock)((Object)ModBlocks.BREEDER.get())).defaultBlockState(), pos, state);
    }

    public ItemStack getVillager1() {
        return this.villager1;
    }

    public ItemStack getVillager2() {
        return this.villager2;
    }

    public boolean hasVillager1() {
        return !this.villager1.isEmpty();
    }

    public boolean hasVillager2() {
        return !this.villager2.isEmpty();
    }

    public EasyVillagerEntity getVillagerEntity1() {
        if (this.villagerEntity1 == null && !this.villager1.isEmpty()) {
            this.villagerEntity1 = VillagerData.createEasyVillager(this.villager1, this.level);
        }
        return this.villagerEntity1;
    }

    public EasyVillagerEntity getVillagerEntity2() {
        if (this.villagerEntity2 == null && !this.villager2.isEmpty()) {
            this.villagerEntity2 = VillagerData.createEasyVillager(this.villager2, this.level);
        }
        return this.villagerEntity2;
    }

    public void setVillager1(ItemStack villager) {
        this.villager1 = villager;
        this.villagerEntity1 = villager.isEmpty() ? null : VillagerData.createEasyVillager(villager, this.level);
        this.setChanged();
        this.sync();
    }

    public void setVillager2(ItemStack villager) {
        this.villager2 = villager;
        this.villagerEntity2 = villager.isEmpty() ? null : VillagerData.createEasyVillager(villager, this.level);
        this.setChanged();
        this.sync();
    }

    public ItemStack removeVillager1() {
        ItemStack v = this.villager1;
        this.setVillager1(ItemStack.EMPTY);
        return v;
    }

    public ItemStack removeVillager2() {
        ItemStack v = this.villager2;
        this.setVillager2(ItemStack.EMPTY);
        return v;
    }

    @Override
    public void tickServer() {
        if (this.level.isClientSide()) {
            return;
        }
        boolean age1 = VillagerTileentity.advanceAge(this.getVillagerEntity1());
        boolean age2 = VillagerTileentity.advanceAge(this.getVillagerEntity2());
        if (age1 || age2) {
            this.sync();
        }
        if (this.hasVillager1() || this.hasVillager2()) {
            this.setChanged();
            VillagerBlockBase.playRandomVillagerSound(this.level, this.getBlockPos(), SoundEvents.VILLAGER_AMBIENT);
        }
        if (this.level.getGameTime() % (long)((Integer)EasyVillagersMod.SERVER_CONFIG.breedingTime.get()).intValue() == 0L) {
            this.tryBreed();
        }
    }

    public void tryBreed() {
        if (!this.canBreed()) {
            return;
        }
        try (Transaction transaction = Transaction.open(null);){
            if (!this.removeBreedingItems((TransactionContext)transaction)) {
                return;
            }
            if (!this.addVillager((TransactionContext)transaction)) {
                return;
            }
            VillagerBlockBase.playVillagerSound(this.level, this.worldPosition, SoundEvents.VILLAGER_CELEBRATE);
            this.spawnParticles();
            transaction.commit();
        }
    }

    public void spawnParticles() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverLevel, (ChunkPos)new ChunkPos(this.worldPosition), (CustomPacketPayload)new MessageVillagerParticles(this.worldPosition), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else if (this.level.isClientSide()) {
            for (int i = 0; i < 5; ++i) {
                this.level.addParticle((ParticleOptions)ParticleTypes.HEART, (double)this.worldPosition.getX() + (this.level.random.nextDouble() - 0.5) + 0.5, (double)this.worldPosition.getY() + this.level.random.nextDouble() + 1.0, (double)this.worldPosition.getZ() + (this.level.random.nextDouble() - 0.5) + 0.5, 0.0, 0.0, 0.0);
            }
        }
    }

    private boolean addVillager(TransactionContext transaction) {
        EasyVillagerEntity villagerEntity = new EasyVillagerEntity((EntityType<? extends Villager>)EntityType.VILLAGER, this.level);
        villagerEntity.setVillagerData(villagerEntity.getVillagerData().withType((HolderGetter.Provider)this.level.registryAccess(), VillagerType.byBiome((Holder)this.level.getBiome(this.getBlockPos()))));
        villagerEntity.setAge(-24000);
        ItemStack villager = new ItemStack((ItemLike)ModItems.VILLAGER.get());
        VillagerData.applyToItem(villager, villagerEntity);
        return this.outputInventory.insert((Resource)ItemResource.of((ItemStack)villager), 1, transaction) > 0;
    }

    public boolean canBreed() {
        if (!this.hasVillager1() || !this.hasVillager2()) {
            return false;
        }
        if (this.getVillagerEntity1().isBaby() || this.getVillagerEntity2().isBaby()) {
            return false;
        }
        int value = 0;
        for (int i = 0; i < this.foodInventory.size(); ++i) {
            ItemResource resource = (ItemResource)this.foodInventory.getResource(i);
            value += Villager.FOOD_POINTS.getOrDefault(resource.getItem(), 0) * this.foodInventory.getAmountAsInt(i);
        }
        return value >= 24;
    }

    private boolean removeBreedingItems(TransactionContext transaction) {
        int value = 0;
        for (int i = 0; i < this.foodInventory.size(); ++i) {
            int amountNeeded;
            int amountToRemove;
            int extracted;
            int itemValue;
            ItemResource resource = (ItemResource)this.foodInventory.getResource(i);
            if (resource.isEmpty() || (itemValue = Villager.FOOD_POINTS.getOrDefault(resource.getItem(), 0).intValue()) <= 0 || (value += (extracted = this.foodInventory.extract(i, (Resource)resource, amountToRemove = ((amountNeeded = 24 - value) + itemValue - 1) / itemValue, transaction)) * itemValue) < 24) continue;
            return true;
        }
        return false;
    }

    protected void saveAdditional(ValueOutput valueOutput) {
        super.saveAdditional(valueOutput);
        if (this.hasVillager1()) {
            valueOutput.store("Villager1", ItemStack.CODEC, (Object)this.getVillager1());
        }
        if (this.hasVillager2()) {
            valueOutput.store("Villager2", ItemStack.CODEC, (Object)this.getVillager2());
        }
        ItemUtils.saveInventory(valueOutput.child("FoodInventory"), "Items", (NonNullList<ItemStack>)this.foodInventory.copyToList());
        ItemUtils.saveInventory(valueOutput.child("OutputInventory"), "Items", (NonNullList<ItemStack>)this.outputInventory.copyToList());
    }

    protected void loadAdditional(ValueInput valueInput) {
        Optional optionalVillager1 = valueInput.read("Villager1", ItemStack.CODEC);
        if (optionalVillager1.isPresent()) {
            this.villager1 = (ItemStack)optionalVillager1.get();
            this.villagerEntity1 = null;
        } else {
            this.removeVillager1();
        }
        Optional optionalVillager2 = valueInput.read("Villager2", ItemStack.CODEC);
        if (optionalVillager2.isPresent()) {
            this.villager2 = (ItemStack)optionalVillager2.get();
            this.villagerEntity2 = null;
        } else {
            this.removeVillager1();
        }
        ItemUtils.readInventory(valueInput.childOrEmpty("FoodInventory"), "Items", this.foodInventory.getRaw());
        ItemUtils.readInventory(valueInput.childOrEmpty("OutputInventory"), "Items", this.outputInventory.getRaw());
        super.loadAdditional(valueInput);
    }

    public Container getFoodInventory() {
        return new ItemListInventory(this.foodInventory.getRaw(), () -> ((BreederTileentity)this).setChanged());
    }

    public Container getOutputInventory() {
        return new ItemListInventory(this.outputInventory.getRaw(), () -> ((BreederTileentity)this).setChanged());
    }

    public ResourceHandler<ItemResource> getItemHandler() {
        return this.itemHandler;
    }
}

