/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.blocks.tileentity;

import de.maxhenkel.easyvillagers.EasyVillagersMod;
import de.maxhenkel.easyvillagers.blocks.IronFarmBlock;
import de.maxhenkel.easyvillagers.blocks.ModBlocks;
import de.maxhenkel.easyvillagers.blocks.VillagerBlockBase;
import de.maxhenkel.easyvillagers.blocks.tileentity.ModTileEntities;
import de.maxhenkel.easyvillagers.blocks.tileentity.VillagerTileentity;
import de.maxhenkel.easyvillagers.corelib.blockentity.ITickableBlockEntity;
import de.maxhenkel.easyvillagers.corelib.inventory.ItemListInventory;
import de.maxhenkel.easyvillagers.entity.EasyVillagerEntity;
import de.maxhenkel.easyvillagers.inventory.ListAccessItemStacksResourceHandler;
import de.maxhenkel.easyvillagers.inventory.OutputOnlyResourceHandler;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.golem.IronGolem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public class IronFarmTileentity
extends VillagerTileentity
implements ITickableBlockEntity {
    private static final ResourceKey<LootTable> GOLEM_LOOT_TABLE = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (Identifier)Identifier.withDefaultNamespace((String)"entities/iron_golem"));
    protected ListAccessItemStacksResourceHandler inventory = new ListAccessItemStacksResourceHandler(4);
    protected OutputOnlyResourceHandler outputInventoryDelegate = new OutputOnlyResourceHandler((ResourceHandler<ItemResource>)this.inventory);
    protected long timer;

    public IronFarmTileentity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.IRON_FARM.get(), ((IronFarmBlock)((Object)ModBlocks.IRON_FARM.get())).defaultBlockState(), pos, state);
    }

    public long getTimer() {
        return this.timer;
    }

    @Override
    public void tick() {
        EasyVillagerEntity v = this.getVillagerEntity();
        if (v != null) {
            VillagerBlockBase.playRandomVillagerSound(this.level, this.getBlockPos(), SoundEvents.VILLAGER_AMBIENT);
            VillagerBlockBase.playRandomVillagerSound(this.level, this.getBlockPos(), SoundEvents.ZOMBIE_AMBIENT);
            if (this.advanceAge()) {
                this.sync();
            }
            ++this.timer;
            this.setChanged();
            if (this.timer == (long)IronFarmTileentity.getGolemSpawnTime()) {
                VillagerBlockBase.playVillagerSound(this.level, this.getBlockPos(), SoundEvents.ZOMBIE_AMBIENT);
                this.sync();
            } else if (this.timer > (long)IronFarmTileentity.getGolemSpawnTime() && this.timer < (long)IronFarmTileentity.getGolemKillTime()) {
                if (this.timer % 20L == 0L) {
                    VillagerBlockBase.playVillagerSound(this.level, this.getBlockPos(), SoundEvents.IRON_GOLEM_HURT);
                }
            } else if (this.timer >= (long)IronFarmTileentity.getGolemKillTime()) {
                VillagerBlockBase.playVillagerSound(this.level, this.getBlockPos(), SoundEvents.IRON_GOLEM_DEATH);
                try (Transaction transaction = Transaction.open(null);){
                    for (ItemStack stack : this.getDrops()) {
                        if (stack.isEmpty()) continue;
                        this.inventory.insert((Resource)ItemResource.of((ItemStack)stack), stack.getCount(), (TransactionContext)transaction);
                    }
                    transaction.commit();
                }
                this.timer = 0L;
                this.sync();
            }
        }
    }

    private List<ItemStack> getDrops() {
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return Collections.emptyList();
        }
        ServerLevel serverLevel = (ServerLevel)level;
        LootParams.Builder builder = new LootParams.Builder(serverLevel).withParameter(LootContextParams.THIS_ENTITY, (Object)new IronGolem(EntityType.IRON_GOLEM, this.level)).withParameter(LootContextParams.ORIGIN, (Object)new Vec3((double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ())).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)serverLevel.damageSources().lava());
        LootParams lootContext = builder.create(LootContextParamSets.ENTITY);
        LootTable lootTable = serverLevel.getServer().reloadableRegistries().getLootTable(GOLEM_LOOT_TABLE);
        return lootTable.getRandomItems(lootContext);
    }

    public Container getOutputInventory() {
        return new ItemListInventory(this.inventory.getRaw(), () -> ((IronFarmTileentity)this).setChanged());
    }

    @Override
    protected void saveAdditional(ValueOutput valueOutput) {
        super.saveAdditional(valueOutput);
        ContainerHelper.saveAllItems((ValueOutput)valueOutput, this.inventory.getRaw(), (boolean)false);
        valueOutput.putLong("Timer", this.timer);
    }

    @Override
    protected void loadAdditional(ValueInput valueInput) {
        ContainerHelper.loadAllItems((ValueInput)valueInput, this.inventory.getRaw());
        this.timer = valueInput.getLongOr("Timer", 0L);
        super.loadAdditional(valueInput);
    }

    public static int getGolemSpawnTime() {
        return (Integer)EasyVillagersMod.SERVER_CONFIG.golemSpawnTime.get() - 200;
    }

    public static int getGolemKillTime() {
        return IronFarmTileentity.getGolemSpawnTime() + 200;
    }

    public ResourceHandler<ItemResource> getItemHandler() {
        return this.outputInventoryDelegate;
    }
}

