/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.blocks.tileentity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.maxhenkel.easyvillagers.blocks.TraderBlock;
import de.maxhenkel.easyvillagers.blocks.tileentity.BreederTileentity;
import de.maxhenkel.easyvillagers.blocks.tileentity.render.BreederRenderState;
import de.maxhenkel.easyvillagers.blocks.tileentity.render.VillagerRendererBase;
import java.lang.ref.WeakReference;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BedRenderer;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.entity.VillagerRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.resources.model.MaterialSet;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.npc.villager.Villager;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class BreederRenderer
extends VillagerRendererBase<BreederTileentity, BreederRenderState> {
    private WeakReference<BedRenderer> bedRendererCache = new WeakReference<Object>(null);
    private final MaterialSet materialSet;

    public BreederRenderer(EntityModelSet entityModelSet, MaterialSet materialSet) {
        super(entityModelSet);
        this.materialSet = materialSet;
    }

    public BreederRenderState createRenderState() {
        return new BreederRenderState();
    }

    public void extractRenderState(BreederTileentity breeder, BreederRenderState state, float partialTicks, Vec3 pos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState((BlockEntity)breeder, (BlockEntityRenderState)state, partialTicks, pos, crumblingOverlay);
        state.direction = Direction.SOUTH;
        if (!breeder.isFakeWorld()) {
            state.direction = (Direction)breeder.getBlockState().getValue((Property)TraderBlock.FACING);
        }
        VillagerRenderer villagerRenderer = this.getVillagerRenderer();
        if (breeder.getVillagerEntity1() != null) {
            state.renderVillager1 = true;
            villagerRenderer.extractRenderState((Villager)breeder.getVillagerEntity1(), state.villagerRenderState1, 0.0f);
            state.villagerRenderState1.lightCoords = BreederRenderer.getLightOrDefault(breeder, state);
        } else {
            state.renderVillager1 = false;
        }
        if (breeder.getVillagerEntity2() != null) {
            state.renderVillager2 = true;
            villagerRenderer.extractRenderState((Villager)breeder.getVillagerEntity2(), state.villagerRenderState2, 0.0f);
            state.villagerRenderState2.lightCoords = BreederRenderer.getLightOrDefault(breeder, state);
        } else {
            state.renderVillager2 = false;
        }
        state.bedRenderStateBottom.lightCoords = BreederRenderer.getLightOrDefault(breeder, state);
        state.bedRenderStateTop.lightCoords = BreederRenderer.getLightOrDefault(breeder, state);
    }

    public void submit(BreederRenderState state, PoseStack stack, SubmitNodeCollector collector, CameraRenderState cameraRenderState) {
        stack.pushPose();
        BedRenderer bedRenderer = (BedRenderer)this.bedRendererCache.get();
        if (bedRenderer == null) {
            bedRenderer = new BedRenderer(this.materialSet, this.entityModelSet);
            this.bedRendererCache = new WeakReference<BedRenderer>(bedRenderer);
        }
        VillagerRenderer villagerRenderer = this.getVillagerRenderer();
        if (state.renderVillager1) {
            stack.pushPose();
            stack.translate(0.5, 0.0625, 0.5);
            stack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-state.direction.toYRot()));
            stack.translate(-0.3125, 0.0, 0.0);
            stack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
            stack.scale(0.45f, 0.45f, 0.45f);
            villagerRenderer.submit((LivingEntityRenderState)state.villagerRenderState1, stack, collector, cameraRenderState);
            stack.popPose();
        }
        if (state.renderVillager2) {
            stack.pushPose();
            stack.translate(0.5, 0.0625, 0.5);
            stack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-state.direction.toYRot()));
            stack.translate(0.3125, 0.0, 0.0);
            stack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-90.0f));
            stack.scale(0.45f, 0.45f, 0.45f);
            villagerRenderer.submit((LivingEntityRenderState)state.villagerRenderState2, stack, collector, cameraRenderState);
            stack.popPose();
        }
        stack.pushPose();
        stack.translate(0.5, 0.0625, 0.5);
        stack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-state.direction.toYRot()));
        stack.translate(0.0, 0.0, 0.1875);
        stack.translate(-0.5, 0.0, -0.5);
        stack.scale(0.4f, 0.4f, 0.4f);
        stack.translate(0.75, 0.0, 0.75);
        bedRenderer.submit(state.bedRenderStateBottom, stack, collector, cameraRenderState);
        stack.translate(0.0, 0.0, -1.0);
        bedRenderer.submit(state.bedRenderStateTop, stack, collector, cameraRenderState);
        stack.popPose();
        stack.popPose();
    }
}

