/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.blocks.tileentity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.maxhenkel.easyvillagers.blocks.tileentity.ConverterTileentity;
import de.maxhenkel.easyvillagers.blocks.tileentity.render.ConverterRenderState;
import de.maxhenkel.easyvillagers.blocks.tileentity.render.VillagerRendererBase;
import de.maxhenkel.easyvillagers.entity.EasyVillagerEntity;
import java.lang.ref.WeakReference;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.entity.VillagerRenderer;
import net.minecraft.client.renderer.entity.ZombieRenderer;
import net.minecraft.client.renderer.entity.ZombieVillagerRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.zombie.Zombie;
import net.minecraft.world.entity.monster.zombie.ZombieVillager;
import net.minecraft.world.entity.npc.villager.Villager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class ConverterRenderer
extends VillagerRendererBase<ConverterTileentity, ConverterRenderState> {
    private WeakReference<Zombie> zombieCache = new WeakReference<Object>(null);
    private WeakReference<ZombieRenderer> zombieRendererCache = new WeakReference<Object>(null);
    private WeakReference<ZombieVillagerRenderer> zombieVillagerRendererCache = new WeakReference<Object>(null);
    private WeakReference<ZombieVillager> zombieVillagerCache = new WeakReference<Object>(null);

    public ConverterRenderer(EntityModelSet entityModelSet) {
        super(entityModelSet);
    }

    public ConverterRenderState createRenderState() {
        return new ConverterRenderState();
    }

    public void extractRenderState(ConverterTileentity converter, ConverterRenderState state, float partialTicks, Vec3 pos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState((BlockEntity)converter, (BlockEntityRenderState)state, partialTicks, pos, crumblingOverlay);
        state.apply(converter);
        state.renderVillager = false;
        state.renderZombieVillager = false;
        EasyVillagerEntity villagerEntity = converter.getVillagerEntity();
        if (villagerEntity != null) {
            if (converter.getTimer() >= (long)ConverterTileentity.getZombifyTime() && converter.getTimer() < (long)ConverterTileentity.getConvertTime()) {
                state.renderZombieVillager = true;
                state.zombieVillagerRenderState.villagerData = villagerEntity.getVillagerData();
                state.zombieVillagerRenderState.isBaby = villagerEntity.isBaby();
                state.zombieVillagerRenderState.lightCoords = ConverterRenderer.getLightOrDefault(converter, state);
            } else {
                state.renderVillager = true;
                VillagerRenderer villagerRenderer = this.getVillagerRenderer();
                villagerRenderer.extractRenderState((Villager)villagerEntity, state.villagerRenderState, partialTicks);
                state.villagerRenderState.lightCoords = ConverterRenderer.getLightOrDefault(converter, state);
            }
        }
        state.zombieRenderState.lightCoords = ConverterRenderer.getLightOrDefault(converter, state);
    }

    public void submit(ConverterRenderState state, PoseStack stack, SubmitNodeCollector collector, CameraRenderState cameraRenderState) {
        ZombieVillager zombieVillager;
        ZombieVillagerRenderer zombieVillagerRenderer;
        Zombie zombie;
        stack.pushPose();
        ZombieRenderer zombieRenderer = (ZombieRenderer)this.zombieRendererCache.get();
        if (zombieRenderer == null) {
            zombieRenderer = new ZombieRenderer(ConverterRenderer.createEntityRenderer());
            this.zombieRendererCache = new WeakReference<ZombieRenderer>(zombieRenderer);
        }
        if ((zombie = (Zombie)this.zombieCache.get()) == null) {
            zombie = new Zombie((Level)ConverterRenderer.minecraft.level);
            this.zombieCache = new WeakReference<Zombie>(zombie);
        }
        if ((zombieVillagerRenderer = (ZombieVillagerRenderer)this.zombieVillagerRendererCache.get()) == null) {
            zombieVillagerRenderer = new ZombieVillagerRenderer(ConverterRenderer.createEntityRenderer());
            this.zombieVillagerRendererCache = new WeakReference<ZombieVillagerRenderer>(zombieVillagerRenderer);
        }
        if ((zombieVillager = (ZombieVillager)this.zombieVillagerCache.get()) == null) {
            zombieVillager = new ZombieVillager(EntityType.ZOMBIE_VILLAGER, (Level)ConverterRenderer.minecraft.level);
            this.zombieVillagerCache = new WeakReference<ZombieVillager>(zombieVillager);
        }
        if (state.renderZombieVillager || state.renderVillager) {
            stack.pushPose();
            stack.translate(0.5, 0.0625, 0.5);
            stack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-state.direction.toYRot()));
            stack.translate(-0.3125, 0.0, 0.0);
            stack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
            stack.scale(0.4f, 0.4f, 0.4f);
            if (state.renderZombieVillager) {
                zombieVillagerRenderer.submit((LivingEntityRenderState)state.zombieVillagerRenderState, stack, collector, cameraRenderState);
            } else {
                VillagerRenderer villagerRenderer = this.getVillagerRenderer();
                villagerRenderer.submit((LivingEntityRenderState)state.villagerRenderState, stack, collector, cameraRenderState);
            }
            stack.popPose();
        }
        stack.pushPose();
        stack.translate(0.5, 0.0625, 0.5);
        stack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-state.direction.toYRot()));
        stack.translate(0.3125, 0.0, 0.0);
        stack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-90.0f));
        stack.scale(0.4f, 0.4f, 0.4f);
        zombieRenderer.submit((LivingEntityRenderState)state.zombieRenderState, stack, collector, cameraRenderState);
        stack.popPose();
        stack.popPose();
    }
}

