/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.net;

import de.maxhenkel.easyvillagers.blocks.tileentity.BreederTileentity;
import de.maxhenkel.easyvillagers.corelib.net.Message;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class MessageVillagerParticles
implements Message<MessageVillagerParticles> {
    public static final CustomPacketPayload.Type<MessageVillagerParticles> TYPE = new CustomPacketPayload.Type(Identifier.fromNamespaceAndPath((String)"easy_villagers", (String)"villager_particles"));
    private BlockPos pos;

    public MessageVillagerParticles(BlockPos pos) {
        this.pos = pos;
    }

    public MessageVillagerParticles() {
    }

    @Override
    public PacketFlow getExecutingSide() {
        return PacketFlow.CLIENTBOUND;
    }

    @Override
    public void executeClientSide(IPayloadContext context) {
        this.spawnParticles();
    }

    private void spawnParticles() {
        BlockEntity blockEntity;
        Minecraft mc = Minecraft.getInstance();
        if (mc.level != null && (blockEntity = mc.level.getBlockEntity(this.pos)) instanceof BreederTileentity) {
            BreederTileentity breeder = (BreederTileentity)blockEntity;
            breeder.spawnParticles();
        }
    }

    @Override
    public MessageVillagerParticles fromBytes(RegistryFriendlyByteBuf packetBuffer) {
        this.pos = packetBuffer.readBlockPos();
        return this;
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf packetBuffer) {
        packetBuffer.writeBlockPos(this.pos);
    }

    @Override
    public CustomPacketPayload.Type<MessageVillagerParticles> type() {
        return TYPE;
    }
}

