/*
 * Decompiled with CFR 0.152.
 */
package baguchi.bagus_lib.client.render.book.component;

import baguchi.bagus_lib.client.render.book.BookAccess;
import baguchi.bagus_lib.client.render.book.component.BookComponent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.StreamSupport;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.Identifier;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class DisplayBookComponent
extends BookComponent {
    private final List<TextDisplay> textDisplays = new ArrayList<TextDisplay>();
    private final List<EntityDisplay> entityDisplays = new ArrayList<EntityDisplay>();
    private final Map<EntityDisplay, LivingEntity> entities = new HashMap<EntityDisplay, LivingEntity>();
    private final List<ItemDisplay> itemDisplays = new ArrayList<ItemDisplay>();
    private final List<ItemTagDisplay> itemTagDisplays = new ArrayList<ItemTagDisplay>();
    private final List<ImageDisplay> imageDisplays = new ArrayList<ImageDisplay>();
    private int tickCount;

    public DisplayBookComponent(int width, int height) {
        super(width, height);
    }

    @Override
    public int getPageCount(int pagesBefore, Font font) {
        return 1;
    }

    @Override
    public void render(BookAccess access, GuiGraphics graphics, Font font, int x, int y, int mouseX, int mouseY) {
        for (ImageDisplay imageDisplay : this.imageDisplays) {
            graphics.blit(RenderPipelines.GUI_TEXTURED, imageDisplay.location(), x + imageDisplay.x(), y + imageDisplay.y(), 0.0f, 0.0f, imageDisplay.width(), imageDisplay.height(), imageDisplay.width(), imageDisplay.height());
        }
        for (EntityDisplay entityDisplay : this.entityDisplays) {
            LivingEntity livingEntity;
            if (!this.entities.containsKey(entityDisplay) && Minecraft.getInstance().level != null && (livingEntity = (LivingEntity)entityDisplay.type().create((Level)Minecraft.getInstance().level, EntitySpawnReason.EVENT)) != null) {
                livingEntity.yBodyRot = entityDisplay.yRot();
                livingEntity.setXRot(entityDisplay.xRot());
                livingEntity.setYRot(entityDisplay.yRot());
                livingEntity.yHeadRot = livingEntity.getYRot();
                livingEntity.yHeadRotO = livingEntity.getYRot();
                this.entities.put(entityDisplay, livingEntity);
            }
            if (!this.entities.containsKey(entityDisplay)) continue;
            EntityRenderState entityrenderstate = DisplayBookComponent.extractRenderState(this.entities.get(entityDisplay));
            Vector3f vector3f = new Vector3f(0.0f, entityrenderstate.boundingBoxHeight / 2.0f, 0.0f);
            graphics.submitEntityRenderState(entityrenderstate, entityDisplay.scale(), vector3f, entityDisplay.rotation, new Quaternionf(), x + entityDisplay.x(), y + entityDisplay.y(), x + entityDisplay.xMax, y + entityDisplay.yMax);
        }
        for (ItemDisplay itemDisplay : this.itemDisplays) {
            graphics.renderItem(itemDisplay.stack(), x + itemDisplay.x(), y + itemDisplay.y());
        }
        for (ItemTagDisplay itemTagDisplay : this.itemTagDisplays) {
            List<Item> items = StreamSupport.stream(BuiltInRegistries.ITEM.getTagOrEmpty(itemTagDisplay.tag()).spliterator(), false).map(Holder::value).toList();
            if (items.isEmpty()) continue;
            graphics.renderItem(items.get(this.tickCount / 20 % items.size()).getDefaultInstance(), x + itemTagDisplay.x(), y + itemTagDisplay.y());
        }
        for (TextDisplay textDisplay : this.textDisplays) {
            graphics.pose().pushMatrix();
            graphics.pose().translate((float)(x + textDisplay.x()), (float)(y + textDisplay.y()));
            graphics.pose().scale(textDisplay.scale(), textDisplay.scale());
            Component component = textDisplay.text();
            int n = -font.width((FormattedText)textDisplay.text()) / 2;
            Objects.requireNonNull(font);
            graphics.drawString(font, component, n, -9, -16777216, false);
            graphics.pose().popMatrix();
        }
    }

    private static EntityRenderState extractRenderState(LivingEntity p_461127_) {
        EntityRenderDispatcher entityrenderdispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        EntityRenderer entityrenderer = entityrenderdispatcher.getRenderer((Entity)p_461127_);
        EntityRenderState entityrenderstate = entityrenderer.createRenderState((Entity)p_461127_, 1.0f);
        entityrenderstate.lightCoords = 0xF000F0;
        entityrenderstate.shadowPieces.clear();
        entityrenderstate.outlineColor = 0;
        return entityrenderstate;
    }

    @Override
    public void tick(BookAccess access, Font font, int x, int y, int mouseX, int mouseY) {
        ++this.tickCount;
    }

    @Override
    public void onClick(BookAccess access, Font font, int x, int y, int mouseX, int mouseY) {
    }

    public DisplayBookComponent textDisplay(Component text, int x, int y, float scale) {
        this.textDisplays.add(new TextDisplay(text, x, y, scale));
        return this;
    }

    public DisplayBookComponent entityDisplay(EntityType<? extends LivingEntity> type, int x, int y, int xMax, int yMax, float xRot, float yRot, float scale, Quaternionf rotation) {
        this.entityDisplays.add(new EntityDisplay(type, x, y, xMax, yMax, xRot, yRot, scale, rotation));
        return this;
    }

    public DisplayBookComponent itemDisplay(ItemStack stack, int x, int y) {
        this.itemDisplays.add(new ItemDisplay(stack, x, y));
        return this;
    }

    public DisplayBookComponent itemTagDisplay(TagKey<Item> tag, int x, int y) {
        this.itemTagDisplays.add(new ItemTagDisplay(tag, x, y));
        return this;
    }

    public DisplayBookComponent imageDisplay(Identifier location, int x, int y, int width, int height) {
        this.imageDisplays.add(new ImageDisplay(location, x, y, width, height));
        return this;
    }

    private record ImageDisplay(Identifier location, int x, int y, int width, int height) {
    }

    private record EntityDisplay(EntityType<? extends LivingEntity> type, int x, int y, int xMax, int yMax, float xRot, float yRot, float scale, Quaternionf rotation) {
    }

    private record ItemDisplay(ItemStack stack, int x, int y) {
    }

    private record ItemTagDisplay(TagKey<Item> tag, int x, int y) {
    }

    private record TextDisplay(Component text, int x, int y, float scale) {
    }
}

