/*
 * Decompiled with CFR 0.152.
 */
package baguchi.bagus_lib.util;

import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class CollideUtil {
    public static Vec3 getPrevPositionVec(Entity collideEntity) {
        return new Vec3(collideEntity.xOld, collideEntity.yOld, collideEntity.zOld);
    }

    public static void collideEntities(Entity collideEntity) {
        Level world = collideEntity.level();
        AABB bounds = collideEntity.getBoundingBox();
        if (bounds == null) {
            return;
        }
        Vec3 position = collideEntity.position();
        Vec3 motion = position.subtract(CollideUtil.getPrevPositionVec(collideEntity));
        List entitiesWithinAABB = world.getEntitiesOfClass(Entity.class, bounds.inflate(2.0));
        for (Entity entity : entitiesWithinAABB) {
            if (entity == collideEntity || collideEntity.isPassenger() || entity.canBeCollidedWith(collideEntity)) continue;
            Vec3 entityPosition = entity.position();
            Vec3 entityMotion2 = entity.getDeltaMovement();
            Vec3 vec3 = entity.collide(motion);
            if (!bounds.expandTowards(0.0, (double)0.01f, 0.0).expandTowards(0.0, motion.y * (double)1.15f, 0.0).intersects(entity.getBoundingBox().expandTowards(0.0, (double)-0.01f, 0.0))) continue;
            entity.setPos(entityPosition.x + vec3.x, entityPosition.y + vec3.y, entityPosition.z + vec3.z);
            entity.setOnGround(true);
        }
    }
}

