/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.net;

import de.maxhenkel.voicechat.config.ServerConfig;
import de.maxhenkel.voicechat.net.Packet;
import de.maxhenkel.voicechat.plugins.PluginManager;
import de.maxhenkel.voicechat.voice.common.Secret;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;
import net.minecraft.server.level.ServerPlayer;

public class SecretPacket
implements Packet<SecretPacket> {
    public static final CustomPacketPayload.Type<SecretPacket> SECRET = new CustomPacketPayload.Type(Identifier.fromNamespaceAndPath((String)"voicechat", (String)"secret"));
    private Secret secret;
    private int serverPort;
    private UUID playerUUID;
    private ServerConfig.Codec codec;
    private int mtuSize;
    private double voiceChatDistance;
    private int keepAlive;
    private boolean groupsEnabled;
    private String voiceHost;
    private boolean allowRecording;

    public SecretPacket() {
    }

    public SecretPacket(ServerPlayer player, Secret secret, int port, ServerConfig serverConfig) {
        this.secret = secret;
        this.serverPort = port;
        this.playerUUID = player.getUUID();
        this.codec = serverConfig.voiceChatCodec.get();
        this.mtuSize = serverConfig.voiceChatMtuSize.get();
        this.voiceChatDistance = serverConfig.voiceChatDistance.get();
        this.keepAlive = serverConfig.keepAlive.get();
        this.groupsEnabled = serverConfig.groupsEnabled.get();
        this.voiceHost = PluginManager.instance().getVoiceHost(serverConfig.voiceHost.get());
        this.allowRecording = serverConfig.allowRecording.get();
    }

    public Secret getSecret() {
        return this.secret;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public ServerConfig.Codec getCodec() {
        return this.codec;
    }

    public int getMtuSize() {
        return this.mtuSize;
    }

    public double getVoiceChatDistance() {
        return this.voiceChatDistance;
    }

    public int getKeepAlive() {
        return this.keepAlive;
    }

    public boolean groupsEnabled() {
        return this.groupsEnabled;
    }

    public String getVoiceHost() {
        return this.voiceHost;
    }

    public boolean allowRecording() {
        return this.allowRecording;
    }

    @Override
    public SecretPacket fromBytes(FriendlyByteBuf buf) {
        this.secret = Secret.fromBytes((ByteBuf)buf);
        this.serverPort = buf.readInt();
        this.playerUUID = buf.readUUID();
        this.codec = ServerConfig.Codec.values()[buf.readByte()];
        this.mtuSize = buf.readInt();
        this.voiceChatDistance = buf.readDouble();
        this.keepAlive = buf.readInt();
        this.groupsEnabled = buf.readBoolean();
        this.voiceHost = buf.readUtf(Short.MAX_VALUE);
        this.allowRecording = buf.readBoolean();
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        this.secret.toBytes((ByteBuf)buf);
        buf.writeInt(this.serverPort);
        buf.writeUUID(this.playerUUID);
        buf.writeByte(this.codec.ordinal());
        buf.writeInt(this.mtuSize);
        buf.writeDouble(this.voiceChatDistance);
        buf.writeInt(this.keepAlive);
        buf.writeBoolean(this.groupsEnabled);
        buf.writeUtf(this.voiceHost);
        buf.writeBoolean(this.allowRecording);
    }

    @Override
    public CustomPacketPayload.Type<SecretPacket> type() {
        return SECRET;
    }
}

