/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.requirement;

import java.util.List;
import net.blay09.mods.waystones.api.WaystoneTeleportContext;
import net.blay09.mods.waystones.api.requirement.WarpRequirement;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class DurabilityRequirement
implements WarpRequirement {
    private int damage;

    public DurabilityRequirement(int damage) {
        this.damage = Math.max(0, damage);
    }

    @Override
    public boolean canAfford(Player player) {
        return true;
    }

    @Override
    public void consume(WaystoneTeleportContext context, Player player) {
        ItemStack itemStack = context.getWarpItem();
        if (!itemStack.isEmpty()) {
            itemStack.hurtAndBreak(this.damage, (LivingEntity)player, context.getWarpHand());
        }
    }

    @Override
    public void rollback(WaystoneTeleportContext context, Player player) {
        ItemStack itemStack = context.getWarpItem();
        if (itemStack.isEmpty()) {
            itemStack.setDamageValue(itemStack.getDamageValue() - this.damage);
        }
    }

    @Override
    public void appendHoverText(Player player, List<Component> tooltip) {
        if (this.damage > 0) {
            tooltip.add((Component)Component.translatable((String)"gui.waystones.waystone_selection.durability_requirement", (Object[])new Object[]{this.damage}).withStyle(ChatFormatting.LIGHT_PURPLE));
        }
    }

    @Override
    public boolean isEmpty() {
        return this.damage <= 0;
    }

    public void setDamage(int value) {
        this.damage = value;
    }

    public int getDamage() {
        return this.damage;
    }
}

