/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.littlejoys.handler;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;

public class ChunkLimitManager
extends SavedData {
    private static final String DATA_NAME = "littlejoys";
    private static final Codec<ChunkLimitManager> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.strictUnboundedMap((Codec)Codec.STRING.xmap(Long::parseLong, String::valueOf), (Codec)Codec.INT).fieldOf("FishingSpotChunks").forGetter(ChunkLimitManager::getFishingSpotCounts), (App)ExtraCodecs.strictUnboundedMap((Codec)Codec.STRING.xmap(Long::parseLong, String::valueOf), (Codec)Codec.INT).fieldOf("DigSpotChunks").forGetter(ChunkLimitManager::getDigSpotCounts)).apply((Applicative)instance, ChunkLimitManager::new));
    private static final SavedDataType<ChunkLimitManager> TYPE = new SavedDataType("littlejoys", () -> new ChunkLimitManager(Map.of(), Map.of()), CODEC, null);
    private final Map<Long, Integer> fishingSpotCounts = new HashMap<Long, Integer>();
    private final Map<Long, Integer> digSpotCounts = new HashMap<Long, Integer>();

    public ChunkLimitManager(Map<Long, Integer> fishingSpotCounts, Map<Long, Integer> digSpotCounts) {
        this.fishingSpotCounts.putAll(fishingSpotCounts);
        this.digSpotCounts.putAll(digSpotCounts);
    }

    public static ChunkLimitManager get(ServerLevel level) {
        return (ChunkLimitManager)level.getDataStorage().computeIfAbsent(TYPE);
    }

    private Map<Long, Integer> getFishingSpotCounts() {
        return this.fishingSpotCounts;
    }

    private Map<Long, Integer> getDigSpotCounts() {
        return this.digSpotCounts;
    }

    public int getTotalFishingSpotsInChunk(BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        long chunkKey = chunkPos.toLong();
        return this.fishingSpotCounts.getOrDefault(chunkKey, 0);
    }

    public int getTotalDigSpotsInChunk(BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        long chunkKey = chunkPos.toLong();
        return this.digSpotCounts.getOrDefault(chunkKey, 0);
    }

    public void trackFishingSpot(BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        long chunkKey = chunkPos.toLong();
        Integer currentCount = this.fishingSpotCounts.getOrDefault(chunkKey, 0);
        this.fishingSpotCounts.put(chunkKey, currentCount + 1);
        this.setDirty();
    }

    public void trackDigSpot(BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        long chunkKey = chunkPos.toLong();
        Integer currentCount = this.digSpotCounts.getOrDefault(chunkKey, 0);
        this.digSpotCounts.put(chunkKey, currentCount + 1);
        this.setDirty();
    }
}

