/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import java.util.EnumMap;
import java.util.Map;
import net.geforcemods.securitycraft.api.ICustomizable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.NamedBlockEntity;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public abstract class CustomizableBlockEntity
extends NamedBlockEntity
implements IModuleInventory,
ICustomizable {
    private final NonNullList<ItemStack> modules = NonNullList.withSize((int)this.getMaxNumberOfModules(), (Object)ItemStack.EMPTY);
    private Map<ModuleType, Boolean> moduleStates = new EnumMap<ModuleType, Boolean>(ModuleType.class);

    protected CustomizableBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected CustomizableBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    @Override
    public void loadAdditional(ValueInput tag) {
        super.loadAdditional(tag);
        this.readModuleInventory(this.modules, tag);
        this.moduleStates = this.readModuleStates(tag);
        this.readOptions(tag);
    }

    @Override
    public void saveAdditional(ValueOutput tag) {
        super.saveAdditional(tag);
        this.writeModuleInventory(tag);
        this.writeModuleStates(tag);
        this.writeOptions(tag);
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.modules;
    }

    @Override
    public boolean isModuleEnabled(ModuleType module) {
        return this.hasModule(module) && this.moduleStates.get((Object)module) == Boolean.TRUE;
    }

    @Override
    public void toggleModuleState(ModuleType module, boolean shouldBeEnabled) {
        this.moduleStates.put(module, shouldBeEnabled);
    }

    @Override
    public Level myLevel() {
        return this.level;
    }

    @Override
    public BlockPos myPos() {
        return this.worldPosition;
    }
}

