/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blocks.FrameBlock;
import net.geforcemods.securitycraft.components.NamedPositions;
import net.geforcemods.securitycraft.entity.camera.FrameFeedHandler;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.server.SyncFrame;
import net.geforcemods.securitycraft.util.ITickingBlockEntity;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;

public class FrameBlockEntity
extends CustomizableBlockEntity
implements ITickingBlockEntity {
    private final Option.DisabledOption disabled = new Option.DisabledOption(false);
    private final Option.IntOption chunkLoadingDistance = new Option.IntOption("chunkLoadingDistance", 16, 2, 32, 1);
    private List<NamedPositions.Entry> cameraPositions = new ArrayList<NamedPositions.Entry>();
    private GlobalPos currentCameraPosition;
    private GlobalPos newCameraPosition;
    private boolean activatedByRedstone = false;
    private boolean clientInteracted;
    private boolean switchCamera;

    public FrameBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.FRAME_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        if (this.activatedByRedstone) {
            boolean wasPowered = (Boolean)state.getValue((Property)FrameBlock.POWERED);
            if (level.isClientSide() && !wasPowered && this.clientInteracted) {
                this.switchCameraOnClient(this.currentCameraPosition, true);
            } else if (!level.isClientSide()) {
                boolean hasNeighborSignal = level.hasNeighborSignal(pos);
                if (wasPowered && !hasNeighborSignal) {
                    this.disableCameraFeedOnServer(this.currentCameraPosition);
                }
                if (wasPowered != hasNeighborSignal) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)FrameBlock.POWERED, (Comparable)Boolean.valueOf(hasNeighborSignal)));
                }
            }
        }
        if (this.switchCamera) {
            this.switchCamera = false;
            if (!level.isClientSide()) {
                this.disableCameraFeedOnServer(this.newCameraPosition);
            } else {
                this.switchCameraOnClient(this.newCameraPosition, true);
            }
        }
    }

    public void setRemoved() {
        super.setRemoved();
        if (this.currentCameraPosition != null) {
            if (!this.level.isClientSide()) {
                if (this.level.isLoaded(this.worldPosition)) {
                    this.disableCameraFeedOnServer(this.currentCameraPosition);
                }
            } else if (this.clientInteracted) {
                this.switchCameraOnClient(this.currentCameraPosition, true);
                ClientPacketDistributor.sendToServer((CustomPacketPayload)new SyncFrame(this.getBlockPos(), FrameFeedHandler.getFrameFeedViewDistance(this), Optional.empty(), Optional.ofNullable(this.currentCameraPosition), true), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @Override
    public void loadAdditional(ValueInput tag) {
        super.loadAdditional(tag);
        ValueInput.TypedInputList cameras = tag.listOrEmpty("cameras", NamedPositions.Entry.CODEC.orElse((Object)NamedPositions.Entry.EMPTY));
        this.cameraPositions.clear();
        cameras.forEach(entry -> {
            if (entry.equals(NamedPositions.Entry.EMPTY)) {
                this.cameraPositions.add(null);
            } else {
                this.cameraPositions.add((NamedPositions.Entry)entry);
            }
        });
        GlobalPos newCameraPos = tag.read("current_camera", GlobalPos.CODEC).orElse(null);
        if (this.currentCameraPosition == null && newCameraPos != null || this.currentCameraPosition != null && !this.currentCameraPosition.equals((Object)newCameraPos)) {
            this.switchCamera = true;
            this.newCameraPosition = newCameraPos;
        }
        this.activatedByRedstone = this.isModuleEnabled(ModuleType.REDSTONE);
    }

    @Override
    public void saveAdditional(ValueOutput tag) {
        super.saveAdditional(tag);
        ValueOutput.TypedOutputList cameras = tag.list("cameras", NamedPositions.Entry.CODEC.orElse((Object)NamedPositions.Entry.EMPTY));
        this.cameraPositions.forEach(entry -> {
            if (entry == null) {
                cameras.add((Object)NamedPositions.Entry.EMPTY);
            } else {
                cameras.add(entry);
            }
        });
        if (this.currentCameraPosition != null) {
            tag.store("current_camera", GlobalPos.CODEC, (Object)this.currentCameraPosition);
        }
    }

    public boolean applyCameraPositions(ItemStack cameraMonitor) {
        List<NamedPositions.Entry> newCameraPositions;
        if (cameraMonitor.has(SCContent.BOUND_CAMERAS) && !this.cameraPositions.equals(newCameraPositions = ((NamedPositions)cameraMonitor.get(SCContent.BOUND_CAMERAS)).positions())) {
            this.cameraPositions = new ArrayList<NamedPositions.Entry>(newCameraPositions);
            this.setChanged();
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
            return true;
        }
        return false;
    }

    public List<NamedPositions.Entry> getCameraPositions() {
        return this.cameraPositions;
    }

    public void removeCameraOnClient(GlobalPos cameraPos) {
        this.removeCamera(cameraPos);
        if (cameraPos == this.currentCameraPosition) {
            FrameFeedHandler.removeFrameLink(this.currentCameraPosition, this);
            this.currentCameraPosition = null;
        }
        ClientPacketDistributor.sendToServer((CustomPacketPayload)new SyncFrame(this.getBlockPos(), FrameFeedHandler.getFrameFeedViewDistance(this), Optional.of(cameraPos), Optional.ofNullable(this.currentCameraPosition), false), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void removeCamera(GlobalPos cameraPos) {
        for (int i = 0; i < this.cameraPositions.size(); ++i) {
            NamedPositions.Entry entry = this.cameraPositions.get(i);
            if (entry == null || !entry.globalPos().equals((Object)cameraPos)) continue;
            this.cameraPositions.set(i, null);
            break;
        }
        if (this.cameraPositions.stream().allMatch(Objects::isNull)) {
            this.cameraPositions = new ArrayList<NamedPositions.Entry>();
        }
        this.setChanged();
        this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
    }

    public void setCameraOnClientAndUpdate(GlobalPos camera) {
        this.switchCameraOnClient(camera, false);
        ClientPacketDistributor.sendToServer((CustomPacketPayload)new SyncFrame(this.getBlockPos(), FrameFeedHandler.getFrameFeedViewDistance(this), Optional.empty(), Optional.ofNullable(this.currentCameraPosition), false), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void disableCameraFeedOnServer(GlobalPos newCameraPos) {
        this.switchCameraOnServer(newCameraPos, null, 0, true);
    }

    public void unsetCurrentCameraOnServer() {
        this.switchCameraOnServer(null, null, 0, false);
    }

    public void switchCameraOnServer(GlobalPos newCameraPos, Player player, int requestedRenderDistance, boolean disableNewCamera) {
        if (!this.level.isClientSide()) {
            BlockEntity blockEntity;
            GlobalPos previousCameraPos = this.getCurrentCamera();
            this.setCurrentCamera(newCameraPos);
            if (previousCameraPos != null && (blockEntity = this.level.getBlockEntity(previousCameraPos.pos())) instanceof SecurityCameraBlockEntity) {
                SecurityCameraBlockEntity previousCamera = (SecurityCameraBlockEntity)blockEntity;
                if (!previousCameraPos.equals((Object)newCameraPos) || player == null && disableNewCamera) {
                    previousCamera.unlinkFrameForAllPlayers(this.worldPosition);
                } else if (disableNewCamera) {
                    previousCamera.unlinkFrameForPlayer(player.getUUID(), this.worldPosition);
                }
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (!disableNewCamera && newCameraPos != null) {
                    BlockEntity blockEntity2;
                    if (this.level.dimension() != newCameraPos.dimension() || !((blockEntity2 = this.level.getBlockEntity(newCameraPos.pos())) instanceof SecurityCameraBlockEntity)) {
                        PlayerUtils.sendMessageToPlayer(player, Utils.localize(((FrameBlock)((Object)SCContent.FRAME.get())).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:cameraMonitor.cameraNotAvailable", newCameraPos.pos()), ChatFormatting.RED);
                    } else {
                        SecurityCameraBlockEntity newCamera = (SecurityCameraBlockEntity)blockEntity2;
                        if (!newCameraPos.equals((Object)previousCameraPos) || !newCamera.isFrameLinked(player, this.worldPosition)) {
                            if (this.redstoneSignalDisabled()) {
                                PlayerUtils.sendMessageToPlayer(player, Utils.localize(((FrameBlock)((Object)SCContent.FRAME.get())).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:frame.noRedstoneSignal", newCameraPos.pos()), ChatFormatting.RED);
                            } else {
                                newCamera.linkFrameForPlayer(serverPlayer, this.worldPosition, Mth.clamp((int)requestedRenderDistance, (int)2, (int)Math.min(this.getChunkLoadingDistanceOption(), Math.min((Integer)ConfigHandler.SERVER.frameFeedViewDistance.get(), serverPlayer.level().getServer().getPlayerList().getViewDistance()))));
                            }
                        }
                    }
                }
            }
            this.setChanged();
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public void switchCameraOnClient(GlobalPos newCameraPos, boolean disableNewCamera) {
        if (this.level.isClientSide()) {
            GlobalPos previousCameraPos = this.getCurrentCamera();
            this.setCurrentCamera(newCameraPos);
            if (previousCameraPos != null) {
                FrameFeedHandler.removeFrameLink(previousCameraPos, this);
            }
            if (newCameraPos != null && !disableNewCamera) {
                FrameFeedHandler.addFrameLink(this, newCameraPos);
                this.clientInteracted = true;
            } else if (disableNewCamera) {
                this.clientInteracted = false;
            }
        }
    }

    public boolean hasClientInteracted() {
        return this.clientInteracted;
    }

    public void setCurrentCamera(GlobalPos camera) {
        this.currentCameraPosition = camera;
        this.setChanged();
    }

    public GlobalPos getCurrentCamera() {
        return this.currentCameraPosition;
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }

    public int getChunkLoadingDistanceOption() {
        return (Integer)this.chunkLoadingDistance.get();
    }

    public boolean redstoneSignalDisabled() {
        return this.activatedByRedstone && (Boolean)this.getBlockState().getValue((Property)FrameBlock.POWERED) == false;
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.disabled, this.chunkLoadingDistance};
    }

    @Override
    public <T> void onOptionChanged(Option<T> option) {
        if (!this.level.isClientSide() && (option.getName().equals(this.disabled.getName()) && ((Boolean)this.disabled.get()).booleanValue() || option.getName().equals(this.chunkLoadingDistance.getName()))) {
            this.unsetCurrentCameraOnServer();
        }
    }

    @Override
    public void onModuleInserted(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleInserted(stack, module, toggled);
        if (module == ModuleType.REDSTONE) {
            this.activatedByRedstone = true;
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)FrameBlock.POWERED, (Comparable)Boolean.valueOf(true)));
            this.setChanged();
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleRemoved(stack, module, toggled);
        if (module == ModuleType.ALLOWLIST && !this.level.isClientSide()) {
            this.unsetCurrentCameraOnServer();
        } else if (module == ModuleType.REDSTONE) {
            this.activatedByRedstone = false;
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)FrameBlock.POWERED, (Comparable)Boolean.valueOf(false)));
            this.setChanged();
        }
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.REDSTONE};
    }
}

