/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.EnumMap;
import java.util.Map;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.inventory.InsertOnlyResourceHandler;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.IPistonMoveListener;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ShelfBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.item.VanillaContainerWrapper;

public class ReinforcedShelfBlockEntity
extends ShelfBlockEntity
implements IOwnable,
IModuleInventory,
IPistonMoveListener {
    private Owner owner = new Owner();
    private NonNullList<ItemStack> modules = NonNullList.withSize((int)this.getMaxNumberOfModules(), (Object)ItemStack.EMPTY);
    private Map<ModuleType, Boolean> moduleStates = new EnumMap<ModuleType, Boolean>(ModuleType.class);

    public ReinforcedShelfBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    public static ResourceHandler<ItemResource> getCapability(ReinforcedShelfBlockEntity be, Direction side) {
        ResourceHandler resourceHandler = VanillaContainerWrapper.of((Container)be);
        return BlockUtils.isAllowedToExtractFromProtectedObject(side, be) ? resourceHandler : new InsertOnlyResourceHandler(resourceHandler);
    }

    public void loadAdditional(ValueInput tag) {
        super.loadAdditional(tag);
        this.owner.load(tag);
        this.readModuleInventory(this.modules, tag);
        this.moduleStates = this.readModuleStates(tag);
    }

    public void saveAdditional(ValueOutput tag) {
        super.saveAdditional(tag);
        if (this.owner != null) {
            this.owner.save(tag, this.needsValidation());
        }
        this.writeModuleInventory(tag);
        this.writeModuleStates(tag);
    }

    @Override
    public void prePistonPushSideEffects(BlockPos pos) {
        this.clearContent();
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider lookupProvider) {
        return this.saveCustomOnly(lookupProvider);
    }

    @Override
    public Owner getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(String uuid, String name) {
        this.owner.set(uuid, name);
        this.setChanged();
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST};
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.modules;
    }

    @Override
    public boolean isModuleEnabled(ModuleType module) {
        return this.hasModule(module) && this.moduleStates.get((Object)module) == Boolean.TRUE;
    }

    @Override
    public void toggleModuleState(ModuleType module, boolean shouldBeEnabled) {
        this.moduleStates.put(module, shouldBeEnabled);
    }

    @Override
    public String getModuleDescriptionId(String denotation, ModuleType module) {
        return "module.generic.reinforced_shelf." + module.getTranslationKey().substring(5).replace("securitycraft.", "") + ".description";
    }

    public BlockEntityType<?> getType() {
        return (BlockEntityType)SCContent.REINFORCED_SHELF_BLOCK_ENTITY.get();
    }

    @Override
    public Level myLevel() {
        return this.level;
    }

    @Override
    public BlockPos myPos() {
        return this.worldPosition;
    }
}

