/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blockentities.KeycardLockBlockEntity;
import net.geforcemods.securitycraft.blocks.AbstractPanelBlock;
import net.geforcemods.securitycraft.blocks.KeycardReaderBlock;
import net.geforcemods.securitycraft.components.KeycardData;
import net.geforcemods.securitycraft.components.OwnerData;
import net.geforcemods.securitycraft.items.KeycardItem;
import net.geforcemods.securitycraft.items.UniversalKeyChangerItem;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.TeamUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class KeycardLockBlock
extends AbstractPanelBlock {
    public static final VoxelShape FLOOR_NS = Block.box((double)4.0, (double)0.0, (double)3.0, (double)12.0, (double)3.0, (double)13.0);
    public static final VoxelShape FLOOR_EW = Block.box((double)3.0, (double)0.0, (double)4.0, (double)13.0, (double)3.0, (double)12.0);
    public static final VoxelShape CEILING_NS = Block.box((double)4.0, (double)13.0, (double)3.0, (double)12.0, (double)16.0, (double)13.0);
    public static final VoxelShape CEILING_EW = Block.box((double)3.0, (double)13.0, (double)4.0, (double)13.0, (double)16.0, (double)12.0);
    public static final VoxelShape WALL_N = Block.box((double)4.0, (double)3.0, (double)13.0, (double)12.0, (double)13.0, (double)16.0);
    public static final VoxelShape WALL_E = Block.box((double)0.0, (double)3.0, (double)4.0, (double)3.0, (double)13.0, (double)12.0);
    public static final VoxelShape WALL_S = Block.box((double)4.0, (double)3.0, (double)0.0, (double)12.0, (double)13.0, (double)3.0);
    public static final VoxelShape WALL_W = Block.box((double)13.0, (double)3.0, (double)4.0, (double)16.0, (double)13.0, (double)12.0);

    public KeycardLockBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return KeycardReaderBlock.useItemOn(stack, state, level, pos, player, hand, be -> {
            if (!be.isSetUp()) {
                PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:keycard_lock.not_set_up", new Object[0]), ChatFormatting.RED);
                return;
            }
            if (stack.getItem() instanceof KeycardItem) {
                KeycardData keycardData = (KeycardData)stack.get(SCContent.KEYCARD_DATA);
                if (keycardData == null) {
                    PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:keycard_lock.unlinked_keycard", new Object[0]), ChatFormatting.RED);
                } else {
                    Owner keycardOwner = ((OwnerData)stack.getOrDefault(SCContent.OWNER_DATA, (Object)OwnerData.DEFAULT)).toOwner();
                    if (!TeamUtils.areOnSameTeam(be.getOwner(), keycardOwner) || !be.getOwner().getUUID().equals(keycardOwner.getUUID())) {
                        PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:keycard_lock.different_owner", new Object[0]), ChatFormatting.RED);
                    }
                }
                return;
            }
            if (stack.getItem() instanceof UniversalKeyChangerItem) {
                if (be.isOwnedBy((Entity)player)) {
                    stack.hurtAndBreak(1, (LivingEntity)player, hand.asEquipmentSlot());
                    be.reset();
                    PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:keycard_lock.reset", new Object[0]), ChatFormatting.GREEN);
                } else {
                    PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:notOwned", be.getOwner().getName()), ChatFormatting.RED);
                }
            }
        });
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return switch ((AttachFace)state.getValue((Property)FACE)) {
            default -> throw new MatchException(null, null);
            case AttachFace.FLOOR -> {
                switch ((Direction)state.getValue((Property)FACING)) {
                    case NORTH: 
                    case SOUTH: {
                        yield FLOOR_NS;
                    }
                    case EAST: 
                    case WEST: {
                        yield FLOOR_EW;
                    }
                }
                yield Shapes.empty();
            }
            case AttachFace.CEILING -> {
                switch ((Direction)state.getValue((Property)FACING)) {
                    case NORTH: 
                    case SOUTH: {
                        yield CEILING_NS;
                    }
                    case EAST: 
                    case WEST: {
                        yield CEILING_EW;
                    }
                }
                yield Shapes.empty();
            }
            case AttachFace.WALL -> {
                switch ((Direction)state.getValue((Property)FACING)) {
                    case NORTH: {
                        yield WALL_N;
                    }
                    case EAST: {
                        yield WALL_E;
                    }
                    case SOUTH: {
                        yield WALL_S;
                    }
                    case WEST: {
                        yield WALL_W;
                    }
                }
                yield Shapes.empty();
            }
        };
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new KeycardLockBlockEntity(pos, state);
    }
}

