/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.mines;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.api.IExplosive;
import net.geforcemods.securitycraft.blockentities.TrackMineBlockEntity;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.minecart.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RailBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public class TrackMineBlock
extends RailBlock
implements IExplosive,
EntityBlock {
    private final float destroyTimeForOwner = OwnableBlock.getStoredDestroyTime();

    public TrackMineBlock(BlockBehaviour.Properties properties) {
        super(OwnableBlock.withReinforcedDestroyTime(properties));
    }

    public InteractionResult useItemOn(ItemStack heldItem, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return this.exUseItemOn(heldItem, state, level, pos, player, hand, hit);
    }

    public float getDestroyProgress(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        return BlockUtils.getDestroyProgress((x$0, x$1, x$2, x$3) -> super.getDestroyProgress(x$0, x$1, x$2, x$3), this.destroyTimeForOwner, state, player, level, pos);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (placer instanceof Player) {
            Player player = (Player)placer;
            NeoForge.EVENT_BUS.post((Event)new OwnershipEvent(level, pos, player));
        }
    }

    public void onMinecartPass(BlockState state, Level level, BlockPos pos, AbstractMinecart cart) {
        TrackMineBlockEntity be;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TrackMineBlockEntity && (be = (TrackMineBlockEntity)blockEntity).isActive()) {
            level.destroyBlock(pos, false);
            level.explode((Entity)cart, (double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ(), (Boolean)ConfigHandler.SERVER.smallerMineExplosion.get() != false ? 3.0f : 6.0f, ((Boolean)ConfigHandler.SERVER.shouldSpawnFire.get()).booleanValue(), BlockUtils.getExplosionInteraction());
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                cart.kill(serverLevel);
            }
        }
    }

    @Override
    public void explode(Level level, BlockPos pos) {
        TrackMineBlockEntity be;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TrackMineBlockEntity && (be = (TrackMineBlockEntity)blockEntity).isActive()) {
            level.destroyBlock(pos, false);
            level.explode(null, (double)pos.getX(), (double)pos.above().getY(), (double)pos.getZ(), (Boolean)ConfigHandler.SERVER.smallerMineExplosion.get() != false ? 3.0f : 6.0f, ((Boolean)ConfigHandler.SERVER.shouldSpawnFire.get()).booleanValue(), BlockUtils.getExplosionInteraction());
        }
    }

    @Override
    public boolean activateMine(Level level, BlockPos pos) {
        TrackMineBlockEntity be;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TrackMineBlockEntity && !(be = (TrackMineBlockEntity)blockEntity).isActive()) {
            be.activate();
            level.gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, pos);
            return true;
        }
        return false;
    }

    @Override
    public boolean defuseMine(Level level, BlockPos pos) {
        TrackMineBlockEntity be;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TrackMineBlockEntity && (be = (TrackMineBlockEntity)blockEntity).isActive()) {
            be.deactivate();
            level.gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, pos);
            return true;
        }
        return false;
    }

    @Override
    public boolean isActive(Level level, BlockPos pos) {
        TrackMineBlockEntity be;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        return blockEntity instanceof TrackMineBlockEntity && (be = (TrackMineBlockEntity)blockEntity).isActive();
    }

    @Override
    public boolean isDefusable() {
        return true;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TrackMineBlockEntity(pos, state);
    }

    @Override
    public boolean explodesWhenInteractedWith() {
        return false;
    }
}

