/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blocks.reinforced.BaseReinforcedBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Util;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ReinforcedMossyCarpetBlock
extends BaseReinforcedBlock
implements BonemealableBlock {
    public static final BooleanProperty BASE = BlockStateProperties.BOTTOM;
    private static final EnumProperty<WallSide> NORTH = BlockStateProperties.NORTH_WALL;
    private static final EnumProperty<WallSide> EAST = BlockStateProperties.EAST_WALL;
    private static final EnumProperty<WallSide> SOUTH = BlockStateProperties.SOUTH_WALL;
    private static final EnumProperty<WallSide> WEST = BlockStateProperties.WEST_WALL;
    private static final Map<Direction, EnumProperty<WallSide>> PROPERTY_BY_DIRECTION = ImmutableMap.copyOf((Map)((Map)Util.make((Object)Maps.newEnumMap(Direction.class), map -> {
        map.put(Direction.NORTH, NORTH);
        map.put(Direction.EAST, EAST);
        map.put(Direction.SOUTH, SOUTH);
        map.put(Direction.WEST, WEST);
    })));
    private static final VoxelShape DOWN_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    private static final VoxelShape WEST_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST_AABB = Block.box((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape NORTH_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    private static final VoxelShape SOUTH_AABB = Block.box((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape WEST_SHORT_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)10.0, (double)16.0);
    private static final VoxelShape EAST_SHORT_AABB = Block.box((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0);
    private static final VoxelShape NORTH_SHORT_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)1.0);
    private static final VoxelShape SOUTH_SHORT_AABB = Block.box((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)10.0, (double)16.0);
    private final Map<BlockState, VoxelShape> shapesCache;

    public ReinforcedMossyCarpetBlock(BlockBehaviour.Properties properties, Block block) {
        super(properties, block);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BASE, (Comparable)Boolean.valueOf(true))).setValue(NORTH, (Comparable)WallSide.NONE)).setValue(EAST, (Comparable)WallSide.NONE)).setValue(SOUTH, (Comparable)WallSide.NONE)).setValue(WEST, (Comparable)WallSide.NONE));
        this.shapesCache = ImmutableMap.copyOf(this.stateDefinition.getPossibleStates().stream().collect(Collectors.toMap(Function.identity(), ReinforcedMossyCarpetBlock::calculateShape)));
    }

    protected VoxelShape getOcclusionShape(BlockState state) {
        return Shapes.empty();
    }

    private static VoxelShape calculateShape(BlockState state) {
        VoxelShape voxelshape = Shapes.empty();
        if (((Boolean)state.getValue((Property)BASE)).booleanValue()) {
            voxelshape = DOWN_AABB;
        }
        voxelshape = switch ((WallSide)state.getValue(NORTH)) {
            default -> throw new MatchException(null, null);
            case WallSide.NONE -> voxelshape;
            case WallSide.LOW -> Shapes.or((VoxelShape)voxelshape, (VoxelShape)NORTH_SHORT_AABB);
            case WallSide.TALL -> Shapes.or((VoxelShape)voxelshape, (VoxelShape)NORTH_AABB);
        };
        voxelshape = switch ((WallSide)state.getValue(SOUTH)) {
            default -> throw new MatchException(null, null);
            case WallSide.NONE -> voxelshape;
            case WallSide.LOW -> Shapes.or((VoxelShape)voxelshape, (VoxelShape)SOUTH_SHORT_AABB);
            case WallSide.TALL -> Shapes.or((VoxelShape)voxelshape, (VoxelShape)SOUTH_AABB);
        };
        voxelshape = switch ((WallSide)state.getValue(EAST)) {
            default -> throw new MatchException(null, null);
            case WallSide.NONE -> voxelshape;
            case WallSide.LOW -> Shapes.or((VoxelShape)voxelshape, (VoxelShape)EAST_SHORT_AABB);
            case WallSide.TALL -> Shapes.or((VoxelShape)voxelshape, (VoxelShape)EAST_AABB);
        };
        voxelshape = switch ((WallSide)state.getValue(WEST)) {
            default -> throw new MatchException(null, null);
            case WallSide.NONE -> voxelshape;
            case WallSide.LOW -> Shapes.or((VoxelShape)voxelshape, (VoxelShape)WEST_SHORT_AABB);
            case WallSide.TALL -> Shapes.or((VoxelShape)voxelshape, (VoxelShape)WEST_AABB);
        };
        return voxelshape.isEmpty() ? Shapes.block() : voxelshape;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return this.shapesCache.get(state);
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return (Boolean)state.getValue((Property)BASE) != false ? DOWN_AABB : Shapes.empty();
    }

    protected boolean propagatesSkylightDown(BlockState state) {
        return true;
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockState stateBelow = level.getBlockState(pos.below());
        return (Boolean)state.getValue((Property)BASE) != false || stateBelow.is((Block)this) && (Boolean)stateBelow.getValue((Property)BASE) != false;
    }

    private static boolean hasFaces(BlockState state) {
        if (((Boolean)state.getValue((Property)BASE)).booleanValue()) {
            return true;
        }
        for (EnumProperty<WallSide> wallSide : PROPERTY_BY_DIRECTION.values()) {
            if (state.getValue(wallSide) == WallSide.NONE) continue;
            return true;
        }
        return false;
    }

    private static boolean canSupportAtFace(BlockGetter level, BlockPos pos, Direction direction) {
        return direction != Direction.UP && MultifaceBlock.canAttachTo((BlockGetter)level, (BlockPos)pos, (Direction)direction);
    }

    private static BlockState getUpdatedState(BlockState state, BlockGetter level, BlockPos pos, boolean tip) {
        BlockState stateAbove = null;
        BlockState stateBelow = null;
        tip |= ((Boolean)state.getValue((Property)BASE)).booleanValue();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            WallSide wallSide;
            EnumProperty<WallSide> wallSideProperty = ReinforcedMossyCarpetBlock.getPropertyForFace(direction);
            WallSide wallSide2 = ReinforcedMossyCarpetBlock.canSupportAtFace(level, pos, direction) ? (tip ? WallSide.LOW : (WallSide)state.getValue(wallSideProperty)) : (wallSide = WallSide.NONE);
            if (wallSide == WallSide.LOW) {
                if (stateAbove == null) {
                    stateAbove = level.getBlockState(pos.above());
                }
                if (stateAbove.is(SCContent.REINFORCED_PALE_MOSS_CARPET) && stateAbove.getValue(wallSideProperty) != WallSide.NONE && !((Boolean)stateAbove.getValue((Property)BASE)).booleanValue()) {
                    wallSide = WallSide.TALL;
                }
                if (!((Boolean)state.getValue((Property)BASE)).booleanValue()) {
                    if (stateBelow == null) {
                        stateBelow = level.getBlockState(pos.below());
                    }
                    if (stateBelow.is(SCContent.REINFORCED_PALE_MOSS_CARPET) && stateBelow.getValue(wallSideProperty) == WallSide.NONE) {
                        wallSide = WallSide.NONE;
                    }
                }
            }
            state = (BlockState)state.setValue(wallSideProperty, (Comparable)wallSide);
        }
        return state;
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return ReinforcedMossyCarpetBlock.getUpdatedState(this.defaultBlockState(), (BlockGetter)ctx.getLevel(), ctx.getClickedPos(), true);
    }

    public static void placeAt(LevelAccessor level, BlockPos pos, RandomSource random, int flags) {
        BlockState updatedState = ReinforcedMossyCarpetBlock.getUpdatedState(((ReinforcedMossyCarpetBlock)SCContent.REINFORCED_PALE_MOSS_CARPET.get()).defaultBlockState(), (BlockGetter)level, pos, true);
        level.setBlock(pos, updatedState, 3);
        BlockState topper = ReinforcedMossyCarpetBlock.createTopperWithSideChance((BlockGetter)level, pos, () -> ((RandomSource)random).nextBoolean());
        if (!topper.isAir()) {
            ReinforcedMossyCarpetBlock.setBlockAndOwner(level, pos.above(), topper, flags, (IOwnable)level.getBlockEntity(pos));
        }
    }

    @Override
    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        super.setPlacedBy(level, pos, state, entity, stack);
        if (!level.isClientSide()) {
            BlockState topper = ReinforcedMossyCarpetBlock.createTopperWithSideChance((BlockGetter)level, pos, () -> ((RandomSource)level.getRandom()).nextBoolean());
            if (!topper.isAir()) {
                ReinforcedMossyCarpetBlock.setBlockAndOwner((LevelAccessor)level, pos.above(), topper, 3, (IOwnable)level.getBlockEntity(pos));
            }
        }
    }

    public static void setBlockAndOwner(LevelAccessor level, BlockPos pos, BlockState state, int flags, IOwnable parent) {
        level.setBlock(pos, state, flags);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof IOwnable) {
            IOwnable ownable = (IOwnable)blockEntity;
            Owner owner = parent.getOwner();
            ownable.setOwner(owner.getUUID(), owner.getName());
        }
    }

    private static BlockState createTopperWithSideChance(BlockGetter level, BlockPos pos, BooleanSupplier chanceGetter) {
        BlockPos posAbove = pos.above();
        BlockState stateAbove = level.getBlockState(posAbove);
        boolean flag = stateAbove.is(SCContent.REINFORCED_PALE_MOSS_CARPET);
        if (!(flag && ((Boolean)stateAbove.getValue((Property)BASE)).booleanValue() || !flag && !stateAbove.canBeReplaced())) {
            BlockState notBase = (BlockState)((ReinforcedMossyCarpetBlock)SCContent.REINFORCED_PALE_MOSS_CARPET.get()).defaultBlockState().setValue((Property)BASE, (Comparable)Boolean.valueOf(false));
            BlockState updatedState = ReinforcedMossyCarpetBlock.getUpdatedState(notBase, level, pos.above(), true);
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                EnumProperty<WallSide> wallSide = ReinforcedMossyCarpetBlock.getPropertyForFace(direction);
                if (updatedState.getValue(wallSide) == WallSide.NONE || chanceGetter.getAsBoolean()) continue;
                updatedState = (BlockState)updatedState.setValue(wallSide, (Comparable)WallSide.NONE);
            }
            return ReinforcedMossyCarpetBlock.hasFaces(updatedState) && updatedState != stateAbove ? updatedState : Blocks.AIR.defaultBlockState();
        }
        return Blocks.AIR.defaultBlockState();
    }

    protected BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess tickAccess, BlockPos pos, Direction direction, BlockPos fromPos, BlockState fromState, RandomSource random) {
        if (!state.canSurvive(level, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        BlockState updatedState = ReinforcedMossyCarpetBlock.getUpdatedState(state, (BlockGetter)level, pos, false);
        return !ReinforcedMossyCarpetBlock.hasFaces(updatedState) ? Blocks.AIR.defaultBlockState() : updatedState;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> buidler) {
        buidler.add(new Property[]{BASE, NORTH, EAST, SOUTH, WEST});
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return switch (rotation) {
            case Rotation.CLOCKWISE_180 -> (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(NORTH, (Comparable)((WallSide)state.getValue(SOUTH)))).setValue(EAST, (Comparable)((WallSide)state.getValue(WEST)))).setValue(SOUTH, (Comparable)((WallSide)state.getValue(NORTH)))).setValue(WEST, (Comparable)((WallSide)state.getValue(EAST)));
            case Rotation.COUNTERCLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(NORTH, (Comparable)((WallSide)state.getValue(EAST)))).setValue(EAST, (Comparable)((WallSide)state.getValue(SOUTH)))).setValue(SOUTH, (Comparable)((WallSide)state.getValue(WEST)))).setValue(WEST, (Comparable)((WallSide)state.getValue(NORTH)));
            case Rotation.CLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(NORTH, (Comparable)((WallSide)state.getValue(WEST)))).setValue(EAST, (Comparable)((WallSide)state.getValue(NORTH)))).setValue(SOUTH, (Comparable)((WallSide)state.getValue(EAST)))).setValue(WEST, (Comparable)((WallSide)state.getValue(SOUTH)));
            default -> state;
        };
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return switch (mirror) {
            case Mirror.LEFT_RIGHT -> (BlockState)((BlockState)state.setValue(NORTH, (Comparable)((WallSide)state.getValue(SOUTH)))).setValue(SOUTH, (Comparable)((WallSide)state.getValue(NORTH)));
            case Mirror.FRONT_BACK -> (BlockState)((BlockState)state.setValue(EAST, (Comparable)((WallSide)state.getValue(WEST)))).setValue(WEST, (Comparable)((WallSide)state.getValue(EAST)));
            default -> super.mirror(state, mirror);
        };
    }

    public static EnumProperty<WallSide> getPropertyForFace(Direction direction) {
        return PROPERTY_BY_DIRECTION.get(direction);
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return (Boolean)state.getValue((Property)BASE) != false && !ReinforcedMossyCarpetBlock.createTopperWithSideChance((BlockGetter)level, pos, () -> true).isAir();
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        BlockState topper = ReinforcedMossyCarpetBlock.createTopperWithSideChance((BlockGetter)level, pos, () -> true);
        if (!topper.isAir()) {
            ReinforcedMossyCarpetBlock.setBlockAndOwner((LevelAccessor)level, pos.above(), topper, 3, (IOwnable)level.getBlockEntity(pos));
        }
    }
}

