/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import net.geforcemods.securitycraft.SCTags;
import net.geforcemods.securitycraft.api.IReinforcedBlock;
import net.geforcemods.securitycraft.blockentities.ReinforcedShelfBlockEntity;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ShelfBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public class ReinforcedShelfBlock
extends ShelfBlock
implements IReinforcedBlock {
    private final Block vanillaBlock;
    private final float destroyTimeForOwner;

    public ReinforcedShelfBlock(BlockBehaviour.Properties properties, Block vanillaBlock) {
        super(OwnableBlock.withReinforcedDestroyTime(properties));
        this.vanillaBlock = vanillaBlock;
        this.destroyTimeForOwner = OwnableBlock.getStoredDestroyTime();
    }

    public float getDestroyProgress(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        return BlockUtils.getDestroyProgress((x$0, x$1, x$2, x$3) -> super.getDestroyProgress(x$0, x$1, x$2, x$3), this.destroyTimeForOwner, state, player, level, pos);
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!this.isConnectable(state)) {
            if (this.isNonInteractableShelf(level, pos, player)) {
                return InteractionResult.SUCCESS;
            }
        } else {
            for (BlockPos connectedPos : this.getAllBlocksConnectedTo((LevelAccessor)level, pos)) {
                if (!this.isNonInteractableShelf(level, connectedPos, player)) continue;
                return InteractionResult.SUCCESS;
            }
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    private boolean isNonInteractableShelf(Level level, BlockPos pos, Player player) {
        ReinforcedShelfBlockEntity be;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        return !(blockEntity instanceof ReinforcedShelfBlockEntity) || !(be = (ReinforcedShelfBlockEntity)blockEntity).isOwnedBy((Entity)player) && !be.isAllowed((Entity)player);
    }

    public boolean isConnectable(BlockState state) {
        return state.is(SCTags.Blocks.REINFORCED_WOODEN_SHELVES) && state.hasProperty((Property)POWERED) && (Boolean)state.getValue((Property)POWERED) != false;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (placer instanceof Player) {
            Player player = (Player)placer;
            NeoForge.EVENT_BUS.post((Event)new OwnershipEvent(level, pos, player));
        }
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ReinforcedShelfBlockEntity(pos, state);
    }

    @Override
    public Block getVanillaBlock() {
        return this.vanillaBlock;
    }
}

