/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.geforcemods.securitycraft.blocks.reinforced.BaseReinforcedBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ReinforcedStairsBlock
extends BaseReinforcedBlock
implements SimpleWaterloggedBlock {
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static final EnumProperty<Half> HALF = BlockStateProperties.HALF;
    public static final EnumProperty<StairsShape> SHAPE = BlockStateProperties.STAIRS_SHAPE;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected static final VoxelShape AABB_SLAB_TOP = Block.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape AABB_SLAB_BOTTOM = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape NWD_CORNER = Block.box((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0);
    protected static final VoxelShape SWD_CORNER = Block.box((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0);
    protected static final VoxelShape NWU_CORNER = Block.box((double)0.0, (double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0);
    protected static final VoxelShape SWU_CORNER = Block.box((double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0);
    protected static final VoxelShape NED_CORNER = Block.box((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0);
    protected static final VoxelShape SED_CORNER = Block.box((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape NEU_CORNER = Block.box((double)8.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    protected static final VoxelShape SEU_CORNER = Block.box((double)8.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape[] SLAB_TOP_SHAPES = ReinforcedStairsBlock.makeShapes(AABB_SLAB_TOP, NWD_CORNER, NED_CORNER, SWD_CORNER, SED_CORNER);
    protected static final VoxelShape[] SLAB_BOTTOM_SHAPES = ReinforcedStairsBlock.makeShapes(AABB_SLAB_BOTTOM, NWU_CORNER, NEU_CORNER, SWU_CORNER, SEU_CORNER);
    private static final int[] SHAPE_BY_STATE = new int[]{12, 5, 3, 10, 14, 13, 7, 11, 13, 7, 11, 14, 8, 4, 1, 2, 4, 1, 2, 8};

    public ReinforcedStairsBlock(BlockBehaviour.Properties properties, Block vB) {
        this(properties, () -> vB);
    }

    public ReinforcedStairsBlock(BlockBehaviour.Properties properties, Supplier<? extends Block> vB) {
        super(properties, vB);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue(HALF, (Comparable)Half.BOTTOM)).setValue(SHAPE, (Comparable)StairsShape.STRAIGHT)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    private static VoxelShape[] makeShapes(VoxelShape slabShape, VoxelShape nwCorner, VoxelShape neCorner, VoxelShape swCorner, VoxelShape seCorner) {
        return (VoxelShape[])IntStream.range(0, 16).mapToObj(shape -> ReinforcedStairsBlock.combineShapes(shape, slabShape, nwCorner, neCorner, swCorner, seCorner)).toArray(VoxelShape[]::new);
    }

    private static VoxelShape combineShapes(int bitfield, VoxelShape slabShape, VoxelShape nwCorner, VoxelShape neCorner, VoxelShape swCorner, VoxelShape seCorner) {
        VoxelShape shape = slabShape;
        if ((bitfield & 1) != 0) {
            shape = Shapes.or((VoxelShape)slabShape, (VoxelShape)nwCorner);
        }
        if ((bitfield & 2) != 0) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)neCorner);
        }
        if ((bitfield & 4) != 0) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)swCorner);
        }
        if ((bitfield & 8) != 0) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)seCorner);
        }
        return shape;
    }

    public boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (state.getValue(HALF) == Half.TOP ? SLAB_TOP_SHAPES : SLAB_BOTTOM_SHAPES)[SHAPE_BY_STATE[this.getShapeIndex(state)]];
    }

    private int getShapeIndex(BlockState state) {
        return ((StairsShape)state.getValue(SHAPE)).ordinal() * 4 + ((Direction)state.getValue(FACING)).get2DDataValue();
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction dir = ctx.getClickedFace();
        BlockPos pos = ctx.getClickedPos();
        FluidState fluidState = ctx.getLevel().getFluidState(pos);
        BlockState state = (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)ctx.getHorizontalDirection())).setValue(HALF, (Comparable)(dir != Direction.DOWN && (dir == Direction.UP || ctx.getClickLocation().y - (double)pos.getY() <= 0.5) ? Half.BOTTOM : Half.TOP))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
        return (BlockState)state.setValue(SHAPE, (Comparable)ReinforcedStairsBlock.getShapeProperty(state, (BlockGetter)ctx.getLevel(), pos));
    }

    public BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess tickAccess, BlockPos pos, Direction facing, BlockPos facingPos, BlockState facingState, RandomSource random) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            tickAccess.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(level));
        }
        return facing.getAxis().isHorizontal() ? (BlockState)state.setValue(SHAPE, (Comparable)ReinforcedStairsBlock.getShapeProperty(state, (BlockGetter)level, pos)) : super.updateShape(state, level, tickAccess, pos, facing, facingPos, facingState, random);
    }

    private static StairsShape getShapeProperty(BlockState state, BlockGetter level, BlockPos pos) {
        Direction offsetOppositeDir;
        Direction offsetDir;
        Direction dir = (Direction)state.getValue(FACING);
        BlockState offsetState = level.getBlockState(pos.relative(dir));
        if (ReinforcedStairsBlock.isBlockStairs(offsetState) && state.getValue(HALF) == offsetState.getValue(HALF) && (offsetDir = (Direction)offsetState.getValue(FACING)).getAxis() != ((Direction)state.getValue(FACING)).getAxis() && ReinforcedStairsBlock.isDifferentStairs(state, level, pos, offsetDir.getOpposite())) {
            if (offsetDir == dir.getCounterClockWise()) {
                return StairsShape.OUTER_LEFT;
            }
            return StairsShape.OUTER_RIGHT;
        }
        BlockState offsetOppositeState = level.getBlockState(pos.relative(dir.getOpposite()));
        if (ReinforcedStairsBlock.isBlockStairs(offsetOppositeState) && state.getValue(HALF) == offsetOppositeState.getValue(HALF) && (offsetOppositeDir = (Direction)offsetOppositeState.getValue(FACING)).getAxis() != ((Direction)state.getValue(FACING)).getAxis() && ReinforcedStairsBlock.isDifferentStairs(state, level, pos, offsetOppositeDir)) {
            if (offsetOppositeDir == dir.getCounterClockWise()) {
                return StairsShape.INNER_LEFT;
            }
            return StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }

    private static boolean isDifferentStairs(BlockState state, BlockGetter level, BlockPos pos, Direction face) {
        BlockState offsetState = level.getBlockState(pos.relative(face));
        return !ReinforcedStairsBlock.isBlockStairs(offsetState) || offsetState.getValue(FACING) != state.getValue(FACING) || offsetState.getValue(HALF) != state.getValue(HALF);
    }

    public static boolean isBlockStairs(BlockState state) {
        return state.getBlock() instanceof ReinforcedStairsBlock || state.getBlock() instanceof StairBlock;
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        Direction direction = (Direction)state.getValue(FACING);
        StairsShape shape = (StairsShape)state.getValue(SHAPE);
        switch (mirror) {
            case LEFT_RIGHT: {
                if (direction.getAxis() != Direction.Axis.Z) break;
                return switch (shape) {
                    case StairsShape.INNER_LEFT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    case StairsShape.INNER_RIGHT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    case StairsShape.OUTER_LEFT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    case StairsShape.OUTER_RIGHT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    default -> state.rotate(Rotation.CLOCKWISE_180);
                };
            }
            case FRONT_BACK: {
                if (direction.getAxis() != Direction.Axis.X) break;
                return switch (shape) {
                    default -> throw new MatchException(null, null);
                    case StairsShape.INNER_LEFT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    case StairsShape.INNER_RIGHT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    case StairsShape.OUTER_LEFT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    case StairsShape.OUTER_RIGHT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    case StairsShape.STRAIGHT -> state.rotate(Rotation.CLOCKWISE_180);
                };
            }
        }
        return super.mirror(state, mirror);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, HALF, SHAPE, WATERLOGGED});
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }
}

