/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.commands;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.function.Predicate;
import net.geforcemods.securitycraft.api.IPasscodeConvertible;
import net.geforcemods.securitycraft.api.IReinforcedBlock;
import net.geforcemods.securitycraft.api.SecurityCraftAPI;
import net.geforcemods.securitycraft.commands.LowercasedEnumArgument;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.commands.FillCommand;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.permissions.PermissionCheck;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.neoforged.neoforge.common.util.TriPredicate;

public class ConvertCommand {
    private static final SimpleCommandExceptionType ERROR_SET_FAILED = new SimpleCommandExceptionType((Message)Component.translatableWithFallback((String)"commands.securitycraft.convert.set.failed", (String)"There is no convertible block at the given position"));
    private static final SimpleCommandExceptionType ERROR_FILL_FAILED = new SimpleCommandExceptionType((Message)Component.translatableWithFallback((String)"commands.securitycraft.convert.fill.failed", (String)"There are no convertible blocks in the given area"));

    private ConvertCommand() {
    }

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"convert").requires((Predicate)Commands.hasPermission((PermissionCheck)Commands.LEVEL_GAMEMASTERS))).then(((RequiredArgumentBuilder)Commands.argument((String)"mode", LowercasedEnumArgument.enumArgument(ConversionMode.class)).then(Commands.literal((String)"set").then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(ctx -> ConvertCommand.set((CommandSourceStack)ctx.getSource(), (ConversionMode)((Object)((Object)ctx.getArgument("mode", ConversionMode.class))), BlockPosArgument.getLoadedBlockPos((CommandContext)ctx, (String)"pos")))))).then(Commands.literal((String)"fill").then(Commands.argument((String)"from", (ArgumentType)BlockPosArgument.blockPos()).then(Commands.argument((String)"to", (ArgumentType)BlockPosArgument.blockPos()).executes(ctx -> ConvertCommand.fill((CommandContext<CommandSourceStack>)ctx))))));
    }

    private static int set(CommandSourceStack source, ConversionMode mode, BlockPos pos) throws CommandSyntaxException {
        ServerLevel level = source.getLevel();
        if (!mode.convert(level.getBlockState(pos), (Level)level, pos)) {
            throw ERROR_SET_FAILED.create();
        }
        source.sendSuccess(() -> Component.translatableWithFallback((String)"commands.securitycraft.convert.set.success", (String)"Converted the block at %s, %s, %s", (Object[])new Object[]{pos.getX(), pos.getY(), pos.getZ()}), true);
        return 1;
    }

    private static int fill(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        int maxBlockModifications;
        ConversionMode mode = (ConversionMode)((Object)ctx.getArgument("mode", ConversionMode.class));
        BoundingBox area = BoundingBox.fromCorners((Vec3i)BlockPosArgument.getLoadedBlockPos(ctx, (String)"from"), (Vec3i)BlockPosArgument.getLoadedBlockPos(ctx, (String)"to"));
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        ServerLevel level = source.getLevel();
        int blockCount = area.getXSpan() * area.getYSpan() * area.getZSpan();
        if (blockCount > (maxBlockModifications = ((Integer)level.getGameRules().get(GameRules.MAX_BLOCK_MODIFICATIONS)).intValue())) {
            throw FillCommand.ERROR_AREA_TOO_LARGE.create((Object)maxBlockModifications, (Object)blockCount);
        }
        int blocksModified = 0;
        for (BlockPos pos : BlockPos.betweenClosed((int)area.minX(), (int)area.minY(), (int)area.minZ(), (int)area.maxX(), (int)area.maxY(), (int)area.maxZ())) {
            BlockState state = level.getBlockState(pos);
            if (!mode.convert(state, (Level)level, pos)) continue;
            ++blocksModified;
        }
        if (blocksModified == 0) {
            throw ERROR_FILL_FAILED.create();
        }
        int finalBlocksModified = blocksModified;
        source.sendSuccess(() -> Component.translatableWithFallback((String)"commands.securitycraft.convert.fill.success", (String)"Successfully converted %s block(s)", (Object[])new Object[]{finalBlocksModified}), true);
        return blocksModified;
    }

    private static enum ConversionMode {
        REINFORCE((TriPredicate<BlockState, Level, BlockPos>)((TriPredicate)(state, level, pos) -> {
            Block block = state.getBlock();
            if (IReinforcedBlock.VANILLA_TO_SECURITYCRAFT.containsKey(block)) {
                level.setBlockAndUpdate(pos, ((IReinforcedBlock)IReinforcedBlock.VANILLA_TO_SECURITYCRAFT.get(block)).convertToReinforced((Level)level, (BlockPos)pos, (BlockState)state));
                return true;
            }
            return false;
        })),
        UNREINFORCE((TriPredicate<BlockState, Level, BlockPos>)((TriPredicate)(state, level, pos) -> {
            Block block = state.getBlock();
            if (IReinforcedBlock.SECURITYCRAFT_TO_VANILLA.containsKey(block)) {
                level.setBlockAndUpdate(pos, ((IReinforcedBlock)block).convertToVanilla((Level)level, (BlockPos)pos, (BlockState)state));
                return true;
            }
            return false;
        })),
        PASSCODE_PROTECT((TriPredicate<BlockState, Level, BlockPos>)((TriPredicate)(state, level, pos) -> {
            for (IPasscodeConvertible convertible : SecurityCraftAPI.getRegisteredPasscodeConvertibles()) {
                if (!convertible.isUnprotectedBlock((BlockState)state)) continue;
                return convertible.protect(null, (Level)level, (BlockPos)pos);
            }
            return false;
        })),
        REMOVE_PASSCODE_PROTECTION((TriPredicate<BlockState, Level, BlockPos>)((TriPredicate)(state, level, pos) -> {
            for (IPasscodeConvertible convertible : SecurityCraftAPI.getRegisteredPasscodeConvertibles()) {
                if (!convertible.isProtectedBlock((BlockState)state)) continue;
                return convertible.unprotect(null, (Level)level, (BlockPos)pos);
            }
            return false;
        }));

        private final TriPredicate<BlockState, Level, BlockPos> converter;

        private ConversionMode(TriPredicate<BlockState, Level, BlockPos> converter) {
            this.converter = converter;
        }

        public boolean convert(BlockState state, Level level, BlockPos pos) {
            return this.converter.test((Object)state, (Object)level, (Object)pos);
        }
    }
}

