/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.entity.sentry.Sentry;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;

public class SentryItem
extends Item {
    public SentryItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext ctx) {
        BlockState stateAtPlacePos;
        Level level = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        ItemStack stack = ctx.getItemInHand();
        boolean replacesTargetedBlock = level.getBlockState(pos).canBeReplaced(new BlockPlaceContext(ctx));
        if (!(replacesTargetedBlock || (stateAtPlacePos = level.getBlockState(pos = pos.relative(ctx.getClickedFace()))).isAir() || stateAtPlacePos.getBlock() instanceof LiquidBlock)) {
            return InteractionResult.PASS;
        }
        Player player = ctx.getPlayer();
        BlockPos downPos = pos.below();
        if (level.isEmptyBlock(downPos) || level.noCollision(new AABB(downPos))) {
            PlayerUtils.sendMessageToPlayer(player, Utils.localize(((SentryItem)((Object)SCContent.SENTRY.get())).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:sentry.needsBlockBelow", new Object[0]), ChatFormatting.DARK_RED);
            return InteractionResult.FAIL;
        }
        if (replacesTargetedBlock) {
            level.removeBlock(pos, false);
        }
        Sentry entity = (Sentry)((EntityType)SCContent.SENTRY_ENTITY.get()).create(level, EntitySpawnReason.SPAWN_ITEM_USE);
        entity.setPos((float)pos.getX() + 0.5f, pos.getY(), (float)pos.getZ() + 0.5f);
        entity.setUpSentry(player);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            EntityType.createDefaultStackConfig((Level)serverLevel, (ItemStack)stack, (LivingEntity)player).accept(entity);
        }
        level.addFreshEntity((Entity)entity);
        entity.gameEvent((Holder)GameEvent.ENTITY_PLACE, (Entity)player);
        player.displayClientMessage((Component)Utils.localize(Sentry.SentryMode.CAMOUFLAGE_HP.getModeKey(), new Object[0]).append((Component)Utils.localize(Sentry.SentryMode.CAMOUFLAGE_HP.getDescriptionKey(), new Object[0])), true);
        if (!player.isCreative()) {
            stack.shrink(1);
        }
        return InteractionResult.SUCCESS;
    }
}

