/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.misc;

import com.google.common.base.Suppliers;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.misc.PageGroup;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BoatItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public record SCManualPage(Item item, PageGroup group, Component title, Component helpInfo, String designedBy, boolean hasRecipeDescription, Supplier<Optional<List<RecipeDisplay>>> recipes) {
    public static final StreamCodec<RegistryFriendlyByteBuf, SCManualPage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT.map(Item::byId, Item::getId), SCManualPage::item, (StreamCodec)ByteBufCodecs.VAR_INT.map(i -> PageGroup.values()[i], Enum::ordinal), SCManualPage::group, (StreamCodec)ComponentSerialization.STREAM_CODEC, SCManualPage::title, (StreamCodec)ComponentSerialization.STREAM_CODEC, SCManualPage::helpInfo, (StreamCodec)ByteBufCodecs.STRING_UTF8, SCManualPage::designedBy, (StreamCodec)ByteBufCodecs.BOOL, SCManualPage::hasRecipeDescription, (StreamCodec)ByteBufCodecs.optional((StreamCodec)RecipeDisplay.STREAM_CODEC.apply(ByteBufCodecs.list())).map(o -> Suppliers.memoize(() -> o), Supplier::get), SCManualPage::recipes, SCManualPage::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, List<SCManualPage>> LIST_STREAM_CODEC = STREAM_CODEC.apply(ByteBufCodecs.list());

    public Object getInWorldObject() {
        Item item = this.item;
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            Block block = blockItem.getBlock();
            if (block.defaultBlockState().hasBlockEntity()) {
                return ((EntityBlock)block).newBlockEntity(BlockPos.ZERO, block.defaultBlockState());
            }
        } else {
            item = this.item;
            if (item instanceof BoatItem) {
                BoatItem boatItem = (BoatItem)item;
                return boatItem.getBoat(ClientHandler.getClientLevel(), (HitResult)BlockHitResult.miss((Vec3)Vec3.ZERO, (Direction)Direction.NORTH, (BlockPos)BlockPos.ZERO), this.item.getDefaultInstance(), null);
            }
        }
        return null;
    }
}

