/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.models;

import java.util.List;
import net.geforcemods.securitycraft.models.DisguisableBlockModelPart;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.model.data.ModelData;
import net.neoforged.neoforge.model.data.ModelProperty;

public class DisguisableBlockStateModel
implements BlockStateModel {
    public static final ModelProperty<BlockState> DISGUISED_STATE = new ModelProperty();
    private final BlockStateModel oldModel;

    public DisguisableBlockStateModel(BlockStateModel oldModel) {
        this.oldModel = oldModel;
    }

    public void collectParts(BlockAndTintGetter level, BlockPos pos, BlockState state, RandomSource random, List<BlockModelPart> parts) {
        BlockStateModel model;
        Block block;
        ModelData modelData = level.getModelData(pos);
        BlockState disguisedState = (BlockState)modelData.get(DISGUISED_STATE);
        if (disguisedState != null && (block = disguisedState.getBlock()) != Blocks.AIR && (model = Minecraft.getInstance().getBlockRenderer().getBlockModel(disguisedState)) != this) {
            for (BlockModelPart disguisedPart : model.collectParts(level, pos, state, random)) {
                parts.add(new DisguisableBlockModelPart(disguisedPart, disguisedState));
            }
            return;
        }
        this.collectOldParts(modelData, level, pos, state, random, parts);
    }

    public void collectOldParts(ModelData modelData, BlockAndTintGetter level, BlockPos pos, BlockState state, RandomSource random, List<BlockModelPart> parts) {
        parts.addAll(this.oldModel.collectParts(level, pos, state, random));
    }

    public void collectParts(RandomSource random, List<BlockModelPart> modelList) {
        modelList.addAll(this.oldModel.collectParts(random));
    }

    public TextureAtlasSprite particleIcon(BlockAndTintGetter level, BlockPos pos, BlockState state) {
        BlockStateModel model;
        Block block;
        ModelData modelData = level.getModelData(pos);
        BlockState disguisedState = (BlockState)modelData.get(DISGUISED_STATE);
        if (disguisedState != null && (block = disguisedState.getBlock()) != Blocks.AIR && (model = Minecraft.getInstance().getBlockRenderer().getBlockModel(disguisedState)) != this) {
            return model.particleIcon(level, pos, state);
        }
        return this.oldParticleIcon(modelData, level, pos, state);
    }

    public TextureAtlasSprite oldParticleIcon(ModelData modelData, BlockAndTintGetter level, BlockPos pos, BlockState state) {
        return this.oldModel.particleIcon(level, pos, state);
    }

    public TextureAtlasSprite particleIcon() {
        return this.oldModel.particleIcon();
    }
}

