/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.ICustomizable;
import net.geforcemods.securitycraft.api.IOwnable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ToggleOption
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<ToggleOption> TYPE = new CustomPacketPayload.Type(SecurityCraft.resLoc("toggle_option"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ToggleOption> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, ToggleOption>(){

        public ToggleOption decode(RegistryFriendlyByteBuf buf) {
            if (buf.readBoolean()) {
                return new ToggleOption(buf.readBlockPos(), buf.readVarInt());
            }
            return new ToggleOption(buf.readVarInt(), buf.readVarInt());
        }

        public void encode(RegistryFriendlyByteBuf buf, ToggleOption packet) {
            boolean hasPos = packet.pos != null;
            buf.writeBoolean(hasPos);
            if (hasPos) {
                buf.writeBlockPos(packet.pos);
            } else {
                buf.writeVarInt(packet.entityId);
            }
            buf.writeVarInt(packet.optionId);
        }
    };
    private BlockPos pos;
    private int optionId;
    private int entityId;

    public ToggleOption(BlockPos pos, int optionId) {
        this.pos = pos;
        this.optionId = optionId;
    }

    public ToggleOption(int entityId, int optionId) {
        this.entityId = entityId;
        this.optionId = optionId;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        IOwnable ownable;
        Player player = ctx.player();
        Level level = player.level();
        ICustomizable customizable = this.getCustomizable(level);
        if (!(player.isSpectator() || customizable == null || customizable instanceof IOwnable && !(ownable = (IOwnable)((Object)customizable)).isOwnedBy((Entity)player))) {
            customizable.customOptions()[this.optionId].toggle();
            customizable.onOptionChanged(customizable.customOptions()[this.optionId]);
            if (customizable instanceof BlockEntity) {
                BlockEntity be = (BlockEntity)customizable;
                level.sendBlockUpdated(this.pos, be.getBlockState(), be.getBlockState(), 3);
            }
        }
    }

    private ICustomizable getCustomizable(Level level) {
        if (this.pos != null) {
            BlockEntity blockEntity = level.getBlockEntity(this.pos);
            if (blockEntity instanceof ICustomizable) {
                ICustomizable be = (ICustomizable)blockEntity;
                return be;
            }
        } else {
            Entity entity = level.getEntity(this.entityId);
            if (entity instanceof ICustomizable) {
                ICustomizable entity2 = (ICustomizable)entity;
                return entity2;
            }
        }
        return null;
    }
}

