/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;

public class FloorTrapCloudParticle
extends SingleQuadParticle {
    public FloorTrapCloudParticle(TextureAtlasSprite sprite, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        super(level, x, y, z, sprite);
        this.setSize(0.01f, 0.01f);
        this.quadSize *= this.random.nextFloat() * 0.6f + 0.4f;
        this.hasPhysics = false;
        this.xd = xSpeed;
        this.yd = ySpeed;
        this.zd = zSpeed;
    }

    public SingleQuadParticle.Layer getLayer() {
        return SingleQuadParticle.Layer.OPAQUE;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Provider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, RandomSource random) {
            FloorTrapCloudParticle particle = new FloorTrapCloudParticle(this.spriteSet.get(random), level, x, y, z, random.nextGaussian() * 0.0075, 0.005, random.nextGaussian() * 0.0075);
            particle.lifetime = Mth.randomBetweenInclusive((RandomSource)level.random, (int)10, (int)40);
            particle.gravity = 0.0f;
            return particle;
        }
    }
}

