/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.blockentities.ProjectorBlockEntity;
import net.geforcemods.securitycraft.blocks.ProjectorBlock;
import net.geforcemods.securitycraft.renderers.state.ProjectorRenderState;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.block.MovingBlockRenderState;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.TriPredicate;

public class ProjectorRenderer
implements BlockEntityRenderer<ProjectorBlockEntity, ProjectorRenderState> {
    public static final int RENDER_DISTANCE = 100;
    private final TriPredicate<Integer, Boolean, Integer> yLoopBoundary = (projectionHeight, hanging, y) -> hanging.booleanValue() ? y > -projectionHeight.intValue() : y < projectionHeight;

    public ProjectorRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void submit(ProjectorRenderState state, PoseStack pose, SubmitNodeCollector collector, CameraRenderState camera) {
        ClientHandler.DISGUISED_BLOCK_RENDER_DELEGATE.trySubmitDelegate(state.disguiseRenderState, pose, collector, camera);
        for (ProjectionInfo projectionInfo : state.renderPositions) {
            Vec3i positionalOffset = projectionInfo.positionalOffset;
            pose.pushPose();
            pose.translate((float)positionalOffset.getX(), (float)positionalOffset.getY(), (float)positionalOffset.getZ());
            collector.submitMovingBlock(pose, projectionInfo.movingBlockRenderState);
            ClientHandler.PROJECTOR_RENDER_DELEGATE.trySubmitDelegate(state.projectedBlockEntityRenderState, pose, collector, camera);
            pose.popPose();
        }
    }

    public ProjectorRenderState createRenderState() {
        return new ProjectorRenderState();
    }

    public void extractRenderState(ProjectorBlockEntity be, ProjectorRenderState state, float partialTick, Vec3 cameraPos, ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState((BlockEntity)be, (BlockEntityRenderState)state, partialTick, cameraPos, crumblingOverlay);
        state.disguiseRenderState = ClientHandler.DISGUISED_BLOCK_RENDER_DELEGATE.tryExtractFromDelegate(be, partialTick, cameraPos, crumblingOverlay);
        state.projectedBlockEntityRenderState = ClientHandler.PROJECTOR_RENDER_DELEGATE.tryExtractFromDelegate(be, partialTick, cameraPos, crumblingOverlay);
        ArrayList<ProjectionInfo> renderPositions = new ArrayList<ProjectionInfo>();
        if (be.isActive() && !be.isEmpty()) {
            Level level = be.getLevel();
            BlockPos pos = be.getBlockPos();
            boolean hanging = (Boolean)be.getBlockState().getValue((Property)ProjectorBlock.HANGING);
            Direction direction = (Direction)be.getBlockState().getValue(ProjectorBlock.FACING);
            int projectionHeight = be.getProjectionHeight();
            int projectionRange = be.getProjectionRange();
            int projectionOffset = be.getProjectionOffset();
            for (int x = 0; x < be.getProjectionWidth(); ++x) {
                int y = 0;
                while (this.yLoopBoundary.test((Object)projectionHeight, (Object)hanging, (Object)y)) {
                    Vec3i positionalOffset = !be.isHorizontal() ? this.getPositionalOffset(direction, x, y, projectionRange, projectionOffset) : this.getPositionalOffset(direction, x, projectionRange - 16, y + 1, projectionOffset);
                    BlockPos renderPos = be.getBlockPos().offset(positionalOffset);
                    if (positionalOffset != null && (be.isOverridingBlocks() || level.isEmptyBlock(renderPos))) {
                        BlockPos projectionPos;
                        MovingBlockRenderState movingBlockRenderState = new MovingBlockRenderState();
                        movingBlockRenderState.randomSeedPos = projectionPos = pos.offset(positionalOffset);
                        movingBlockRenderState.blockPos = projectionPos;
                        movingBlockRenderState.blockState = be.getProjectedState();
                        movingBlockRenderState.biome = level.getBiome(projectionPos);
                        movingBlockRenderState.level = level;
                        renderPositions.add(new ProjectionInfo(positionalOffset, movingBlockRenderState));
                    }
                    y = hanging ? y - 1 : y + 1;
                }
            }
        }
        state.renderPositions = renderPositions;
    }

    private Vec3i getPositionalOffset(Direction direction, int x, int y, double originalDistance, double originalOffset) {
        int distance = Mth.floor((double)originalDistance);
        int offset = Mth.floor((double)originalOffset);
        return switch (direction) {
            case Direction.NORTH -> new Vec3i(x + offset, y, distance);
            case Direction.SOUTH -> new Vec3i(x + offset, y, -distance);
            case Direction.WEST -> new Vec3i(distance, y, x + offset);
            case Direction.EAST -> new Vec3i(-distance, y, x + offset);
            default -> null;
        };
    }

    public boolean shouldRenderOffScreen() {
        return true;
    }

    public AABB getRenderBoundingBox(ProjectorBlockEntity be) {
        return new AABB(be.getBlockPos()).inflate(100.0);
    }

    public record ProjectionInfo(Vec3i positionalOffset, MovingBlockRenderState movingBlockRenderState) {
    }
}

