/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.platform.InputConstants;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.components.NamedPositions;
import net.geforcemods.securitycraft.misc.CameraRedstoneModuleState;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.screen.components.SmallButton;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.Identifier;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class CameraSelectScreen
extends Screen {
    private static final Identifier TEXTURE = SecurityCraft.resLoc("textures/gui/container/blank.png");
    private final List<NamedPositions.Entry> cameras;
    protected final boolean readOnly;
    private final Button[] cameraButtons = new Button[10];
    private final CameraRedstoneModuleState[] redstoneModuleStates = new CameraRedstoneModuleState[10];
    private int xSize = 176;
    private int ySize = 166;
    private int leftPos;
    private int topPos;
    private int page;

    public CameraSelectScreen(List<NamedPositions.Entry> cameras, boolean readOnly) {
        this(cameras, readOnly, 1);
    }

    public CameraSelectScreen(List<NamedPositions.Entry> cameras, boolean readOnly, int page) {
        super((Component)Utils.localize("gui.securitycraft:monitor.selectCameras", new Object[0]));
        this.cameras = cameras;
        this.readOnly = readOnly;
        this.page = page;
    }

    public void init() {
        super.init();
        this.leftPos = (this.width - this.xSize) / 2;
        this.topPos = (this.height - this.ySize) / 2;
        Button prevPageButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"<"), b -> {
            --this.page;
            this.rebuildWidgets();
        }).pos(this.width / 2 - 25, this.height / 2 + 57).size(20, 20).build());
        Button nextPageButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)">"), b -> {
            ++this.page;
            this.rebuildWidgets();
        }).pos(this.width / 2 + 5, this.height / 2 + 57).size(20, 20).build());
        ClientLevel level = Minecraft.getInstance().level;
        LocalPlayer player = Minecraft.getInstance().player;
        for (int i = 0; i < 10; ++i) {
            int buttonId = i + 1;
            int camID = buttonId + (this.page - 1) * 10;
            int x = this.leftPos + 18 + i % 5 * 30;
            int y = this.topPos + 30 + i / 5 * 55;
            int aboveCameraButton = y - 8;
            NamedPositions.Entry view = this.cameras.get(camID - 1);
            Button cameraButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.empty(), button -> this.cameraButtonClicked(button, view.globalPos())).pos(x, y).size(20, 20).build());
            if (!this.readOnly) {
                ((SmallButton)this.addRenderableWidget((GuiEventListener)SmallButton.createWithX((int)(x + 19), (int)aboveCameraButton, (Button.OnPress)(Button.OnPress)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/components/Button;)V, lambda$init$3(net.geforcemods.securitycraft.components.NamedPositions$Entry int net.minecraft.client.gui.components.Button ), (Lnet/minecraft/client/gui/components/Button;)V)((CameraSelectScreen)this, (NamedPositions.Entry)view, (int)camID)))).active = view != null;
            }
            this.cameraButtons[i] = cameraButton;
            cameraButton.setMessage((Component)cameraButton.getMessage().plainCopy().append((Component)Component.literal((String)("" + camID))));
            this.redstoneModuleStates[i] = null;
            if (view != null) {
                SecurityCameraBlockEntity cameraEntity;
                GlobalPos globalPos = view.globalPos();
                BlockPos pos = globalPos.pos();
                BlockEntity blockEntity = level.getBlockEntity(pos);
                SecurityCameraBlockEntity cameraBe = blockEntity instanceof SecurityCameraBlockEntity ? (cameraEntity = (SecurityCameraBlockEntity)blockEntity) : null;
                String cameraName = view.name().orElse(null);
                if (cameraBe != null) {
                    BlockState state = level.getBlockState(pos);
                    if (cameraBe.isDisabled() || cameraBe.isShutDown()) {
                        cameraButton.setTooltip(Tooltip.create((Component)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0])));
                        cameraButton.active = false;
                    } else if (cameraName == null && cameraBe.hasCustomName()) {
                        cameraName = cameraBe.getCustomName().getString();
                    }
                    this.redstoneModuleStates[i] = state.getSignal((BlockGetter)level, pos, (Direction)state.getValue(SecurityCameraBlock.FACING)) == 0 ? (!cameraBe.isModuleEnabled(ModuleType.REDSTONE) ? CameraRedstoneModuleState.NOT_INSTALLED : CameraRedstoneModuleState.DEACTIVATED) : CameraRedstoneModuleState.ACTIVATED;
                }
                if (cameraButton.active && cameraName != null) {
                    cameraButton.setTooltip(Tooltip.create((Component)Utils.localize("gui.securitycraft:monitor.cameraName", cameraName)));
                }
                if (!player.isCreative()) continue;
                Button tpButton = (Button)this.addRenderableWidget((GuiEventListener)SmallButton.create(x, aboveCameraButton, (Component)Component.empty(), b -> {
                    player.connection.sendCommand(String.format("execute in %s run tp %s %s %s", globalPos.dimension().identifier(), pos.getX(), pos.getY(), pos.getZ()));
                    this.minecraft.setScreen(null);
                }));
                tpButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"chat.coordinates.tooltip")));
                continue;
            }
            cameraButton.active = false;
        }
        prevPageButton.active = this.page != 1;
        nextPageButton.active = this.page != 3;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        for (int i = 0; i < 10; ++i) {
            Button button = this.cameraButtons[i];
            CameraRedstoneModuleState redstoneModuleState = this.redstoneModuleStates[i];
            if (redstoneModuleState == null) continue;
            redstoneModuleState.render(guiGraphics, button.getX() + 4, button.getY() + 25);
        }
        guiGraphics.drawString(this.font, this.title, this.leftPos + this.xSize / 2 - this.font.width((FormattedText)this.title) / 2, this.topPos + 6, -12566464, false);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderTransparentBackground(guiGraphics);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.xSize, this.ySize, 256, 256);
    }

    private void cameraButtonClicked(Button button, GlobalPos camera) {
        if (camera != null) {
            SecurityCameraBlockEntity cameraEntity;
            BlockEntity blockEntity = this.minecraft.level.getBlockEntity(camera.pos());
            if (blockEntity instanceof SecurityCameraBlockEntity && ((cameraEntity = (SecurityCameraBlockEntity)blockEntity).isDisabled() || cameraEntity.isShutDown())) {
                button.active = false;
                return;
            }
            this.viewCamera(camera);
        }
    }

    protected void viewCamera(GlobalPos cameraPos) {
        Minecraft.getInstance().player.closeContainer();
    }

    private void unbindButtonClicked(Button button, GlobalPos camera, int camID) {
        if (camera != null) {
            int i = (camID - 1) % 10;
            Button cameraButton = this.cameraButtons[i];
            this.unbindCamera(camera);
            button.active = false;
            cameraButton.active = false;
            cameraButton.setTooltip(null);
            this.redstoneModuleStates[i] = null;
        }
    }

    protected void unbindCamera(GlobalPos cameraPos) {
    }

    public boolean keyPressed(KeyEvent event) {
        if (this.minecraft.options.keyInventory.isActiveAndMatches(InputConstants.getKey((KeyEvent)event))) {
            this.onClose();
            return true;
        }
        return super.keyPressed(event);
    }

    public boolean isPauseScreen() {
        return false;
    }

    private /* synthetic */ void lambda$init$3(NamedPositions.Entry view, int camID, Button button) {
        this.unbindButtonClicked(button, view.globalPos(), camID);
    }
}

