/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.IntFunction;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.components.ListModuleData;
import net.geforcemods.securitycraft.network.server.SetListModuleData;
import net.geforcemods.securitycraft.screen.components.CallbackCheckbox;
import net.geforcemods.securitycraft.screen.components.ToggleComponentButton;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.scores.PlayerTeam;
import net.neoforged.neoforge.client.gui.widget.ScrollPanel;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;

public class EditModuleScreen
extends Screen {
    private static ListModuleData savedData;
    private static final Identifier TEXTURE;
    private static final Identifier CONFIRM_SPRITE;
    private static final Identifier CANCEL_SPRITE;
    private final Component editModule = Utils.localize("gui.securitycraft:editModule", new Object[0]);
    private final ItemStack module;
    private final List<PlayerTeam> availableTeams;
    private final Map<PlayerTeam, Boolean> teamsListedStatus = new HashMap<PlayerTeam, Boolean>();
    private EditBox inputField;
    private Button addPlayerButton;
    private Button removePlayerButton;
    private Button copyButton;
    private Button pasteButton;
    private Button clearButton;
    private CallbackCheckbox affectEveryPlayerCheckbox;
    private int xSize = 247;
    private int ySize = 211;
    private int leftPos;
    private int topPos;
    private PlayerList playerList;
    private TeamList teamList;

    public EditModuleScreen(ItemStack item) {
        super(item.getItemName());
        this.availableTeams = new ArrayList<PlayerTeam>(Minecraft.getInstance().level.getScoreboard().getPlayerTeams());
        this.module = item;
    }

    public void init() {
        super.init();
        this.leftPos = (this.width - this.xSize) / 2;
        this.topPos = (this.height - this.ySize) / 2;
        int guiLeft = (this.width - this.xSize) / 2;
        int guiTop = (this.height - this.ySize) / 2;
        int controlsStartX = (int)((float)guiLeft + (float)this.xSize * 0.75f) - 57;
        int controlsWidth = 107;
        MutableComponent checkboxText = Utils.localize("gui.securitycraft:editModule.affectEveryone", new Object[0]);
        int length = this.font.width((FormattedText)checkboxText) + 24;
        this.inputField = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.font, controlsStartX, this.height / 2 - 88, 107, 15, (Component)Component.empty()){

            public boolean keyPressed(KeyEvent event) {
                int keyCode = event.key();
                if (this.isFocused() && (keyCode == 257 || keyCode == 335)) {
                    EditModuleScreen.this.addPlayerButtonClicked(EditModuleScreen.this.addPlayerButton);
                    return true;
                }
                return super.keyPressed(event);
            }
        });
        this.addPlayerButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Utils.localize("gui.securitycraft:editModule.add_player", new Object[0]), this::addPlayerButtonClicked).pos(controlsStartX, this.height / 2 - 68).size(controlsWidth, 20).build());
        this.removePlayerButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Utils.localize("gui.securitycraft:editModule.remove_player", new Object[0]), this::removePlayerButtonClicked).pos(controlsStartX, this.height / 2 - 43).size(controlsWidth, 20).build());
        Button editTeamsButton = (Button)this.addRenderableWidget((GuiEventListener)new NonScrollableToggleComponentButton(this, controlsStartX, this.height / 2 - 18, controlsWidth, 20, i -> Utils.localize("gui.securitycraft:editModule.edit_teams", new Object[0]), 0, 2, this::editTeamsButtonClicked));
        this.copyButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Utils.localize("gui.securitycraft:editModule.copy", new Object[0]), this::copyButtonClicked).pos(controlsStartX, this.height / 2 + 7).size(controlsWidth, 20).build());
        this.pasteButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Utils.localize("gui.securitycraft:editModule.paste", new Object[0]), this::pasteButtonClicked).pos(controlsStartX, this.height / 2 + 32).size(controlsWidth, 20).build());
        this.clearButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Utils.localize("gui.securitycraft:editModule.clear", new Object[0]), this::clearButtonClicked).pos(controlsStartX, this.height / 2 + 57).size(controlsWidth, 20).build());
        this.playerList = (PlayerList)this.addRenderableWidget((GuiEventListener)new PlayerList(this.minecraft, 110, 165, this.height / 2 - 88, guiLeft + 10));
        this.teamList = (TeamList)this.addRenderableWidget((GuiEventListener)new TeamList(this.minecraft, editTeamsButton.getWidth(), 75, editTeamsButton.getY() + editTeamsButton.getHeight(), editTeamsButton.getX()));
        this.affectEveryPlayerCheckbox = (CallbackCheckbox)this.addRenderableWidget((GuiEventListener)new CallbackCheckbox(guiLeft + this.xSize / 2 - length / 2, guiTop + this.ySize - 25, 20, 20, (Component)checkboxText, ((ListModuleData)this.module.getOrDefault(SCContent.LIST_MODULE_DATA, (Object)ListModuleData.EMPTY)).affectEveryone(), newState -> ((ListModuleData)this.module.getOrDefault(SCContent.LIST_MODULE_DATA, (Object)ListModuleData.EMPTY)).updateAffectEveryone(this.module, (boolean)newState), -12566464));
        this.teamList.active = false;
        editTeamsButton.active = !this.availableTeams.isEmpty();
        this.refreshFromComponent();
        this.updateButtonStates();
        this.inputField.setMaxLength(16);
        this.inputField.setFilter(s -> !s.contains(" "));
        this.inputField.setResponder(s -> {
            if (s.isEmpty()) {
                this.addPlayerButton.active = false;
            } else {
                ListModuleData listModuleData = (ListModuleData)this.module.get(SCContent.LIST_MODULE_DATA);
                if (listModuleData != null && listModuleData.isPlayerOnList((String)s)) {
                    this.addPlayerButton.active = false;
                    this.removePlayerButton.active = true;
                    this.playerList.setSelectedIndex(listModuleData.players().indexOf(s));
                    return;
                }
                this.addPlayerButton.active = true;
            }
            this.removePlayerButton.active = false;
            this.playerList.setSelectedIndex(-1);
        });
        this.setInitialFocus((GuiEventListener)this.inputField);
    }

    public void onClose() {
        super.onClose();
        ClientPacketDistributor.sendToServer((CustomPacketPayload)new SetListModuleData((ListModuleData)this.module.getOrDefault(SCContent.LIST_MODULE_DATA, (Object)ListModuleData.EMPTY)), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.drawWordWrap(this.font, (FormattedText)this.editModule, this.leftPos + this.xSize / 2 - this.font.width((FormattedText)this.editModule) / 2, this.topPos + 6, this.width, -12566464, false);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderTransparentBackground(guiGraphics);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.xSize, this.ySize, 256, 256);
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
        if (this.playerList != null) {
            this.playerList.mouseClicked(event, doubleClick);
        }
        return super.mouseClicked(event, doubleClick);
    }

    public boolean mouseReleased(MouseButtonEvent event) {
        if (this.playerList != null) {
            this.playerList.mouseReleased(event);
        }
        if (this.teamList != null) {
            this.teamList.mouseReleased(event);
        }
        return super.mouseReleased(event);
    }

    public boolean keyPressed(KeyEvent event) {
        if (!this.inputField.isFocused() && this.minecraft.options.keyInventory.isActiveAndMatches(InputConstants.getKey((KeyEvent)event))) {
            this.onClose();
            return true;
        }
        return super.keyPressed(event);
    }

    public boolean isPauseScreen() {
        return false;
    }

    private void addPlayerButtonClicked(Button button) {
        if (this.inputField.getValue().isEmpty()) {
            return;
        }
        ListModuleData listModuleData = (ListModuleData)this.module.getOrDefault(SCContent.LIST_MODULE_DATA, (Object)ListModuleData.EMPTY);
        if ((listModuleData = listModuleData.addPlayer(this.module, this.inputField.getValue())).players().size() == 50) {
            this.addPlayerButton.active = false;
        }
        this.inputField.setValue("");
        this.updateButtonStates();
    }

    private void editTeamsButtonClicked(Button button) {
        boolean buttonState;
        this.pasteButton.visible = this.clearButton.visible = (buttonState = ((ToggleComponentButton)button).getCurrentIndex() == 0);
        this.copyButton.visible = this.clearButton.visible;
        this.teamList.active = !buttonState;
    }

    private void removePlayerButtonClicked(Button button) {
        if (this.inputField.getValue().isEmpty()) {
            return;
        }
        ((ListModuleData)this.module.getOrDefault(SCContent.LIST_MODULE_DATA, (Object)ListModuleData.EMPTY)).removePlayer(this.module, this.inputField.getValue());
        this.inputField.setValue("");
        this.updateButtonStates();
    }

    private void copyButtonClicked(Button button) {
        savedData = (ListModuleData)this.module.get(SCContent.LIST_MODULE_DATA);
        this.copyButton.active = false;
        this.updateButtonStates();
    }

    private void pasteButtonClicked(Button button) {
        if (savedData != null) {
            this.module.set(SCContent.LIST_MODULE_DATA, (Object)new ListModuleData((List<String>)ImmutableList.copyOf(savedData.players()), (List<String>)ImmutableList.copyOf(savedData.teams()), savedData.affectEveryone()));
            this.updateButtonStates();
            this.refreshFromComponent();
        }
    }

    private void clearButtonClicked(Button button) {
        this.module.set(SCContent.LIST_MODULE_DATA, (Object)ListModuleData.EMPTY);
        this.inputField.setValue("");
        this.updateButtonStates(true);
        this.refreshFromComponent();
    }

    private void updateButtonStates() {
        this.updateButtonStates(false);
    }

    private void updateButtonStates(boolean cleared) {
        boolean hasNoData;
        ListModuleData listModuleData = (ListModuleData)this.module.getOrDefault(SCContent.LIST_MODULE_DATA, (Object)ListModuleData.EMPTY);
        boolean bl = hasNoData = listModuleData.equals(ListModuleData.EMPTY) || listModuleData.affectEveryone() && listModuleData.players().isEmpty() && listModuleData.teams().isEmpty();
        if (!cleared && hasNoData) {
            this.addPlayerButton.active = false;
            this.removePlayerButton.active = false;
        } else {
            this.addPlayerButton.active = listModuleData.players().size() < 50 && !this.inputField.getValue().isEmpty();
            this.removePlayerButton.active = !this.inputField.getValue().isEmpty();
        }
        boolean isSameTag = !hasNoData && listModuleData.equals(savedData);
        this.copyButton.active = !isSameTag;
        this.pasteButton.active = savedData != null && !savedData.equals(ListModuleData.EMPTY) && !isSameTag;
        this.clearButton.active = !hasNoData;
    }

    private void refreshFromComponent() {
        ListModuleData listModuleData = (ListModuleData)this.module.get(SCContent.LIST_MODULE_DATA);
        if (listModuleData == null || listModuleData.equals(ListModuleData.EMPTY)) {
            this.availableTeams.forEach(team -> this.teamsListedStatus.put((PlayerTeam)team, false));
            this.affectEveryPlayerCheckbox.setSelected(false);
        } else {
            this.availableTeams.forEach(team -> this.teamsListedStatus.put((PlayerTeam)team, listModuleData.teams().contains(team.getName())));
            this.affectEveryPlayerCheckbox.setSelected(listModuleData.affectEveryone());
        }
    }

    private void renderBox(GuiGraphics guiGraphics, int min, int max, int slotTop, int slotBuffer, int borderColor) {
        guiGraphics.fill(min, slotTop - 2, max, slotTop + slotBuffer + 2, borderColor);
        guiGraphics.fill(min + 1, slotTop - 1, max - 1, slotTop + slotBuffer + 1, -16777216);
    }

    static {
        TEXTURE = SecurityCraft.resLoc("textures/gui/container/edit_module.png");
        CONFIRM_SPRITE = SecurityCraft.mcResLoc("container/beacon/confirm");
        CANCEL_SPRITE = SecurityCraft.mcResLoc("container/beacon/cancel");
    }

    class NonScrollableToggleComponentButton
    extends ToggleComponentButton {
        public NonScrollableToggleComponentButton(EditModuleScreen this$0, int xPos, int yPos, int width, int height, IntFunction<Component> onValueChange, int initialValue, int toggleCount, Button.OnPress onPress) {
            super(xPos, yPos, width, height, onValueChange, initialValue, toggleCount, onPress);
        }

        @Override
        public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
            return false;
        }
    }

    class PlayerList
    extends ScrollPanel {
        private static final int SLOT_HEIGHT = 12;
        private static final int LIST_LENGTH = 50;
        private int selectedIndex;

        public PlayerList(Minecraft client, int width, int height, int top, int left) {
            super(client, width, height, top, left);
            this.selectedIndex = -1;
        }

        protected int getContentHeight() {
            Objects.requireNonNull(EditModuleScreen.this.font);
            int height = 50 * (9 + 3);
            if (height < this.bottom - this.top - 4) {
                height = this.bottom - this.top - 4;
            }
            return height;
        }

        public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
            ListModuleData listModuleData;
            int clickedIndex;
            double mouseY;
            double mouseX = event.x();
            if (this.isMouseOver(mouseX, mouseY = event.y()) && mouseX < (double)(this.left + this.width - 6) && (clickedIndex = (int)(mouseY - (double)this.top + (double)this.scrollDistance - (double)this.border) / 12) < (listModuleData = (ListModuleData)EditModuleScreen.this.module.getOrDefault(SCContent.LIST_MODULE_DATA, (Object)ListModuleData.EMPTY)).players().size()) {
                this.selectedIndex = clickedIndex;
                EditModuleScreen.this.inputField.setValue(listModuleData.players().get(clickedIndex));
            }
            return super.mouseClicked(event, doubleClick);
        }

        protected void drawBackground(GuiGraphics guiGraphics, float partialTick) {
            this.drawGradientRect(guiGraphics, this.left, this.top, this.right, this.bottom, -1072689136, -804253680);
        }

        protected void drawPanel(GuiGraphics guiGraphics, int entryRight, int relativeY, int mouseX, int mouseY) {
            ListModuleData listModuleData = (ListModuleData)EditModuleScreen.this.module.get(SCContent.LIST_MODULE_DATA);
            if (listModuleData != null) {
                int baseY = this.top + this.border - (int)this.scrollDistance;
                int mouseListY = (int)((float)(mouseY - this.top) + this.scrollDistance - (float)this.border);
                int slotIndex = mouseListY / 12;
                List<String> players = listModuleData.players();
                if (slotIndex != this.selectedIndex && mouseX >= this.left && mouseX < this.right - 6 && slotIndex >= 0 && mouseListY >= 0 && slotIndex < 50 && mouseY >= this.top && mouseY <= this.bottom && slotIndex < players.size() && !players.get(slotIndex).isBlank()) {
                    EditModuleScreen.this.renderBox(guiGraphics, this.left, entryRight - 6, baseY + slotIndex * 12, 8, -8355712);
                }
                if (this.selectedIndex >= 0) {
                    EditModuleScreen.this.renderBox(guiGraphics, this.left, entryRight - 6, baseY + this.selectedIndex * 12, 8, -1);
                }
                for (int i = 0; i < players.size(); ++i) {
                    String name = players.get(i);
                    if (name.isEmpty()) continue;
                    guiGraphics.drawString(EditModuleScreen.this.font, name, this.left - 2 + this.width / 2 - EditModuleScreen.this.font.width(name) / 2, relativeY + 12 * i, -3750202, false);
                }
            }
        }

        public void setSelectedIndex(int selectedIndex) {
            this.selectedIndex = selectedIndex;
        }

        public NarratableEntry.NarrationPriority narrationPriority() {
            return NarratableEntry.NarrationPriority.NONE;
        }

        public void updateNarration(NarrationElementOutput narrationElementOutput) {
        }
    }

    class TeamList
    extends ScrollPanel {
        private static final int SLOT_HEIGHT = 12;
        private final int listLength;
        private int selectedIndex;
        private boolean active;

        public TeamList(Minecraft client, int width, int height, int top, int left) {
            super(client, width, height, top, left);
            this.selectedIndex = -1;
            this.active = true;
            this.listLength = EditModuleScreen.this.availableTeams.size();
        }

        protected int getContentHeight() {
            Objects.requireNonNull(EditModuleScreen.this.font);
            int height = this.listLength * (9 + 3);
            if (height < this.bottom - this.top - 4) {
                height = this.bottom - this.top - 4;
            }
            return height;
        }

        protected boolean clickPanel(double mouseX, double mouseY, MouseButtonEvent event) {
            int slotIndex;
            if (this.active && (slotIndex = (int)(mouseY + (double)(this.border / 2)) / 12) >= 0 && slotIndex < this.listLength) {
                Minecraft mc = Minecraft.getInstance();
                double relativeMouseY = mc.mouseHandler.ypos() * (double)mc.getWindow().getGuiScaledHeight() / (double)mc.getWindow().getScreenHeight();
                if (relativeMouseY >= (double)this.top && relativeMouseY <= (double)this.bottom) {
                    this.toggleTeam(EditModuleScreen.this.availableTeams.get(slotIndex));
                    EditModuleScreen.this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                    return true;
                }
            }
            return false;
        }

        protected void drawBackground(GuiGraphics guiGraphics, float partialTick) {
            this.drawGradientRect(guiGraphics, this.left, this.top, this.right, this.bottom, -1072689136, -804253680);
        }

        public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            if (this.active) {
                super.render(guiGraphics, mouseX, mouseY, partialTick);
                int mouseListY = (int)((float)(mouseY - this.top) + this.scrollDistance - (float)(this.border / 2));
                int slotIndex = mouseListY / 12;
                if (slotIndex >= 0 && slotIndex < this.listLength && mouseX >= this.left && mouseX < this.right - 6 && mouseListY >= 0 && mouseY >= this.top && mouseY <= this.bottom) {
                    Component name = EditModuleScreen.this.availableTeams.get(slotIndex).getDisplayName();
                    int length = EditModuleScreen.this.font.width((FormattedText)name);
                    int baseY = this.top + this.border - (int)this.scrollDistance;
                    if (length >= this.width - 6) {
                        guiGraphics.setTooltipForNextFrame(EditModuleScreen.this.font, name, this.left + 3, baseY + (12 * slotIndex + 12));
                    }
                }
            }
        }

        protected void drawPanel(GuiGraphics guiGraphics, int entryRight, int relativeY, int mouseX, int mouseY) {
            int baseY = this.top + this.border - (int)this.scrollDistance;
            int mouseListY = (int)((float)(mouseY - this.top) + this.scrollDistance - (float)(this.border / 2));
            int slotIndex = mouseListY / 12;
            if (slotIndex != this.selectedIndex && mouseX >= this.left && mouseX < this.right - 6 && slotIndex >= 0 && mouseListY >= 0 && slotIndex < this.listLength && mouseY >= this.top && mouseY <= this.bottom) {
                EditModuleScreen.this.renderBox(guiGraphics, this.left, entryRight - 6, baseY + slotIndex * 12, 8, -8355712);
            }
            for (int i = 0; i < this.listLength; ++i) {
                int yStart = relativeY + 12 * i;
                PlayerTeam team = EditModuleScreen.this.availableTeams.get(i);
                guiGraphics.drawString(EditModuleScreen.this.font, team.getDisplayName(), this.left + 15, yStart, -3750202, false);
                guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, EditModuleScreen.this.teamsListedStatus.get(team) != false ? CONFIRM_SPRITE : CANCEL_SPRITE, this.left + 1, yStart - 3, 12, 12);
            }
        }

        private void toggleTeam(PlayerTeam teamToToggle) {
            EditModuleScreen.this.teamsListedStatus.put(teamToToggle, EditModuleScreen.this.teamsListedStatus.get(teamToToggle) == false);
            ((ListModuleData)EditModuleScreen.this.module.getOrDefault(SCContent.LIST_MODULE_DATA, (Object)ListModuleData.EMPTY)).toggleTeam(EditModuleScreen.this.module, teamToToggle.getName());
            EditModuleScreen.this.updateButtonStates();
        }

        public NarratableEntry.NarrationPriority narrationPriority() {
            return NarratableEntry.NarrationPriority.NONE;
        }

        public void updateNarration(NarrationElementOutput narrationElementOutput) {
        }
    }
}

