/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.ICustomizable;
import net.geforcemods.securitycraft.api.IExplosive;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasscodeProtected;
import net.geforcemods.securitycraft.api.IViewActivated;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedHopperBlock;
import net.geforcemods.securitycraft.items.SCManualItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.PageGroup;
import net.geforcemods.securitycraft.misc.SCManualPage;
import net.geforcemods.securitycraft.screen.components.HoverChecker;
import net.geforcemods.securitycraft.screen.components.ItemStacksDisplay;
import net.geforcemods.securitycraft.screen.components.TextHoverChecker;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.Identifier;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Util;
import net.minecraft.util.context.ContextMap;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.ShapedCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.ShapelessCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplayContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.gui.widget.ScrollPanel;

public class SCManualScreen
extends Screen {
    private static final Identifier PAGE = SecurityCraft.resLoc("textures/gui/info_book_texture.png");
    private static final Identifier PAGE_WITH_SCROLL = SecurityCraft.resLoc("textures/gui/info_book_texture_special.png");
    private static final Identifier TITLE_PAGE = SecurityCraft.resLoc("textures/gui/info_book_title_page.png");
    private static final Identifier OWNABLE_SPRITE = SecurityCraft.resLoc("sc_manual/ownable");
    private static final Identifier OWNABLE_HIGHLIGHTED_SPRITE = SecurityCraft.resLoc("sc_manual/ownable_highlighted");
    private static final Identifier PASSCODE_PROTECTED_SPRITE = SecurityCraft.resLoc("sc_manual/passcode_protected");
    private static final Identifier PASSCODE_PROTECTED_HIGHLIGHTED_SPRITE = SecurityCraft.resLoc("sc_manual/passcode_protected_highlighted");
    private static final Identifier VIEW_ACTIVATED_SPRITE = SecurityCraft.resLoc("sc_manual/view_activated");
    private static final Identifier VIEW_ACTIVATED_HIGHLIGHTED_SPRITE = SecurityCraft.resLoc("sc_manual/view_activated_highlighted");
    private static final Identifier EXPLOSIVE_SPRITE = SecurityCraft.resLoc("sc_manual/explosive");
    private static final Identifier EXPLOSIVE_HIGHLIGHTED_SPRITE = SecurityCraft.resLoc("sc_manual/explosive_highlighted");
    private static final Identifier HAS_OPTIONS_SPRITE = SecurityCraft.resLoc("sc_manual/has_options");
    private static final Identifier HAS_OPTIONS_HIGHLIGHTED_SPRITE = SecurityCraft.resLoc("sc_manual/has_options_highlighted");
    private static final Identifier HAS_MODULES_SPRITE = SecurityCraft.resLoc("sc_manual/has_modules");
    private static final Identifier HAS_MODULES_HIGHLIGHTED_SPRITE = SecurityCraft.resLoc("sc_manual/has_modules_highlighted");
    private static final Identifier LOCKABLE_SPRITE = SecurityCraft.resLoc("sc_manual/lockable");
    private static final Identifier LOCKABLE_HIGHLIGHTED_SPRITE = SecurityCraft.resLoc("sc_manual/lockable_highlighted");
    private static final Identifier CUSTOMIZABLE_SPRITE = SecurityCraft.resLoc("sc_manual/customizable");
    private static final Identifier CUSTOMIZABLE_HIGHLIGHTED_SPRITE = SecurityCraft.resLoc("sc_manual/customizable_highlighted");
    private static final Identifier LINK_OUT_HIGHLIGHTED_SPRITE = SecurityCraft.resLoc("sc_manual/link_out_highlighted");
    private static final Identifier LINK_OUT_SPRITE = SecurityCraft.resLoc("sc_manual/link_out");
    private static final Identifier PAGE_FORWARD_HIGHLIGHTED_SPRITE = SecurityCraft.mcResLoc("widget/page_forward_highlighted");
    private static final Identifier PAGE_FORWARD_SPRITE = SecurityCraft.mcResLoc("widget/page_forward");
    private static final Identifier PAGE_BACKWARD_HIGHLIGHTED_SPRITE = SecurityCraft.mcResLoc("widget/page_backward_highlighted");
    private static final Identifier PAGE_BACKWARD_SPRITE = SecurityCraft.mcResLoc("widget/page_backward");
    private static final int SUBPAGE_LENGTH = 1285;
    private final MutableComponent intro1 = Utils.localize("gui.securitycraft:scManual.intro.1", new Object[0]).setStyle(Style.EMPTY.withUnderlined(Boolean.valueOf(true)));
    private final Component ourPatrons = Utils.localize("gui.securitycraft:scManual.patreon.title", new Object[0]);
    private List<HoverChecker> hoverCheckers = new ArrayList<HoverChecker>();
    private int currentPage = SCManualItem.lastOpenPage;
    private List<SlotDisplay> recipe;
    private ItemStacksDisplay[] displays = new ItemStacksDisplay[9];
    private int startX = -1;
    private List<FormattedText> subpages = new ArrayList<FormattedText>();
    private List<FormattedCharSequence> author = new ArrayList<FormattedCharSequence>();
    private int currentSubpage = 0;
    private List<FormattedCharSequence> intro2;
    private PatronList patronList;
    private Button patreonLinkButton;
    private Button nextSubpage;
    private Button previousSubpage;
    private boolean explosive;
    private boolean ownable;
    private boolean passcodeProtected;
    private boolean viewActivated;
    private boolean hasOptions;
    private boolean lockable;
    private boolean hasModules;
    private ItemStacksDisplay pageIcon;
    private Component pageTitle;
    private Component designedBy;

    public SCManualScreen() {
        super((Component)Component.translatable((String)((SCManualItem)((Object)SCContent.SC_MANUAL.get())).getDescriptionId()));
    }

    public void init() {
        int startY = 2;
        this.startX = (this.width - 256) / 2;
        this.patreonLinkButton = (Button)this.addRenderableWidget((GuiEventListener)new HyperlinkButton(this.startX + 225, 143, 16, 16, (Component)Component.empty(), b -> {
            try {
                SCManualScreen.clickUrlAction((Minecraft)this.minecraft, (Screen)this, (URI)new URI("https://www.patreon.com/Geforce"));
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }));
        this.patronList = (PatronList)this.addRenderableWidget((GuiEventListener)new PatronList(this.minecraft, 115, 90, 50, this.startX + 125));
        this.previousSubpage = (Button)this.addRenderableWidget((GuiEventListener)new ChangePageButton(this.startX + 155, startY + 95, PAGE_BACKWARD_SPRITE, PAGE_BACKWARD_HIGHLIGHTED_SPRITE, b -> this.previousSubpage()));
        this.nextSubpage = (Button)this.addRenderableWidget((GuiEventListener)new ChangePageButton(this.startX + 180, startY + 95, PAGE_FORWARD_SPRITE, PAGE_FORWARD_HIGHLIGHTED_SPRITE, b -> this.nextSubpage()));
        this.addRenderableWidget((GuiEventListener)new ChangePageButton(this.startX + 22, startY + 188, PAGE_BACKWARD_SPRITE, PAGE_BACKWARD_HIGHLIGHTED_SPRITE, b -> this.previousPage()));
        this.addRenderableWidget((GuiEventListener)new ChangePageButton(this.startX + 210, startY + 188, PAGE_FORWARD_SPRITE, PAGE_FORWARD_HIGHLIGHTED_SPRITE, b -> this.nextPage()));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.displays[i * 3 + j] = (ItemStacksDisplay)this.addRenderableOnly(new ItemStacksDisplay(this.startX + 101 + j * 19, 145 + i * 19));
            }
        }
        this.pageIcon = (ItemStacksDisplay)this.addRenderableOnly(new ItemStacksDisplay(this.startX + 19, 22));
        this.updateRecipeAndIcons();
        SCManualItem.PAGES.sort((page1, page2) -> {
            String key1 = page1.title().getString();
            String key2 = page2.title().getString();
            return key1.compareTo(key2);
        });
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderTransparentBackground(guiGraphics);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.currentPage == -1 ? TITLE_PAGE : (this.recipe != null && !this.recipe.isEmpty() ? PAGE : PAGE_WITH_SCROLL), this.startX, 5, 0.0f, 0.0f, 256, 250, 256, 256);
        for (Renderable renderable : this.renderables) {
            renderable.render(guiGraphics, mouseX, mouseY, partialTicks);
        }
        if (this.currentPage > -1) {
            pageNumberText = this.currentPage + 2 + "/" + (SCManualItem.PAGES.size() + 1);
            if (this.subpages.size() > 1) {
                guiGraphics.drawString(this.font, this.currentSubpage + 1 + "/" + this.subpages.size(), this.startX + 205, 100, -7437712, false);
            }
            if (this.designedBy != null) {
                guiGraphics.drawWordWrap(this.font, (FormattedText)this.designedBy, this.startX + 18, 150, 75, -16777216, false);
            }
            guiGraphics.drawString(this.font, this.pageTitle, this.startX + 39, 27, -16777216, false);
            guiGraphics.drawWordWrap(this.font, this.subpages.get(this.currentSubpage), this.startX + 18, 45, 225, -16777216, false);
            guiGraphics.drawString(this.font, pageNumberText, this.startX + 240 - this.font.width(pageNumberText), 182, -7437712, false);
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, this.ownable ? OWNABLE_HIGHLIGHTED_SPRITE : OWNABLE_SPRITE, this.startX + 29, 118, 16, 16);
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, this.passcodeProtected ? PASSCODE_PROTECTED_HIGHLIGHTED_SPRITE : PASSCODE_PROTECTED_SPRITE, this.startX + 56, 118, 16, 16);
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, this.viewActivated ? VIEW_ACTIVATED_HIGHLIGHTED_SPRITE : VIEW_ACTIVATED_SPRITE, this.startX + 82, 118, 16, 16);
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, this.explosive ? EXPLOSIVE_HIGHLIGHTED_SPRITE : EXPLOSIVE_SPRITE, this.startX + 107, 116, 18, 18);
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, this.hasOptions ? HAS_OPTIONS_HIGHLIGHTED_SPRITE : HAS_OPTIONS_SPRITE, this.startX + 136, 118, 16, 16);
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, this.hasModules ? HAS_MODULES_HIGHLIGHTED_SPRITE : HAS_MODULES_SPRITE, this.startX + 163, 118, 16, 16);
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, this.lockable ? LOCKABLE_HIGHLIGHTED_SPRITE : LOCKABLE_SPRITE, this.startX + 189, 118, 16, 16);
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, this.hasOptions || this.hasModules ? CUSTOMIZABLE_HIGHLIGHTED_SPRITE : CUSTOMIZABLE_SPRITE, this.startX + 213, 117, 16, 16);
            for (int i = 0; i < this.hoverCheckers.size(); ++i) {
                TextHoverChecker thc;
                HoverChecker chc = this.hoverCheckers.get(i);
                if (chc == null || !chc.checkHover(mouseX, mouseY)) continue;
                if (chc instanceof TextHoverChecker && (thc = (TextHoverChecker)chc).getName() != null) {
                    guiGraphics.setComponentTooltipForNextFrame(this.font, thc.getLines(), mouseX, mouseY);
                } else {
                    if (i >= this.displays.length || this.displays[i].getCurrentStack().isEmpty()) continue;
                    guiGraphics.setTooltipForNextFrame(this.font, this.displays[i].getCurrentStack(), mouseX, mouseY);
                }
                break;
            }
        } else {
            FormattedCharSequence text;
            int i;
            pageNumberText = "1/" + (SCManualItem.PAGES.size() + 1);
            guiGraphics.drawString(this.font, (Component)this.intro1, this.width / 2 - this.font.width((FormattedText)this.intro1) / 2, 22, -16777216, false);
            for (i = 0; i < this.intro2.size(); ++i) {
                text = this.intro2.get(i);
                guiGraphics.drawString(this.font, text, this.width / 2 - this.font.width(text) / 2, 150 + 10 * i, -16777216, false);
            }
            for (i = 0; i < this.author.size(); ++i) {
                text = this.author.get(i);
                guiGraphics.drawString(this.font, text, this.width / 2 - this.font.width(text) / 2, 180 + 10 * i, -16777216, false);
            }
            guiGraphics.drawString(this.font, pageNumberText, this.startX + 240 - this.font.width(pageNumberText), 182, -7437712, false);
            guiGraphics.drawString(this.font, this.ourPatrons, this.width / 2 - this.font.width((FormattedText)this.ourPatrons) / 2 + 30, 40, -16777216, false);
        }
    }

    public void tick() {
        super.tick();
        this.pageIcon.tick();
        for (ItemStacksDisplay display : this.displays) {
            display.tick();
        }
    }

    public void removed() {
        super.removed();
        SCManualItem.lastOpenPage = this.currentPage;
    }

    private void hideSubpageButtonsOnMainPage() {
        this.nextSubpage.visible = this.currentPage != -1 && this.subpages.size() > 1;
        this.previousSubpage.visible = this.currentPage != -1 && this.subpages.size() > 1;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (Minecraft.getInstance().hasShiftDown()) {
            for (ItemStacksDisplay display : this.displays) {
                if (display == null) continue;
                display.changeRenderingStack(-scrollY);
            }
            if (this.pageIcon != null) {
                this.pageIcon.changeRenderingStack(-scrollY);
            }
            return true;
        }
        if (this.currentPage == -1 && this.patronList != null && this.patronList.isMouseOver(mouseX, mouseY) && !this.patronList.patrons.isEmpty()) {
            this.patronList.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
            return true;
        }
        if (Minecraft.getInstance().hasControlDown() && this.subpages.size() > 1) {
            switch ((int)Math.signum(scrollY)) {
                case -1: {
                    this.nextSubpage();
                    break;
                }
                case 1: {
                    this.previousSubpage();
                }
            }
            return true;
        }
        switch ((int)Math.signum(scrollY)) {
            case -1: {
                this.nextPage();
                break;
            }
            case 1: {
                this.previousPage();
            }
        }
        this.nextSubpage.visible = this.currentPage != -1 && this.subpages.size() > 1;
        this.previousSubpage.visible = this.currentPage != -1 && this.subpages.size() > 1;
        return true;
    }

    private void nextPage() {
        ++this.currentPage;
        if (this.currentPage > SCManualItem.PAGES.size() - 1) {
            this.currentPage = -1;
        }
        this.updateRecipeAndIcons();
        this.hideSubpageButtonsOnMainPage();
    }

    private void previousPage() {
        --this.currentPage;
        if (this.currentPage < -1) {
            this.currentPage = SCManualItem.PAGES.size() - 1;
        }
        this.updateRecipeAndIcons();
        this.hideSubpageButtonsOnMainPage();
    }

    private void nextSubpage() {
        ++this.currentSubpage;
        if (this.currentSubpage == this.subpages.size()) {
            this.currentSubpage = 0;
        }
    }

    private void previousSubpage() {
        --this.currentSubpage;
        if (this.currentSubpage == -1) {
            this.currentSubpage = this.subpages.size() - 1;
        }
    }

    private void updateRecipeAndIcons() {
        Object inWorldObject;
        this.currentSubpage = 0;
        this.hoverCheckers.clear();
        boolean bl = this.patreonLinkButton.visible = this.currentPage == -1;
        if (this.currentPage < 0) {
            for (ItemStacksDisplay display : this.displays) {
                display.setStacks(null);
            }
            this.pageIcon.setStacks(null);
            this.recipe = null;
            this.nextSubpage.visible = false;
            this.previousSubpage.visible = false;
            if (I18n.exists((String)"gui.securitycraft:scManual.author")) {
                this.author = this.font.split((FormattedText)Utils.localize("gui.securitycraft:scManual.author", new Object[0]), 180);
            } else {
                this.author.clear();
            }
            this.intro2 = this.font.split((FormattedText)Utils.localize("gui.securitycraft:scManual.intro.2", new Object[0]), 202);
            this.patronList.fetchPatrons();
            return;
        }
        SCManualPage page = SCManualItem.PAGES.get(this.currentPage);
        String designerName = page.designedBy();
        Item item = page.item();
        PageGroup pageGroup = page.group();
        this.designedBy = designerName != null && !designerName.isEmpty() ? Utils.localize("gui.securitycraft:scManual.designedBy", designerName) : null;
        this.recipe = null;
        page.recipes().get().ifPresent(displayList -> {
            if (pageGroup == PageGroup.NONE) {
                RecipeDisplay display = (RecipeDisplay)displayList.get(0);
                if (display instanceof ShapedCraftingRecipeDisplay) {
                    ShapedCraftingRecipeDisplay shapedRecipe = (ShapedCraftingRecipeDisplay)display;
                    List ingredients = shapedRecipe.ingredients();
                    List<SlotDisplay> recipeItems = Arrays.asList((SlotDisplay[])Util.make((Object)new SlotDisplay[9], array -> Arrays.fill(array, SlotDisplay.Empty.INSTANCE)));
                    for (int i2 = 0; i2 < ingredients.size(); ++i2) {
                        recipeItems.set(this.getCraftMatrixPosition(i2, shapedRecipe.width(), shapedRecipe.height()), (SlotDisplay)ingredients.get(i2));
                    }
                    this.recipe = recipeItems;
                } else if (display instanceof ShapelessCraftingRecipeDisplay) {
                    ShapelessCraftingRecipeDisplay shapelessRecipe = (ShapelessCraftingRecipeDisplay)display;
                    this.recipe = new ArrayList<SlotDisplay>(shapelessRecipe.ingredients());
                }
            } else if (pageGroup.hasRecipeGrid()) {
                ContextMap contextMap = SlotDisplayContext.fromLevel((Level)Minecraft.getInstance().level);
                HashMap<Integer, ItemStack[]> recipeStacks = new HashMap<Integer, ItemStack[]>();
                List<Item> pageItems = pageGroup.getItems().stream().map(ItemStack::getItem).toList();
                for (int i3 = 0; i3 < 9; ++i3) {
                    recipeStacks.put(i3, new ItemStack[pageItems.size()]);
                }
                int stacksLeft = pageItems.size();
                for (RecipeDisplay recipeDisplay : displayList) {
                    int indexToAddAt;
                    int i4;
                    List ingredients;
                    if (stacksLeft == 0) break;
                    if (recipeDisplay instanceof ShapedCraftingRecipeDisplay) {
                        ShapedCraftingRecipeDisplay shapedRecipe = (ShapedCraftingRecipeDisplay)recipeDisplay;
                        ingredients = shapedRecipe.ingredients();
                        for (i4 = 0; i4 < ingredients.size(); ++i4) {
                            List items = ((SlotDisplay)ingredients.get(i4)).resolveForStacks(contextMap);
                            if (items.isEmpty()) continue;
                            indexToAddAt = pageItems.indexOf(shapedRecipe.result().resolveForFirstStack(contextMap).getItem());
                            ((ItemStack[])recipeStacks.get((Object)Integer.valueOf((int)this.getCraftMatrixPosition((int)i4, (int)shapedRecipe.width(), (int)shapedRecipe.height()))))[indexToAddAt] = (ItemStack)items.get(0);
                        }
                        --stacksLeft;
                        continue;
                    }
                    if (!(recipeDisplay instanceof ShapelessCraftingRecipeDisplay)) continue;
                    ShapelessCraftingRecipeDisplay shapelessRecipe = (ShapelessCraftingRecipeDisplay)recipeDisplay;
                    ingredients = shapelessRecipe.ingredients();
                    for (i4 = 0; i4 < ingredients.size(); ++i4) {
                        ItemStack firstItem = ((SlotDisplay)ingredients.get(i4)).resolveForFirstStack(contextMap);
                        if (firstItem.isEmpty()) continue;
                        indexToAddAt = pageItems.indexOf(shapelessRecipe.result().resolveForFirstStack(contextMap).getItem());
                        ((ItemStack[])recipeStacks.get((Object)Integer.valueOf((int)i4)))[indexToAddAt] = firstItem;
                    }
                    --stacksLeft;
                }
                this.recipe = Arrays.asList((SlotDisplay[])Util.make((Object)new SlotDisplay[9], array -> Arrays.fill(array, SlotDisplay.Empty.INSTANCE)));
                recipeStacks.forEach((i, stackArray) -> this.recipe.set((int)i, (SlotDisplay)new SlotDisplay.Composite(Arrays.stream(stackArray).map(stack -> stack == null ? SlotDisplay.Empty.INSTANCE : new SlotDisplay.ItemStackSlotDisplay(stack)).toList())));
            }
        });
        if (page.hasRecipeDescription()) {
            String name = Utils.getRegistryName(page.item()).getPath();
            this.hoverCheckers.add(new TextHoverChecker(144, 200, this.startX + 100, this.startX + 100 + 40 + 16, (Component)Utils.localize("gui.securitycraft:scManual.recipe." + name, new Object[0])));
        } else if (pageGroup == PageGroup.REINFORCED || item == ((ReinforcedHopperBlock)SCContent.REINFORCED_HOPPER.get()).asItem()) {
            this.recipe = null;
            this.hoverCheckers.add(new TextHoverChecker(144, 200, this.startX + 100, this.startX + 100 + 40 + 16, (Component)Utils.localize("gui.securitycraft:scManual.recipe.reinforced", new Object[0])));
        } else if (this.recipe != null) {
            for (int row = 0; row < 3; ++row) {
                for (int column = 0; column < 3; ++column) {
                    this.hoverCheckers.add(new HoverChecker(144 + row * 19, 144 + row * 19 + 16, this.startX + 101 + column * 19, this.startX + 101 + column * 19 + 16));
                }
            }
        } else {
            this.hoverCheckers.add(new TextHoverChecker(144, 200, this.startX + 100, this.startX + 100 + 40 + 16, (Component)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0])));
        }
        this.pageTitle = page.title();
        if (pageGroup != PageGroup.NONE) {
            this.pageIcon.setStacks(pageGroup.getItems());
        } else {
            this.pageIcon.setStacks(List.of(new ItemStack((ItemLike)page.item())));
        }
        this.resetBlockEntityInfo();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            Block block = blockItem.getBlock();
            this.explosive = block instanceof IExplosive;
            if (this.explosive) {
                this.hoverCheckers.add(new TextHoverChecker(118, 134, this.startX + 107, this.startX + 107 + 16, (Component)Utils.localize("gui.securitycraft:scManual.explosiveBlock", new Object[0])));
            }
        }
        if ((inWorldObject = page.getInWorldObject()) != null) {
            IModuleInventory moduleInv;
            ICustomizable customizableObj;
            Option<?>[] options;
            this.ownable = inWorldObject instanceof IOwnable;
            this.passcodeProtected = inWorldObject instanceof IPasscodeProtected;
            this.viewActivated = inWorldObject instanceof IViewActivated;
            this.lockable = inWorldObject instanceof ILockable;
            if (this.ownable) {
                this.hoverCheckers.add(new TextHoverChecker(118, 134, this.startX + 29, this.startX + 29 + 16, (Component)Utils.localize("gui.securitycraft:scManual.ownableBlock", new Object[0])));
            }
            if (this.passcodeProtected) {
                this.hoverCheckers.add(new TextHoverChecker(118, 134, this.startX + 55, this.startX + 55 + 16, (Component)Utils.localize("gui.securitycraft:scManual.passcodeProtectedBlock", new Object[0])));
            }
            if (this.viewActivated) {
                this.hoverCheckers.add(new TextHoverChecker(118, 134, this.startX + 81, this.startX + 81 + 16, (Component)Utils.localize("gui.securitycraft:scManual.viewActivatedBlock", new Object[0])));
            }
            if (inWorldObject instanceof ICustomizable && (options = (customizableObj = (ICustomizable)inWorldObject).customOptions()).length > 0) {
                ModuleType[] display = new ArrayList();
                this.hasOptions = true;
                display.add(Utils.localize("gui.securitycraft:scManual.options", new Object[0]));
                display.add(Component.literal((String)"---"));
                Option<?>[] optionArray = options;
                int n = optionArray.length;
                for (int i = 0; i < n; ++i) {
                    Option<?> option = optionArray[i];
                    display.add(Component.translatable((String)"gui.securitycraft:scManual.option_text", (Object[])new Object[]{Component.translatable((String)option.getDescriptionKey(Utils.getLanguageKeyDenotation(customizableObj))), option.getDefaultInfo()}));
                    display.add(Component.empty());
                }
                display.remove(display.size() - 1);
                this.hoverCheckers.add(new TextHoverChecker(118, 134, this.startX + 136, this.startX + 136 + 16, (List<? extends Component>)display));
            }
            if (inWorldObject instanceof IModuleInventory && (moduleInv = (IModuleInventory)inWorldObject).acceptedModules() != null && moduleInv.acceptedModules().length > 0) {
                ArrayList<MutableComponent> display = new ArrayList<MutableComponent>();
                this.hasModules = true;
                display.add(Utils.localize("gui.securitycraft:scManual.modules", new Object[0]));
                display.add(Component.literal((String)"---"));
                for (ModuleType module : moduleInv.acceptedModules()) {
                    display.add(Component.literal((String)"- ").append((Component)Utils.localize(moduleInv.getModuleDescriptionId(Utils.getLanguageKeyDenotation(moduleInv), module), new Object[0])));
                    display.add(Component.empty());
                }
                display.remove(display.size() - 1);
                this.hoverCheckers.add(new TextHoverChecker(118, 134, this.startX + 163, this.startX + 163 + 16, display));
            }
            if (this.lockable) {
                this.hoverCheckers.add(new TextHoverChecker(118, 134, this.startX + 189, this.startX + 189 + 16, (Component)Utils.localize("gui.securitycraft:scManual.lockable", new Object[0])));
            }
            if (this.hasOptions || this.hasModules) {
                this.hoverCheckers.add(new TextHoverChecker(118, 134, this.startX + 213, this.startX + 213 + 16, (Component)Utils.localize("gui.securitycraft:scManual.customizableBlock", new Object[0])));
            }
        }
        if (this.recipe != null && !this.recipe.isEmpty()) {
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    int index = i * 3 + j;
                    if (index >= this.recipe.size()) {
                        this.displays[index].setStacks(null);
                        continue;
                    }
                    this.displays[index].setStacks(this.recipe.get(index).resolveForStacks(SlotDisplayContext.fromLevel((Level)Minecraft.getInstance().level)));
                }
            }
        } else {
            for (ItemStacksDisplay display : this.displays) {
                display.setStacks(null);
            }
        }
        this.subpages = this.font.getSplitter().splitLines((FormattedText)page.helpInfo(), 1285, Style.EMPTY);
        this.nextSubpage.visible = this.currentPage != -1 && this.subpages.size() > 1;
        this.previousSubpage.visible = this.currentPage != -1 && this.subpages.size() > 1;
    }

    private void resetBlockEntityInfo() {
        this.explosive = false;
        this.ownable = false;
        this.passcodeProtected = false;
        this.viewActivated = false;
        this.hasOptions = false;
        this.lockable = false;
        this.hasModules = false;
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
        if (this.patronList != null) {
            this.patronList.mouseClicked(event, doubleClick);
        }
        return super.mouseClicked(event, doubleClick);
    }

    public boolean mouseReleased(MouseButtonEvent event) {
        if (this.patronList != null) {
            this.patronList.mouseReleased(event);
        }
        return super.mouseReleased(event);
    }

    private int getCraftMatrixPosition(int i, int width, int height) {
        int index;
        if (width == 1) {
            index = height == 3 ? i * 3 + 1 : (height == 2 ? i * 3 + 1 : 4);
        } else if (height == 1) {
            index = i + 3;
        } else if (width == 2) {
            index = i;
            if (i > 1) {
                ++index;
                if (i > 3) {
                    ++index;
                }
            }
        } else {
            index = height == 2 ? i + 3 : i;
        }
        return index;
    }

    static class HyperlinkButton
    extends Button.Plain {
        public HyperlinkButton(int xPos, int yPos, int width, int height, Component displayString, Button.OnPress handler) {
            super(xPos, yPos, width, height, displayString, handler, s -> Component.empty());
        }

        public void renderContents(GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
            this.isHovered = mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.width && mouseY < this.getY() + this.height;
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, this.isHoveredOrFocused() ? LINK_OUT_HIGHLIGHTED_SPRITE : LINK_OUT_SPRITE, this.getX(), this.getY(), 16, 16);
        }
    }

    class PatronList
    extends ScrollPanel {
        private static final String PATRON_LIST_LINK = FMLEnvironment.isProduction() ? "https://gist.githubusercontent.com/bl4ckscor3/bdda6596012b1206816db034350b5717/raw" : "https://gist.githubusercontent.com/bl4ckscor3/3196e6740774e386871a74a9606eaa61/raw";
        private static final int SLOT_HEIGHT = 12;
        private final ExecutorService executor;
        private Future<List<String>> patronRequestFuture;
        private List<String> patrons;
        private boolean patronsAvailable;
        private boolean error;
        private boolean patronsRequested;
        private final List<FormattedCharSequence> fetchErrorLines;
        private final List<FormattedCharSequence> noPatronsLines;
        private final Component loadingText;

        public PatronList(Minecraft client, int width, int height, int top, int left) {
            super(client, width, height, top, left, 4, 6, -7437712, -8359851, -3031135);
            this.executor = Executors.newSingleThreadExecutor();
            this.patrons = new ArrayList<String>();
            this.patronsAvailable = false;
            this.error = false;
            this.loadingText = Utils.localize("gui.securitycraft:scManual.patreon.loading", new Object[0]);
            this.fetchErrorLines = SCManualScreen.this.font.split((FormattedText)Utils.localize("gui.securitycraft:scManual.patreon.error", new Object[0]), width);
            this.noPatronsLines = SCManualScreen.this.font.split((FormattedText)Utils.localize("advancements.empty", new Object[0]), width - 10);
        }

        protected int getContentHeight() {
            int n = this.patrons.size();
            Objects.requireNonNull(SCManualScreen.this.font);
            int height = n * (9 + 3);
            if (height < this.bottom - this.top - 4) {
                height = this.bottom - this.top - 4;
            }
            return height;
        }

        public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            if (SCManualScreen.this.currentPage == -1) {
                if (this.patronsAvailable) {
                    super.render(guiGraphics, mouseX, mouseY, partialTicks);
                    int mouseListY = (int)((float)(mouseY - this.top) + this.scrollDistance - (float)this.border);
                    int slotIndex = mouseListY / 12;
                    if (mouseX >= this.left && mouseX < this.right - 6 && slotIndex >= 0 && mouseListY >= 0 && slotIndex < this.patrons.size() && mouseY >= this.top && mouseY <= this.bottom) {
                        String patron = this.patrons.get(slotIndex);
                        int length = SCManualScreen.this.font.width(patron);
                        int baseY = this.top + this.border - (int)this.scrollDistance;
                        if (length >= this.width - 6) {
                            guiGraphics.setTooltipForNextFrame(SCManualScreen.this.font, (Component)Component.literal((String)patron), this.left - 10, baseY + (12 * slotIndex + 12));
                        }
                    }
                    if (this.patrons.isEmpty()) {
                        for (int i = 0; i < this.noPatronsLines.size(); ++i) {
                            FormattedCharSequence line = this.noPatronsLines.get(i);
                            guiGraphics.drawString(SCManualScreen.this.font, line, this.left + this.width / 2 - SCManualScreen.this.font.width(line) / 2, this.top + 30 + i * 10, -13421773, false);
                        }
                    }
                } else if (this.error) {
                    for (int i = 0; i < this.fetchErrorLines.size(); ++i) {
                        FormattedCharSequence line = this.fetchErrorLines.get(i);
                        guiGraphics.drawString(SCManualScreen.this.font, line, this.left + this.width / 2 - SCManualScreen.this.font.width(line) / 2, this.top + 30 + i * 10, -5242623, false);
                    }
                } else if (this.patronRequestFuture != null && this.patronRequestFuture.isDone()) {
                    try {
                        this.patrons = this.patronRequestFuture.get();
                        this.executor.shutdown();
                        this.patronsAvailable = true;
                    }
                    catch (InterruptedException | ExecutionException e) {
                        this.error = true;
                    }
                } else {
                    guiGraphics.drawString(SCManualScreen.this.font, this.loadingText, this.left + this.width / 2 - SCManualScreen.this.font.width((FormattedText)this.loadingText) / 2, this.top + 30, -16777216, false);
                }
            }
        }

        protected void drawPanel(GuiGraphics guiGraphics, int entryRight, int relativeY, int mouseX, int mouseY) {
            for (int i = 0; i < this.patrons.size(); ++i) {
                String patron = this.patrons.get(i);
                if (patron == null || patron.isEmpty()) continue;
                guiGraphics.drawString(SCManualScreen.this.font, patron, this.left + 2, relativeY + 12 * i, -16777216, false);
            }
        }

        public void fetchPatrons() {
            if (!this.patronsRequested) {
                this.patronRequestFuture = this.executor.submit(() -> {
                    List<String> list;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(new URL(PATRON_LIST_LINK).openStream()));
                    try {
                        list = reader.lines().toList();
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            this.error = true;
                            return new ArrayList();
                        }
                    }
                    reader.close();
                    return list;
                });
                this.patronsRequested = true;
            }
        }

        public boolean isMouseOver(double mouseX, double mouseY) {
            return SCManualScreen.this.currentPage == -1 && super.isMouseOver(mouseX, mouseY);
        }

        public NarratableEntry.NarrationPriority narrationPriority() {
            return NarratableEntry.NarrationPriority.NONE;
        }

        public void updateNarration(NarrationElementOutput narrationElementOutput) {
        }
    }

    static class ChangePageButton
    extends Button.Plain {
        private final Identifier normalSprite;
        private final Identifier highlightedSprite;

        public ChangePageButton(int xPos, int yPos, Identifier normalSprite, Identifier highlightedSprite, Button.OnPress onPress) {
            super(xPos, yPos, 23, 13, (Component)Component.empty(), onPress, DEFAULT_NARRATION);
            this.normalSprite = normalSprite;
            this.highlightedSprite = highlightedSprite;
        }

        public void renderContents(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, this.isHoveredOrFocused() ? this.highlightedSprite : this.normalSprite, this.getX(), this.getY(), 23, 13);
        }
    }
}

