/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.platform.InputConstants;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.UsernameLoggerBlockEntity;
import net.geforcemods.securitycraft.network.server.ClearLoggerServer;
import net.geforcemods.securitycraft.screen.components.SmallButton;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.client.gui.widget.ScrollPanel;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;

public class UsernameLoggerScreen
extends Screen {
    private static final Identifier TEXTURE = SecurityCraft.resLoc("textures/gui/container/blank.png");
    private final Component logged = Utils.localize("gui.securitycraft:logger.logged", new Object[0]);
    private int imageWidth = 176;
    private int imageHeight = 166;
    private int leftPos;
    private int topPos;
    private UsernameLoggerBlockEntity be;
    private PlayerList playerList;

    public UsernameLoggerScreen(UsernameLoggerBlockEntity be) {
        super(be.getDisplayName());
        this.be = be;
    }

    protected void init() {
        super.init();
        this.leftPos = (this.width - this.imageWidth) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
        Button clearButton = (Button)this.addRenderableWidget((GuiEventListener)SmallButton.createWithX(this.leftPos + 4, this.topPos + 4, b -> {
            this.be.setPlayers(new String[100]);
            ClientPacketDistributor.sendToServer((CustomPacketPayload)new ClearLoggerServer(this.be.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }));
        clearButton.active = this.be.isOwnedBy((Entity)this.minecraft.player);
        clearButton.setTooltip(Tooltip.create((Component)Utils.localize("gui.securitycraft:editModule.clear", new Object[0])));
        this.playerList = (PlayerList)this.addRenderableWidget((GuiEventListener)new PlayerList(this.minecraft, this.imageWidth - 24, this.imageHeight - 40, this.topPos + 20, this.leftPos + 12));
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.drawString(this.font, this.logged, this.width / 2 - this.font.width((FormattedText)this.logged) / 2, this.topPos + 6, -12566464, false);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderTransparentBackground(guiGraphics);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
        if (this.playerList != null) {
            this.playerList.mouseClicked(event, doubleClick);
        }
        return super.mouseClicked(event, doubleClick);
    }

    public boolean mouseReleased(MouseButtonEvent event) {
        if (this.playerList != null) {
            this.playerList.mouseReleased(event);
        }
        return super.mouseReleased(event);
    }

    public boolean keyPressed(KeyEvent event) {
        if (this.minecraft.options.keyInventory.isActiveAndMatches(InputConstants.getKey((KeyEvent)event))) {
            this.onClose();
            return true;
        }
        return super.keyPressed(event);
    }

    public boolean isPauseScreen() {
        return false;
    }

    class PlayerList
    extends ScrollPanel {
        private final DateFormat dateFormat;
        private static final int SLOT_HEIGHT = 12;
        private static final int LIST_LENGTH = 100;

        public PlayerList(Minecraft client, int width, int height, int top, int left) {
            super(client, width, height, top, left);
            this.dateFormat = DateFormat.getDateTimeInstance(2, 2, Locale.getDefault());
        }

        protected int getContentHeight() {
            int n = UsernameLoggerScreen.this.be.getPlayers().length;
            Objects.requireNonNull(UsernameLoggerScreen.this.font);
            int height = n * (9 + 3);
            if (height < this.bottom - this.top - 4) {
                height = this.bottom - this.top - 4;
            }
            return height;
        }

        protected void drawBackground(GuiGraphics guiGraphics, float partialTick) {
            this.drawGradientRect(guiGraphics, this.left, this.top, this.right, this.bottom, -1072689136, -804253680);
        }

        public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            super.render(guiGraphics, mouseX, mouseY, partialTicks);
            if (UsernameLoggerScreen.this.be.isOwnedBy((Entity)((UsernameLoggerScreen)UsernameLoggerScreen.this).minecraft.player)) {
                String[] players;
                int mouseListY = (int)((float)(mouseY - this.top) + this.scrollDistance - (float)this.border);
                int slotIndex = mouseListY / 12;
                if (mouseX >= this.left && mouseX < this.right - 6 && slotIndex >= 0 && mouseListY >= 0 && slotIndex < 100 && mouseY >= this.top && mouseY <= this.bottom && (players = UsernameLoggerScreen.this.be.getPlayers())[slotIndex] != null && !players[slotIndex].isEmpty()) {
                    MutableComponent localized = Utils.localize("gui.securitycraft:logger.date", this.dateFormat.format(new Date(UsernameLoggerScreen.this.be.getTimestamps()[slotIndex])));
                    String[] uuids = UsernameLoggerScreen.this.be.getUuids();
                    if (uuids[slotIndex] != null && !uuids[slotIndex].isEmpty()) {
                        guiGraphics.setTooltipForNextFrame(UsernameLoggerScreen.this.font, (Component)Component.literal((String)UsernameLoggerScreen.this.be.getUuids()[slotIndex]), mouseX, mouseY);
                    }
                    guiGraphics.drawString(UsernameLoggerScreen.this.font, (Component)localized, UsernameLoggerScreen.this.leftPos + (UsernameLoggerScreen.this.imageWidth / 2 - UsernameLoggerScreen.this.font.width((FormattedText)localized) / 2), this.bottom + 5, -12566464, false);
                }
            }
        }

        protected void drawPanel(GuiGraphics guiGraphics, int entryRight, int relativeY, int mouseX, int mouseY) {
            String[] players;
            int baseY = this.top + this.border - (int)this.scrollDistance;
            int slotBuffer = 8;
            int mouseListY = (int)((float)(mouseY - this.top) + this.scrollDistance - (float)this.border);
            int slotIndex = mouseListY / 12;
            if (mouseX >= this.left && mouseX <= this.right - 6 && slotIndex >= 0 && mouseListY >= 0 && slotIndex < 100 && mouseY >= this.top && mouseY <= this.bottom && (players = UsernameLoggerScreen.this.be.getPlayers())[slotIndex] != null && !players[slotIndex].isEmpty()) {
                int min = this.left;
                int max = entryRight - 6;
                int slotTop = baseY + slotIndex * 12;
                guiGraphics.fill(min, slotTop - 2, max, slotTop + slotBuffer + 2, -8355712);
                guiGraphics.fill(min + 1, slotTop - 1, max - 1, slotTop + slotBuffer + 1, -16777216);
            }
            for (int i = 0; i < UsernameLoggerScreen.this.be.getPlayers().length; ++i) {
                if (UsernameLoggerScreen.this.be.getPlayers()[i] == null || UsernameLoggerScreen.this.be.getPlayers()[i].equals("")) continue;
                guiGraphics.drawString(UsernameLoggerScreen.this.font, UsernameLoggerScreen.this.be.getPlayers()[i], this.left + this.width / 2 - UsernameLoggerScreen.this.font.width(UsernameLoggerScreen.this.be.getPlayers()[i]) / 2, relativeY + 12 * i, -3750202, false);
            }
        }

        public NarratableEntry.NarrationPriority narrationPriority() {
            return NarratableEntry.NarrationPriority.NONE;
        }

        public void updateNarration(NarrationElementOutput narrationElementOutput) {
        }
    }
}

