/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen.components;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.function.Function;
import net.geforcemods.securitycraft.screen.components.GuiBlockModelRenderState;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.render.pip.PictureInPictureRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.feature.FeatureRenderDispatcher;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.RenderTypeHelper;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class GuiBlockModelRenderer
extends PictureInPictureRenderer<GuiBlockModelRenderState> {
    private static final Quaternionf DEFAULT_ROTATION = ClientUtils.fromXYZDegrees(-15.0f, -135.0f, 0.0f).mul((Quaternionfc)Axis.XP.rotationDegrees(180.0f));

    public GuiBlockModelRenderer(MultiBufferSource.BufferSource buffer) {
        super(buffer);
    }

    public Class<GuiBlockModelRenderState> getRenderStateClass() {
        return GuiBlockModelRenderState.class;
    }

    protected void renderToTexture(GuiBlockModelRenderState guiRenderState, PoseStack pose) {
        Minecraft mc = Minecraft.getInstance();
        BlockEntityRenderer beRenderer = guiRenderState.beRenderer();
        pose.scale(-24.0f, 24.0f, -24.0f);
        pose.translate(0.5f, -1.5f, 0.5f);
        pose.mulPose((Quaternionfc)DEFAULT_ROTATION);
        pose.mulPose((Quaternionfc)guiRenderState.rotation());
        pose.translate(-0.5f, -0.5f, -0.5f);
        mc.gameRenderer.getLighting().setupFor(Lighting.Entry.ENTITY_IN_UI);
        this.renderBlockModel(mc, guiRenderState.blockAndTintGetter(), guiRenderState.blockState(), pose, (MultiBufferSource)this.bufferSource);
        if (beRenderer != null) {
            BlockEntityRenderState beRenderState = beRenderer.createRenderState();
            FeatureRenderDispatcher featureRenderDispatcher = mc.gameRenderer.getFeatureRenderDispatcher();
            beRenderer.extractRenderState(guiRenderState.be(), beRenderState, mc.getDeltaTracker().getGameTimeDeltaPartialTick(true), mc.gameRenderer.getMainCamera().position(), null);
            beRenderState.lightCoords = 0xF000F0;
            beRenderer.submit(beRenderState, pose, (SubmitNodeCollector)featureRenderDispatcher.getSubmitNodeStorage(), mc.levelRenderer.levelRenderState.cameraRenderState);
            featureRenderDispatcher.renderAllFeatures();
        }
    }

    protected String getTextureLabel() {
        return "SC block model";
    }

    private void renderBlockModel(Minecraft mc, BlockAndTintGetter blockAndTintGetter, BlockState state, PoseStack pose, MultiBufferSource bufferSource) {
        if (state.getRenderShape() == RenderShape.MODEL) {
            BlockRenderDispatcher blockRenderer = mc.getBlockRenderer();
            BlockStateModel blockModel = blockRenderer.getBlockModel(state);
            Function<ChunkSectionLayer, RenderType> toRenderType = RenderTypeHelper::getMovingBlockRenderType;
            blockRenderer.getModelRenderer().tesselateWithoutAO(blockAndTintGetter, blockModel.collectParts((BlockAndTintGetter)mc.level, BlockPos.ZERO, state, RandomSource.create((long)42L)), state, BlockPos.ZERO, pose, toRenderType.andThen(arg_0 -> ((MultiBufferSource)bufferSource).getBuffer(arg_0)), false, OverlayTexture.NO_OVERLAY);
        }
    }
}

