/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import net.geforcemods.securitycraft.SecurityCraft;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3fc;
import org.joml.Matrix4fc;

public class BlockEntityRenderDelegate {
    private final Map<BlockPos, DelegateRendererInfo> renderDelegates = new HashMap<BlockPos, DelegateRendererInfo>();

    public void putDelegateFor(BlockEntity originalBlockEntity, BlockState delegateState, ItemStack stack) {
        BlockPos pos = originalBlockEntity.getBlockPos();
        if (this.renderDelegates.containsKey(pos)) {
            DelegateRendererInfo delegateInfo = this.renderDelegates.get(pos);
            if (delegateInfo.delegateBlockEntity.getBlockState().getBlock() == delegateState.getBlock()) {
                delegateInfo.delegateBlockEntity.setBlockState(delegateState);
                return;
            }
        }
        if (delegateState != null && delegateState.hasBlockEntity()) {
            Minecraft mc = Minecraft.getInstance();
            BlockEntity delegateBe = ((EntityBlock)delegateState.getBlock()).newBlockEntity(BlockPos.ZERO, delegateState);
            if (delegateBe != null) {
                delegateBe.setLevel((Level)mc.level);
                delegateBe.applyComponentsFromItemStack(stack);
                BlockEntityRenderer delegateBeRenderer = mc.getBlockEntityRenderDispatcher().getRenderer(delegateBe);
                if (delegateBeRenderer != null) {
                    this.renderDelegates.put(pos, new DelegateRendererInfo(delegateBe, delegateBeRenderer));
                }
            }
        }
    }

    public void removeDelegateOf(BlockEntity originalBlockEntity) {
        this.renderDelegates.remove(originalBlockEntity.getBlockPos());
    }

    public <T extends BlockEntity, S extends BlockEntityRenderState> BlockEntityRenderState tryExtractFromDelegate(BlockEntity originalBlockEntity, float partialTick, Vec3 cameraPos, ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        BlockPos pos = originalBlockEntity.getBlockPos();
        DelegateRendererInfo delegateRendererInfo = this.renderDelegates.get(pos);
        if (delegateRendererInfo != null) {
            BlockEntity delegateBlockEntity = delegateRendererInfo.delegateBlockEntity();
            if (delegateBlockEntity == originalBlockEntity) {
                return null;
            }
            BlockEntityRenderer delegateRenderer = delegateRendererInfo.delegateRenderer();
            BlockEntityRenderState delegateState = delegateRenderer.createRenderState();
            BlockPos previousPos = delegateBlockEntity.worldPosition;
            delegateBlockEntity.worldPosition = pos;
            delegateRenderer.extractRenderState(delegateRendererInfo.delegateBlockEntity(), delegateState, partialTick, cameraPos, crumblingOverlay);
            delegateBlockEntity.worldPosition = previousPos;
            return delegateState;
        }
        return null;
    }

    public boolean trySubmitDelegate(BlockEntityRenderState delegateState, PoseStack pose, SubmitNodeCollector collector, CameraRenderState camera) {
        DelegateRendererInfo delegateRendererInfo;
        if (delegateState != null && (delegateRendererInfo = this.renderDelegates.get(delegateState.blockPos)) != null) {
            try {
                PoseStack copyPose = new PoseStack();
                copyPose.pushPose();
                copyPose.last().pose().mul((Matrix4fc)pose.last().pose());
                copyPose.last().normal().mul((Matrix3fc)pose.last().normal());
                delegateRendererInfo.delegateRenderer().submit(delegateState, pose, collector, camera);
                copyPose.popPose();
            }
            catch (Exception e) {
                SecurityCraft.LOGGER.warn("Error when delegate-rendering {}", (Object)BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey((Object)delegateRendererInfo.delegateBlockEntity().getType()));
                e.printStackTrace();
                this.renderDelegates.remove(delegateState.blockPos);
            }
            return true;
        }
        return false;
    }

    private record DelegateRendererInfo(BlockEntity delegateBlockEntity, BlockEntityRenderer delegateRenderer) {
    }
}

