/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import java.util.Arrays;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class ClientUtils {
    private static final Identifier[] MODULE_TEXTURES = new Identifier[]{SecurityCraft.resLoc("textures/item/module_background.png"), SecurityCraft.resLoc("textures/item/whitelist_module.png"), SecurityCraft.resLoc("textures/item/blacklist_module.png"), SecurityCraft.resLoc("textures/item/harming_module.png"), SecurityCraft.resLoc("textures/item/smart_module.png"), SecurityCraft.resLoc("textures/item/storage_module.png"), SecurityCraft.resLoc("textures/item/disguise_module.png"), SecurityCraft.resLoc("textures/item/module_background.png")};
    private static final Identifier REDSTONE_TEXTURE = SecurityCraft.mcResLoc("textures/item/redstone.png");
    private static final Identifier SUGAR_TEXTURE = SecurityCraft.mcResLoc("textures/item/sugar.png");

    private ClientUtils() {
    }

    public static void renderModuleInfo(GuiGraphics guiGraphics, Font font, ModuleType module, Component moduleTooltip, boolean isModuleInstalled, int moduleLeft, int moduleTop, int mouseX, int mouseY) {
        Minecraft mc = Minecraft.getInstance();
        int color = isModuleInstalled ? -1 : Integer.MAX_VALUE;
        int moduleRight = moduleLeft + 16;
        int moduleBottom = moduleTop + 16;
        ClientUtils.drawTexture(guiGraphics, MODULE_TEXTURES[module.ordinal()], moduleLeft, moduleTop, color);
        if (module == ModuleType.REDSTONE) {
            ClientUtils.drawTexture(guiGraphics, REDSTONE_TEXTURE, moduleLeft, moduleTop, color);
        } else if (module == ModuleType.SPEED) {
            ClientUtils.drawTexture(guiGraphics, SUGAR_TEXTURE, moduleLeft, moduleTop, color);
        }
        if (moduleTooltip != null && mouseX >= moduleLeft && mouseX < moduleRight && mouseY >= moduleTop && mouseY <= moduleBottom && mc.screen != null) {
            guiGraphics.setComponentTooltipForNextFrame(font, Arrays.asList(moduleTooltip), mouseX, mouseY);
        }
    }

    private static void drawTexture(GuiGraphics guiGraphics, Identifier texture, int moduleLeft, int moduleTop, int color) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, texture, moduleLeft, moduleTop, 0.0f, 0.0f, 16, 16, 16, 16, color);
    }

    public static Quaternionf fromXYZDegrees(float x, float y, float z) {
        return ClientUtils.fromXYZ((float)Math.toRadians(x), (float)Math.toRadians(y), (float)Math.toRadians(z));
    }

    public static Quaternionf fromXYZ(float x, float y, float z) {
        Quaternionf quaternion = new Quaternionf();
        quaternion.mul((Quaternionfc)new Quaternionf((float)Math.sin(x / 2.0f), 0.0f, 0.0f, (float)Math.cos(x / 2.0f)));
        quaternion.mul((Quaternionfc)new Quaternionf(0.0f, (float)Math.sin(y / 2.0f), 0.0f, (float)Math.cos(y / 2.0f)));
        quaternion.mul((Quaternionfc)new Quaternionf(0.0f, 0.0f, (float)Math.sin(z / 2.0f), (float)Math.cos(z / 2.0f)));
        return quaternion;
    }

    public static int HSBtoRGB(float hue, float saturation, float brightness) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (saturation == 0.0f) {
            g = b = (int)(brightness * 255.0f + 0.5f);
            r = b;
        } else {
            float h = (hue - (float)Math.floor(hue)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t = brightness * (1.0f - saturation * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(t * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(q * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    public static float[] RGBtoHSB(int r, int g, int b) {
        float hue;
        int cmin;
        float[] hsb = new float[3];
        int cmax = r > g ? r : g;
        int n = cmin = r < g ? r : g;
        if (b > cmax) {
            cmax = b;
        }
        if (b < cmin) {
            cmin = b;
        }
        float brightness = (float)cmax / 255.0f;
        float saturation = cmax != 0 ? (float)(cmax - cmin) / (float)cmax : 0.0f;
        if (saturation == 0.0f) {
            hue = 0.0f;
        } else {
            float redc = (float)(cmax - r) / (float)(cmax - cmin);
            float greenc = (float)(cmax - g) / (float)(cmax - cmin);
            float bluec = (float)(cmax - b) / (float)(cmax - cmin);
            hue = r == cmax ? bluec - greenc : (g == cmax ? 2.0f + redc - bluec : 4.0f + greenc - redc);
            if ((hue /= 6.0f) < 0.0f) {
                hue += 1.0f;
            }
        }
        hsb[0] = hue;
        hsb[1] = saturation;
        hsb[2] = brightness;
        return hsb;
    }
}

