/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.defaultoptions.keys;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.Set;
import net.blay09.mods.balm.mixin.KeyMappingAccessor;
import net.blay09.mods.defaultoptions.PlatformBindings;
import net.blay09.mods.defaultoptions.keys.KeyModifier;
import net.minecraft.client.KeyMapping;

public record DefaultKeyMapping(InputConstants.Key input, Set<KeyModifier> modifiers) {
    public boolean matches(KeyMapping keyMapping) {
        Set<KeyModifier> keyModifiers = PlatformBindings.INSTANCE.getKeyModifiers(keyMapping);
        if (!this.modifiers.equals(keyModifiers)) {
            return false;
        }
        if (this.input.getValue() == InputConstants.UNKNOWN.getValue() && keyMapping.isUnbound()) {
            return true;
        }
        InputConstants.Key key = ((KeyMappingAccessor)keyMapping).getKey();
        switch (this.input.getType()) {
            case KEYSYM: {
                return key.getType() == InputConstants.Type.KEYSYM && key.getValue() == this.input.getValue();
            }
            case SCANCODE: {
                return key.getType() == InputConstants.Type.SCANCODE && key.getValue() == this.input.getValue();
            }
            case MOUSE: {
                return key.getType() == InputConstants.Type.MOUSE && key.getValue() == this.input.getValue();
            }
        }
        return false;
    }
}

