/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.common;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.Identifier;
import net.p3pp3rf1y.sophisticatedcore.common.IItemActionPayloadHandler;

public class ItemActionHandlerRegistry {
    public static final StreamCodec<ByteBuf, Map<Identifier, Object>> EXTRAS_STREAM_CODEC = new StreamCodec<ByteBuf, Map<Identifier, Object>>(){

        public void encode(ByteBuf buf, Map<Identifier, Object> extras) {
            buf.writeInt(extras.size());
            for (Map.Entry<Identifier, Object> e : extras.entrySet()) {
                Identifier id = e.getKey();
                ItemActionHandlerRegistry.get(id).ifPresent(h -> {
                    Identifier.STREAM_CODEC.encode((Object)buf, (Object)id);
                    1.encodeWith(h.codec(), e.getValue(), buf);
                });
            }
        }

        private static <T> void encodeWith(StreamCodec<ByteBuf, T> c, Object v, ByteBuf buf) {
            c.encode((Object)buf, v);
        }

        public Map<Identifier, Object> decode(ByteBuf buf) {
            int size = buf.readInt();
            LinkedHashMap<Identifier, Object> extras = new LinkedHashMap<Identifier, Object>(size);
            for (int i = 0; i < size; ++i) {
                Identifier id = (Identifier)Identifier.STREAM_CODEC.decode((Object)buf);
                ItemActionHandlerRegistry.get(id).ifPresent(h -> extras.put(id, h.codec().decode((Object)buf)));
            }
            return extras;
        }
    };
    private static final Map<Identifier, IItemActionPayloadHandler<?>> registry = new HashMap();

    private ItemActionHandlerRegistry() {
    }

    public static void register(IItemActionPayloadHandler<?> handler) {
        registry.put(handler.id(), handler);
    }

    public static Optional<IItemActionPayloadHandler<?>> get(Identifier id) {
        return Optional.ofNullable(registry.get(id));
    }
}

