/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.compat.chipped;

import earth.terrarium.chipped.common.recipes.ChippedRecipe;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.item.ItemStacksResourceHandler;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.compat.chipped.BlockTransformationUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.SimpleItemContent;

public class BlockTransformationUpgradeWrapper
extends UpgradeWrapperBase<BlockTransformationUpgradeWrapper, BlockTransformationUpgradeItem> {
    private final ResourceHandler<ItemResource> inputInventory;
    private final RecipeType<ChippedRecipe> recipeType;

    protected BlockTransformationUpgradeWrapper(IStorageWrapper storageWrapper, final ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(storageWrapper, upgrade, upgradeSaveHandler);
        this.inputInventory = new ItemStacksResourceHandler(1){

            protected void onContentsChanged(int slot, ItemStack previousContents) {
                super.onContentsChanged(slot, (Object)previousContents);
                if (slot == 0) {
                    upgrade.set(ModCoreDataComponents.INPUT_ITEM, (Object)SimpleItemContent.copyOf(((ItemResource)this.getResource(0)).toStack(this.getAmountAsInt(0))));
                }
                BlockTransformationUpgradeWrapper.this.save();
            }
        };
        ItemStack inputItem = ((SimpleItemContent)upgrade.getOrDefault(ModCoreDataComponents.INPUT_ITEM, (Object)SimpleItemContent.EMPTY)).copy();
        InventoryHelper.set(this.inputInventory, 0, ItemResource.of((ItemStack)inputItem), inputItem.getCount());
        this.recipeType = ((BlockTransformationUpgradeItem)this.upgradeItem).getRecipeType();
    }

    public ResourceHandler<ItemResource> getInputInventory() {
        return this.inputInventory;
    }

    public void setResult(ItemStack result) {
        if (result.isEmpty()) {
            this.upgrade.remove(ModCoreDataComponents.RESULT_ITEM);
            return;
        }
        this.upgrade.set(ModCoreDataComponents.RESULT_ITEM, (Object)SimpleItemContent.copyOf(result));
        this.save();
    }

    public Optional<SimpleItemContent> getResult() {
        return Optional.ofNullable((SimpleItemContent)this.upgrade.get(ModCoreDataComponents.RESULT_ITEM));
    }

    @Override
    public boolean canBeDisabled() {
        return false;
    }

    public boolean shouldShiftClickIntoStorage() {
        return (Boolean)this.upgrade.getOrDefault(ModCoreDataComponents.SHIFT_CLICK_INTO_STORAGE, (Object)true);
    }

    public void setShiftClickIntoStorage(boolean shiftClickIntoStorage) {
        this.upgrade.set(ModCoreDataComponents.SHIFT_CLICK_INTO_STORAGE, (Object)shiftClickIntoStorage);
        this.save();
    }

    public RecipeType<ChippedRecipe> getRecipeType() {
        return this.recipeType;
    }
}

