/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.inventory;

import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.transfer.IndexModifier;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.item.ItemStacksResourceHandler;

public class ComponentItemStacksHandler
extends ItemStacksResourceHandler
implements IndexModifier<ItemResource> {
    protected final MutableDataComponentHolder parent;
    protected final DataComponentType<ItemContainerContents> component;

    public ComponentItemStacksHandler(MutableDataComponentHolder parent, DataComponentType<ItemContainerContents> component, int size) {
        super(size);
        this.parent = parent;
        this.component = component;
        this.getContents().copyInto(this.stacks);
    }

    protected ItemContainerContents getContents() {
        return (ItemContainerContents)this.parent.getOrDefault(this.component, (Object)ItemContainerContents.EMPTY);
    }

    protected void onContentsChanged(int index, ItemStack previousContents) {
        super.onContentsChanged(index, (Object)previousContents);
        this.updateContents((ItemStack)this.stacks.get(index), index);
    }

    protected void updateContents(ItemStack stack, int slot) {
        this.stacks.set(slot, (Object)stack);
        this.parent.set(this.component, (Object)ItemContainerContents.fromItems((List)this.stacks));
    }

    public boolean isValid(int index, ItemResource resource) {
        ItemStack stack = resource.toStack();
        return stack.getItem().canFitInsideContainerItems(stack);
    }

    public ItemStack getStackInSlot(int slot) {
        return (ItemStack)this.stacks.get(slot);
    }
}

