/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.inventory;

import java.util.Collections;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;

public interface ISlotTracker {
    public void setShouldInsertIntoEmpty(BooleanSupplier var1);

    public Set<ItemStackKey> getFullStacks();

    public Set<Integer> getFullSlots(ItemStackKey var1);

    public Set<ItemStackKey> getPartialStacks();

    public Set<Item> getItems();

    public void removeAndSetSlotIndexes(InventoryHandler var1, int var2, ItemStack var3);

    public void clear();

    public void refreshSlotIndexesFrom(InventoryHandler var1);

    public void registerListeners(Consumer<ItemStackKey> var1, Consumer<ItemStackKey> var2, Runnable var3, Runnable var4);

    public void unregisterStackKeyListeners();

    public boolean hasEmptySlots();

    public boolean hasStackMemorizedOrFiltered(ItemStack var1);

    public int getFirstMatchingSlot(ItemStackKey var1);

    public Set<Integer> getPartialSlots(ItemStackKey var1);

    public Set<Integer> getEmptySlots();

    public static class Noop
    implements ISlotTracker {
        @Override
        public void setShouldInsertIntoEmpty(BooleanSupplier shouldInsertIntoEmpty) {
        }

        @Override
        public Set<ItemStackKey> getFullStacks() {
            return Collections.emptySet();
        }

        @Override
        public Set<ItemStackKey> getPartialStacks() {
            return Collections.emptySet();
        }

        @Override
        public Set<Item> getItems() {
            return Collections.emptySet();
        }

        @Override
        public void removeAndSetSlotIndexes(InventoryHandler inventoryHandler, int slot, ItemStack stack) {
        }

        @Override
        public void clear() {
        }

        @Override
        public void refreshSlotIndexesFrom(InventoryHandler itemHandler) {
        }

        @Override
        public void registerListeners(Consumer<ItemStackKey> onAddStackKey, Consumer<ItemStackKey> onRemoveStackKey, Runnable onAddFirstEmptySlot, Runnable onRemoveLastEmptySlot) {
        }

        @Override
        public void unregisterStackKeyListeners() {
        }

        @Override
        public boolean hasEmptySlots() {
            return false;
        }

        @Override
        public boolean hasStackMemorizedOrFiltered(ItemStack stack) {
            return false;
        }

        @Override
        public int getFirstMatchingSlot(ItemStackKey stackKey) {
            return -1;
        }

        @Override
        public Set<Integer> getPartialSlots(ItemStackKey key) {
            return Collections.emptySet();
        }

        @Override
        public Set<Integer> getEmptySlots() {
            return Collections.emptySet();
        }

        @Override
        public Set<Integer> getFullSlots(ItemStackKey key) {
            return Collections.emptySet();
        }
    }

    public static interface IItemHandlerInserter {
        public ItemStack insertItem(int var1, ItemStack var2, boolean var3);
    }
}

